//+------------------------------------------------------------------+
//| 5 Min RSI 12-period qual INDICATOR                               |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 8

#property indicator_color1 Red
#property indicator_color2 HotPink
#property indicator_color3 DarkGray
#property indicator_color4 Red

#property indicator_color5 White
#property indicator_color6 LightGray
#property indicator_color7 DarkGray
#property indicator_color8 White


//---- buffers
double Buffer1[];
double Buffer2[];
double Buffer3[];
double Buffer4[];
double Buffer5[];
double Buffer6[];
double Buffer7[];
double Buffer8[];


// User Input


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|

int init()
  {

   // 233 up arrow
   // 234 down arrow
   // 159 big dot
   // 158 little dot
   // 168 open square
   // 120 box with X
   
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, Buffer1);
   SetIndexArrow(0,159);
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, Buffer2);
   SetIndexArrow(1,158);

   SetIndexStyle(2,DRAW_ARROW);
   SetIndexBuffer(2, Buffer3);
   SetIndexArrow(2,112);

   SetIndexStyle(3,DRAW_ARROW);
   SetIndexBuffer(3, Buffer4);
   SetIndexArrow(3,120);

   SetIndexStyle(4,DRAW_ARROW);
   SetIndexBuffer(4, Buffer5);
   SetIndexArrow(4,159);

   SetIndexStyle(5,DRAW_ARROW);
   SetIndexBuffer(5, Buffer6);
   SetIndexArrow(5,158);

   SetIndexStyle(6,DRAW_ARROW);
   SetIndexBuffer(6, Buffer7);
   SetIndexArrow(6,112);

   SetIndexStyle(7,DRAW_ARROW);
   SetIndexBuffer(7, Buffer8);
   SetIndexArrow(7,120);

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   int i;
   
   for( i=0; i<Bars; i++ ) Buffer1[i]=0;
   for( i=0; i<Bars; i++ ) Buffer2[i]=0;
   for( i=0; i<Bars; i++ ) Buffer3[i]=0;
   for( i=0; i<Bars; i++ ) Buffer4[i]=0;
   for( i=0; i<Bars; i++ ) Buffer5[i]=0;
   for( i=0; i<Bars; i++ ) Buffer6[i]=0;
   for( i=0; i<Bars; i++ ) Buffer7[i]=0;
   for( i=0; i<Bars; i++ ) Buffer8[i]=0;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

// Current position if 55/45 or over/under. Does any of 
// the previous 'qual' period ever fall below55/above45? (last11)
//
// If qual*2 periods have been above55/below45
// then lets not try to transact any more (last22)
         

int start()
  {
   int      pos=Bars-100; // leave room for moving average periods
   int      ctr=0;

   double   cMAfst=0, pMAfst=0;
   double   cMAmid=0, pMAmid=0;
   double   cMAslo=0, pMAslo=0;
   double   MA100=0;
   
   bool     rising=false;
   bool    falling=false;
      
   double p=Point();
   
   while(pos>=1)
     {

      cMAfst=iMA(Symbol(),0,5  ,0,MODE_LWMA,PRICE_OPEN, pos);
      pMAfst=iMA(Symbol(),0,5  ,0,MODE_LWMA,PRICE_OPEN, pos+1);

      cMAmid=iMA(Symbol(),0,25 ,0,MODE_LWMA,PRICE_OPEN, pos);
      pMAmid=iMA(Symbol(),0,25 ,0,MODE_LWMA,PRICE_OPEN, pos+1);
      
      cMAslo=iMA(Symbol(),0,100,0,MODE_LWMA,PRICE_OPEN, pos);
      pMAslo=iMA(Symbol(),0,100,0,MODE_LWMA,PRICE_OPEN, pos+1);

      // rising
      if (pMAmid<=pMAslo && cMAmid>=cMAslo)
        {
         rising=true;
         falling=false;
         ctr=0;
        }

      //falling
      if (pMAmid>=pMAslo && cMAmid<=cMAslo)
        {
         rising=false;
         falling=true;
         ctr=0;
        }
      
      ctr++;
      if (ctr>30 && falling) {Buffer1[pos]=cMAmid;}
      if (ctr>30 && rising)  {Buffer5[pos]=cMAmid;}

 	   pos--;
     }

   return(0);
  }
//+------------------------------------------------------------------+