//+------------------------------------------------------------------+
//|                                                          3BP.mq4 |
//|                                                          Kalenzo |
//|                                      bartlomiej.gorski@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"
#property indicator_buffers 4

#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_color3 Green
#property indicator_color4 Red


#property indicator_chart_window
extern int limit = 500;

double hup[];
double hdn[];
double sup[];
double sdn[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexBuffer(0,hup);
   SetIndexBuffer(1,hdn);
   SetIndexBuffer(2,sup);
   SetIndexBuffer(3,sdn);
   
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,1,Green);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,1,Red);
   
   SetIndexStyle(2,DRAW_ARROW,EMPTY,1,Green);
   SetIndexStyle(3,DRAW_ARROW,EMPTY,1,Red);
   
   SetIndexArrow(2,233);
   SetIndexArrow(3,234);
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----

/*
Long signal: 2nd bar closes lower than the low of the
1st bar, 3rd bar closes higher than the high of the
2nd bar.

Short signal: 2nd bar closes higher than the high of
the 1st bar, 3rd bar closes lower than the low of the
2nd bar.
*/

   for(int i = limit; i >= 0 ; i--)
   {
      if(Close[i+2]<Low[i+3] && Close[i+1] > High[i+2])
      {
         hup[i+1] = High[i+1];
         hdn[i+1] = Low[i+1];
         
         hup[i+2] = High[i+2];
         hdn[i+2] = Low[i+2];
         
         hup[i+3] = High[i+3];
         hdn[i+3] = Low[i+3];
         
         sup[i] = Low[i]-3*Point;
         sdn[i] = EMPTY_VALUE;
         
      }
      else if(Close[i+2]>High[i+3] && Close[i+1] < Low[i+2])
      {
         hup[i+1] = Low[i+1];
         hdn[i+1] = High[i+1];
         
         hup[i+2] = Low[i+2];
         hdn[i+2] = High[i+2];
         
         hup[i+3] = Low[i+3];
         hdn[i+3] = High[i+3];
         
         sdn[i] = High[i]+3*Point;
         sup[i] = EMPTY_VALUE;
        
      }
      else
      {  
         hup[i] = EMPTY_VALUE;
         hdn[i] = EMPTY_VALUE; 
         
         sdn[i] = EMPTY_VALUE;
         sup[i] = EMPTY_VALUE;
      }
   }   
//----
   return(0);
  }
//+------------------------------------------------------------------+