//+------------------------------------------------------------------+
//|                                    accumulation-distribution.mq4 |
//|      Copyright  2011 Forex-indikatoren.com. All rights reserved |
//|                                 http://www.forex-indikatoren.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011 Forex-indikatoren.com."
#property link      "http://www.forex-indikatoren.com"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
//---- buffers
double ExtMapBuffer1[];
string Copyright="\xA9 WWW.FOREX-INDIKATOREN.COM";  
string MPrefix="FI";
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorShortName("A/D");
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
//----
   DL("001", Copyright, 5, 20,Gold,"Arial",10,0); 
   return(0);
  }
  
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   ClearObjects(); 
   return(0);
  }  
//+------------------------------------------------------------------+
//| Accumulation/Distribution                                        |
//+------------------------------------------------------------------+
int start()
  {
   int i,counted_bars=IndicatorCounted();
//----
   i=Bars-counted_bars-1;
   while(i>=0)
     {
      double high =High[i];
      double low  =Low[i];
      double open =Open[i];
      double close=Close[i];
      ExtMapBuffer1[i]=(close-low)-(high-close);
      if(ExtMapBuffer1[i]!=0)
        {
         double diff=high-low;
         if(0==diff)
            ExtMapBuffer1[i]=0;
         else
           {
            ExtMapBuffer1[i]/=diff;
            ExtMapBuffer1[i]*=Volume[i];
           }
        }
      if(i<Bars-1) ExtMapBuffer1[i]+=ExtMapBuffer1[i+1];
      i--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| DL function                                                      |
//+------------------------------------------------------------------+
 void DL(string label, string text, int x, int y, color clr, string FontName = "Arial",int FontSize = 12, int typeCorner = 1)
 
{
   string labelIndicator = MPrefix + label;   
   if (ObjectFind(labelIndicator) == -1)
   {
      ObjectCreate(labelIndicator, OBJ_LABEL, 0, 0, 0);
  }
   
   ObjectSet(labelIndicator, OBJPROP_CORNER, typeCorner);
   ObjectSet(labelIndicator, OBJPROP_XDISTANCE, x);
   ObjectSet(labelIndicator, OBJPROP_YDISTANCE, y);
   ObjectSetText(labelIndicator, text, FontSize, FontName, clr);
  
}  

//+------------------------------------------------------------------+
//| ClearObjects function                                            |
//+------------------------------------------------------------------+
void ClearObjects() 
{ 
  for(int i=0;i<ObjectsTotal();i++) 
  if(StringFind(ObjectName(i),MPrefix)==0) { ObjectDelete(ObjectName(i)); i--; } 
}
//+------------------------------------------------------------------+