//+------------------------------------------------------------------+
//|                                                      b-clock.mq4 |
//|                                     Core time code by Nick Bilak |
//|        http://metatrader.50webs.com/         beluck[at]gmail.com |
//|                                  modified by adoleh2000 and dwt5 | 
//+------------------------------------------------------------------+
//| b-clock_TRO_MODIFIED_VERSION                                  |
//| MODIFIED BY AVERY T. HORTON, JR. AKA THERUMPLEDONE@GMAIL.COM     |
//| I am NOT the ORIGINAL author 
//  and I am not claiming authorship of this indicator. 
//  All I did was modify it. I hope you find my modifications useful.|
//|                                                                  |
//+------------------------------------------------------------------+
 
#property copyright "Copyright  2005, Nick Bilak"
#property link      "http://metatrader.50webs.com/"

#property indicator_chart_window

extern int corner      = 2 ;
extern int x.offset    = 10 ; 
extern int y.offset    = 5; 
extern string myFont   = "Stencil" ;// "Eras Bold ITC"
extern int myFontSize  = 16 ;
extern color colorTime = Olive ;

extern bool Show.Pair  = true ;
extern bool Show.Price = true ;

//---- buffers
double s1[];

string symbol, tChartPeriod,  tShortName ;  
int    digits, period, digits2  ; 
double point, open, close ; 
 
string clock[12] ; 

color colorprice ;
 
//+------------------------------------------------------------------+

int init()

  {
   symbol =  Symbol() ;
   period = Period() ;    
   tChartPeriod =  TimeFrameToString(period) ;

  ArrayResize(clock,12) ;
  clock[00] =  CharToStr(194) ; 
  clock[01] =  CharToStr(183) ;     
  clock[02] =  CharToStr(184) ;
  clock[03] =  CharToStr(185) ;
  clock[04] =  CharToStr(186) ;
  clock[05] =  CharToStr(187) ;
  clock[06] =  CharToStr(188) ;
  clock[07] =  CharToStr(189) ;
  clock[08] =  CharToStr(190) ;
  clock[09] =  CharToStr(191) ;
  clock[10] =  CharToStr(192) ;
  clock[11] =  CharToStr(193) ;
  clock[12] =  CharToStr(183) ;
          
  }
   return(0);
  
int deinit()

  {
   ObjectDelete("time");  
   ObjectDelete("price");     
   ObjectDelete("pair");  
   ObjectDelete("time002");        
  }
   return(0);
  
     
//+------------------------------------------------------------------+
int start()
  {

	double i;
   int m,s,k;
   m=Time[0]+Period()*60-CurTime();
   i=m/60.0;
   s=m%60;
   m=(m-m%60)/60;
 
// Comment( m + " minutes " + s + " seconds left to bar end");
	
	
   ObjectDelete("time");   
   ObjectCreate("time", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("time", tChartPeriod + " Bar end: "+m+" m "+s+" s ",  myFontSize , myFont, colorTime );
   ObjectSet("time", OBJPROP_XDISTANCE,  myFontSize*3 + x.offset); 
   ObjectSet("time", OBJPROP_YDISTANCE, myFontSize  + y.offset); 
   ObjectSet("time", OBJPROP_CORNER, corner);   
  
  // 183 = 1, 194 = 12
  
  
  int HH = TimeHour(Time[0]) ; 
  if(HH > 11) {HH = HH - 12 ; }
  
   string  OBJ002 = "time002" ; 
   ObjectDelete(OBJ002);   
   ObjectCreate(OBJ002, OBJ_LABEL, 0, 0, corner);
   ObjectSetText(OBJ002, clock[HH],  myFontSize*2 , "Wingdings" , colorTime );
   ObjectSet(OBJ002, OBJPROP_XDISTANCE, x.offset); 
   ObjectSet(OBJ002, OBJPROP_YDISTANCE, y.offset);  
   ObjectSet(OBJ002, OBJPROP_CORNER, corner);   

if(Show.Pair)
{
  	
   ObjectDelete("pair");   
   ObjectCreate("pair", OBJ_LABEL, 0, 0, corner);
   ObjectSetText("pair", symbol ,  myFontSize , myFont, colorTime );
   ObjectSet("pair", OBJPROP_XDISTANCE,  myFontSize*3 + x.offset); 
   ObjectSet("pair", OBJPROP_YDISTANCE,  myFontSize*3 + y.offset); 
   ObjectSet("pair", OBJPROP_CORNER, corner);    
}



if(Show.Price)
{

   close = iClose(symbol,period,0) ;
   open  = iOpen(symbol,period,0) ;

   if( close > open ) { colorprice = LimeGreen ; } else  { colorprice = Red ; }
	
   ObjectDelete("price");   
   ObjectCreate("price", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("price", DoubleToStr(close,Digits) ,  myFontSize , myFont, colorprice );
   ObjectSet("price", OBJPROP_XDISTANCE,  myFontSize*8 + x.offset); 
   ObjectSet("price", OBJPROP_YDISTANCE,  myFontSize*3 + y.offset); 
   ObjectSet("price", OBJPROP_CORNER, corner);   
}



   return(0);
  }
  


//+--------- TRO MODIFICATION ---------------------------------------+  

string TimeFrameToString(int tf)
{
   string tfs;
   switch(tf) {
      case PERIOD_M1:  tfs="M1"  ; break;
      case PERIOD_M5:  tfs="M5"  ; break;
      case PERIOD_M15: tfs="M15" ; break;
      case PERIOD_M30: tfs="M30" ; break;
      case PERIOD_H1:  tfs="H1"  ; break;
      case PERIOD_H4:  tfs="H4"  ; break;
      case PERIOD_D1:  tfs="D1"  ; break;
      case PERIOD_W1:  tfs="W1"  ; break;
      case PERIOD_MN1: tfs="MN";
   }
   return(tfs);
}
//+------------------------------------------------------------------+

/*


Comment(clock[HH], " ", HH) ;

*/