/*
 * DIBSv1.0.mq4
 *
 * Thanks to Midnite (daily_open_line.mq4) and free84 (in&out.mq4)
 *
 * Remaining bar time added by NuckingFuts
**/
#property copyright "Copyright , free84, Midnite and NuckingFuts"
#property link      "www.forexfactory.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 RoyalBlue
#property indicator_width1 2
#property indicator_color2 RoyalBlue
#property indicator_width2 2
#property indicator_color3 FireBrick
#property indicator_style3 2
#property indicator_width3 1

/* External settings */
extern bool   Show_IB              = true;
extern bool   Show_Daily_Open_Line = true;
extern bool   Show_Remain_Bar_Time = true;
extern int    Timezone_Offset      = 0;

/* Indicator buffers */
double ib1[];
double ib2[];
double OpenBuf[];
string IndName = "DIBS v1.0";

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   IndicatorShortName(IndName);
   SetIndexStyle(0, DRAW_HISTOGRAM, 0);
   SetIndexStyle(1, DRAW_HISTOGRAM, 0);
   SetIndexBuffer(0, ib1);
   SetIndexBuffer(1, ib2);
   SetIndexLabel(0, "IB");
   SetIndexLabel(1, "IB");
   SetIndexStyle(2, DRAW_LINE);
	SetIndexBuffer(2, OpenBuf);
	SetIndexLabel(2, "OpenLine");
	SetIndexEmptyValue(2, 0.0);
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   string Cmnt = IndName;
   if (Show_Remain_Bar_Time) Cmnt = Cmnt+"\n"+GetRemainingBarTime();
   Comment(Cmnt);

   static datetime prevtime = 0;
   int shift;
   int shift1;
   int shift2;
   double L, L1, H, H1;
   
   if (Show_Daily_Open_Line)
   {
      int counted_bars = IndicatorCounted();
      if (counted_bars > 0) counted_bars--;
      int last_bar = Bars - counted_bars;	
      DrawDailyOpen(0, last_bar);
   } 
   if (prevtime == Time[0]) return(0);
   
   prevtime = Time[0];
   
   for (shift = 0; shift < Bars; shift++) 
   {
      shift1 = shift;
      shift2 = shift + 1;
      
      H = High[shift1];
      H1 = High[shift2];
      L = Low[shift1];
      L1 = Low[shift2];
      
      // Check IB's
      if ((H <= H1) && (L >= L1)) 
      {
         if (Show_IB)
         {
            ib1[shift] = High[shift]; 
            ib2[shift] = Low[shift];
         }
      }
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Draw daily open line                                             |
//+------------------------------------------------------------------+
int DrawDailyOpen(int offset, int lastbar)
{
   int shift;
   int tzdiffsec = Timezone_Offset * 3600;
   double barsper30 = 1.0*PERIOD_M30/Period();
   bool ShowDailyOpenLevel = true; 
   lastbar = MathMin(Bars-20*barsper30-1, lastbar);

	for (shift = lastbar; shift >= offset; shift--)
	{
	  OpenBuf[shift] = 0;
     if (ShowDailyOpenLevel)
     {
       if (TimeDay(Time[shift]-tzdiffsec) != TimeDay(Time[shift+1]-tzdiffsec))
       {
         OpenBuf[shift] = Open[shift];         
         OpenBuf[shift+1] = 0;
       }
       else
       {
         OpenBuf[shift] = OpenBuf[shift+1];
       }
	  }
   }
   return(0);
}
//+------------------------------------------------------------------+
// Show bar remaining time                                           |
//+------------------------------------------------------------------+
string GetRemainingBarTime()
{
   int min, sec, hr;
   min = Time[0]+Period()*60-CurTime();
   sec = min%60;
   min = (min-min%60)/60;
   string Com = "";
   if (min > 59)
   {
      hr = min/60;
      min = min%60;
      Com = hr+" hour";
      if (hr > 1) Com = Com + "s";
      Com = Com+", ";
   }
   if (min > 0)
   {
      Com = Com+min + " minute";
      if (min > 1 || min == 0) Com = Com + "s";
      Com = Com +" and ";
    }
   Com = Com + sec + " second";
   if (sec > 1) Com = Com + "s";
   Com = Com +" remaining until bar close";
   return(Com);
}
//+------------------------------------------------------------------+