//+------------------------------------------------------------------+
//|   Mosca - Arrows Alerts & Labels                                 |
//|                                                                  |
//|   Copyright  2014 / airquest@hotmail.com                        |
//|                                                                  |
//|   http://smart-trading.world-record.ch                           |
//|   based on kimsignals.binaryeasy.club                            |
//+------------------------------------------------------------------+


   #property copyright   "Copyright  2014 // airquest // smart-trading.world-record.ch // based on kimsignals.binaryeasy.club"
   #property link        "http://smart-trading.world-record.ch"
   #property description "Mosca - Arrows Alerts & Labels"


//------------------------------------------------------------------

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Lime
#property indicator_width1 1
#property indicator_color2 Red
#property indicator_width2 1

//---- indicator parameters
extern bool    UseFilter       = False;

extern bool    UseTimer              = False;
extern int     AlertTimer            = 15;
extern int     AfterStartOrBeforeEnd = 0;
extern string  NoteIf0               = "0=Signals are given only X seconds after the beginning of a minute";
extern string  NoteIf1               = "1=Signals are given only X seconds before the end of a minute";

extern int     GannLookback    = 10;

extern int     MAPeriod        = 3;
extern int     MAMethod        = 1;
extern int     MAPrice         = PRICE_CLOSE;

extern int     MACDFast        = 5;
extern int     MACDSlow        = 13;
extern int     MACDPrice       = PRICE_CLOSE;
extern double  MACDOBLevel     = 0;
extern double  MACDOSLevel     = 0;

extern int     RSIPeriod       = 10;
extern int     RSIPrice        = PRICE_TYPICAL;
extern int     RSIOBLevel      = 50;
extern int     RSIOSLevel      = 50;

extern int     BBPeriod        = 10;
extern double  BBDev           = 2.0;
extern int     BBMaMethod      = 0;
extern int     BBPrice         = PRICE_CLOSE;

extern double  ArrowsDisplacement = 0.8;
extern color   ArrowsUpColor      = Lime;
extern color   ArrowsDnColor      = Red;
extern int     ArrowsUpCode       = 233;
extern int     ArrowsDnCode       = 234;
extern int     ArrowsWidth        = 2;

extern bool    AlertsOn        = True;
extern bool    AlertsOnCurrent = True;
extern bool    AlertsMessage   = True;
extern bool    AlertsSound     = False;
extern bool    AlertsEmail     = False;
extern bool    AlertsPush      = False;

extern bool    ShowLabels      = False;
extern color   LabelColor      = Yellow;
extern int     LabelFontWidth  = 14;
extern int     LabelCorner     =  1;
extern int     LabelYDistance  =  0;
extern int     LabelXDistance  =  0;
extern string  MessageUp       = "Buy Signal";
extern string  MessageDn       = "Sell Signal";
extern string  UniqueID        = "Mosca";


//---- indicator buffers
double ArrowsBuy[];
double ArrowsSell[];
double trendGann[];
double trend[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   IndicatorBuffers(4);
//---- drawing settings
   SetIndexBuffer(0,ArrowsBuy);     SetIndexStyle(0,DRAW_ARROW,NULL,ArrowsWidth,ArrowsUpColor);    SetIndexArrow(0,ArrowsUpCode);
   SetIndexBuffer(1,ArrowsSell);    SetIndexStyle(1,DRAW_ARROW,NULL,ArrowsWidth,ArrowsDnColor);    SetIndexArrow(1,ArrowsDnCode);
   SetIndexBuffer(2,trendGann);
   SetIndexBuffer(3,trend);

   if(AlertTimer > 59) AlertTimer = 0;
   if(AlertTimer < 0)  AlertTimer = 0;

//---- initialization done
   return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int deinit()
{
   DeleteLabels();
   return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
{
   int i,counted_bars = IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit = MathMin(Bars-counted_bars,Bars-1);

   for(i=limit; i>=0; i--)
   {
      double EMA    = iMA   (NULL,0,MAPeriod,0,MAMethod,MAPrice,i);
      double MACD   = iMACD (NULL,0,MACDFast,MACDSlow,2,MACDPrice,MODE_MAIN,i);
      double RSI    = iRSI  (NULL,0,RSIPeriod,RSIPrice,i);
      double BB     = iBands(NULL,0,BBPeriod,BBDev,0,BBPrice,MODE_MAIN,i);
      double GannHi = iMA   (NULL,0,GannLookback,0,MODE_SMA,PRICE_HIGH,i+1);
      double GannLo = iMA   (NULL,0,GannLookback,0,MODE_SMA,PRICE_LOW, i+1);
      
      trendGann[i] = trendGann[i+1];
      trend[i]     = trend[i+1];

      if(Close[i] > GannHi) trendGann[i] =  1;
      if(Close[i] < GannLo) trendGann[i] = -1;

      if(UseTimer)
      {
         if(AfterStartOrBeforeEnd == 0)
         {
            if      (EMA >= BB && Close[i] >= BB && trendGann[i] ==  1 && MACD >= MACDOBLevel && RSI >= RSIOBLevel && TimeSeconds(TimeCurrent()) < AlertTimer) trend[i] =  1;
            else if (EMA <= BB && Close[i] <= BB && trendGann[i] == -1 && MACD <= MACDOSLevel && RSI <= RSIOSLevel && TimeSeconds(TimeCurrent()) < AlertTimer) trend[i] = -1;
            else                                                                                                                                               trend[i] =  0;
         }
         else
         {
            if      (EMA >= BB && Close[i] >= BB && trendGann[i] ==  1 && MACD >= MACDOBLevel && RSI >= RSIOBLevel && TimeSeconds(TimeCurrent()) < (60-AlertTimer)) trend[i] =  1;
            else if (EMA <= BB && Close[i] <= BB && trendGann[i] == -1 && MACD <= MACDOSLevel && RSI <= RSIOSLevel && TimeSeconds(TimeCurrent()) < (60-AlertTimer)) trend[i] = -1;
            else                                                                                                                                                    trend[i] =  0;
         }
      }
      else
      {
         if      (EMA >= BB && Close[i] >= BB && trendGann[i] ==  1 && MACD >= MACDOBLevel && RSI >= RSIOBLevel) trend[i] =  1;
         else if (EMA <= BB && Close[i] <= BB && trendGann[i] == -1 && MACD <= MACDOSLevel && RSI <= RSIOSLevel) trend[i] = -1;
         else                                                                                                    trend[i] =  0;
      }

      double gap  = iATR(NULL,0,100,i);
      double high = High[i] + gap * ArrowsDisplacement;
      double low  = Low[i]  - gap * ArrowsDisplacement;

      ArrowsBuy[i]  = EMPTY_VALUE;
      ArrowsSell[i] = EMPTY_VALUE;
      
      if(UseFilter)
      {
         if      (trend[i] != trend[i+1] && trend[i] ==  1 && Close[i+2] >= Open[i+2] && Close[i+1] >= Open[i+1])
         {
            ArrowsBuy[i]  = low;
         }
         else if (trend[i] != trend[i+1] && trend[i] == -1 && Close[i+2] <= Open[i+2] && Close[i+1] <= Open[i+1])
         {
            ArrowsSell[i] = high;
         }
      }
      else
      {
         if      (trend[i] != trend[i+1] && trend[i] ==  1)
         {
            ArrowsBuy[i]  = low;
         }
         else if (trend[i] != trend[i+1] && trend[i] == -1)
         {
            ArrowsSell[i] = high;
         }
      }
   }

   if(ArrowsBuy[0] != EMPTY_VALUE)
   {
      if(AlertsOn)
      {
         if (AlertsOnCurrent)
         int  whichBar = 0;
         else whichBar = 1;
         doAlert(whichBar,MessageUp);
      }
      if(ShowLabels) AddLabels(MessageUp);
   }
   
   if(ArrowsSell[0] != EMPTY_VALUE)
   {
      if(AlertsOn)
      {
         if (AlertsOnCurrent)
              whichBar = 0;
         else whichBar = 1;
         doAlert(whichBar,MessageDn);
      }
      if(ShowLabels) AddLabels(MessageDn);
   }

   return(0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
  void doAlert(int forBar, string doWhat)
{
   static string   previousAlert = "Nothing";
   static datetime previousTime;
   string message;

   if (previousAlert != doWhat && previousTime != Time[forBar])
   {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       message = StringConcatenate(Symbol()," - ",TimeFrameToString(Period())," - "+UniqueID+": ",doWhat);
          if (AlertsMessage) Alert(message);
          if (AlertsEmail)   SendMail(StringConcatenate(Symbol(),""+UniqueID+": "),message);
          if (AlertsPush)    SendNotification(message);
          if (AlertsSound)   PlaySound("alert2.wav");
   }
}

string TimeFrameToString(int tf)
{
   string tfs;
   switch(tf)
   {
      case PERIOD_M1:     tfs = "M1";      break;
      case PERIOD_M5:     tfs = "M5";      break;
      case PERIOD_M15:    tfs = "M15";     break;
      case PERIOD_M30:    tfs = "M30";     break;
      case PERIOD_H1:     tfs = "H1";      break;
      case PERIOD_H4:     tfs = "H4";      break;
      case PERIOD_D1:     tfs = "D1";      break;
      case PERIOD_W1:     tfs = "W1";      break;
      case PERIOD_MN1:    tfs = "MN1";
      default: tfs = "M" + DoubleToStr(tf,0);
   }
   return(tfs);
}

void AddLabels(string message)
{
   DeleteLabels();
   string name = UniqueID+"_Labels";
      ObjectDelete(name);
      ObjectCreate(0,name,OBJ_LABEL,0,Time[0],Close[0]);
      ObjectSetText(name,message,LabelFontWidth,NULL,LabelColor);
      ObjectSet(name,OBJPROP_XDISTANCE,LabelXDistance);
      ObjectSet(name,OBJPROP_YDISTANCE,LabelYDistance);
      ObjectSet(name,OBJPROP_CORNER,LabelCorner);
}

void DeleteLabels()
{
   string name = UniqueID+"_Labels";
   ObjectDelete(name);
}