//+------------------------------------------------------------------+
//|                                             EMA_Prediction_2.mq4 |
//|                                                       Codersguru |
//|                                         http://www.forex-tsd.com |
//+------------------------------------------------------------------+


#property copyright "Codersguru"
#property link      "http://www.forex-tsd.com"

extern int ShortEma=1;
extern int LongEma=2;
extern bool Draw_Lines = true;
extern bool Vertical_Lines = true;
extern bool Show_Thumbs = true;

#property indicator_buffers 4
#property indicator_chart_window
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Blue
#property indicator_color4 Red

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];

double Signal1=0,Signal2=0;
int Previous_Bar = 0;


int init()
  {
  
      IndicatorBuffers(4);
      SetIndexStyle(0,DRAW_ARROW,STYLE_SOLID,2); 
      SetIndexStyle(1,DRAW_ARROW,STYLE_SOLID,2); 
      SetIndexArrow(0, 234);
      SetIndexArrow(1, 233);
      SetIndexBuffer(0,ExtMapBuffer1);
      SetIndexBuffer(1,ExtMapBuffer2);


      SetIndexStyle(2,DRAW_LINE);
      SetIndexBuffer(2,ExtMapBuffer3);
      SetIndexStyle(3,DRAW_LINE);
      SetIndexBuffer(3,ExtMapBuffer4);
      

   return(0);
  }


void DrawVertical( int bar , double value, color clr)
   {
      
      static int cnt = 0;
      cnt++;
      string dv = "Signal" + cnt;

      ObjectCreate(dv, OBJ_VLINE, 0, Time[bar], 0);
      ObjectSet(dv, OBJPROP_COLOR, clr);
      ObjectsRedraw();  
   }

void DrawThumb( int bar , int thumb , double value, color clr)
   {
      
      static int cnt = 0;
      cnt++;
      string dv = "thumb" + cnt;

      ObjectCreate(dv, OBJ_ARROW, 0, Time[bar], value);
      if(thumb == 1)
      {
         ObjectSet(dv, OBJPROP_ARROWCODE, 67);
      }
      
      if(thumb == 2)
      {
         ObjectSet(dv, OBJPROP_ARROWCODE, 68);
      }
      ObjectSet(dv, OBJPROP_COLOR, clr);
      ObjectSet(dv, OBJPROP_STYLE  , STYLE_SOLID);
      ObjectSet(dv, OBJPROP_WIDTH  , 3);
      ObjectsRedraw();  
   }
   
int deinit()
  {
   int I = WindowsTotal();
   for (int count = 0; count < WindowsTotal(); count++)
   {
      int nObjects = ObjectsTotal();
      for (int i=nObjects; i>=0; i--) 
      {
         string objName = ObjectName(i);
         if(StringFind(objName, "Signal", 0) >= 0)
         ObjectDelete(objName);
         if(StringFind(objName, "thumb", 0) >= 0)
         ObjectDelete(objName);
      }
   }
   return(0);
  }
int start()
  {
   
   int    counted_bars=IndicatorCounted();
//---- 
   int pos = Bars - counted_bars - 1;
   
   static int right = 0 ;
   static int wrong = 0 ;
   
   while (pos>=0)
   {
   
   Signal1=0;
	Signal2=0;
	Previous_Bar=0;

	
	double EmaLongPrevious = iMA(NULL,0,LongEma,0,MODE_EMA, PRICE_CLOSE, pos+1);
	double EmaLongCurrent = iMA(NULL,0,LongEma,0,MODE_EMA, PRICE_CLOSE, pos);
	double EmaShortPrevious = iMA(NULL,0,ShortEma,0,MODE_EMA, PRICE_CLOSE, pos+1);
	double EmaShortCurrent = iMA(NULL,0,ShortEma,0,MODE_EMA, PRICE_CLOSE, pos);
	
  
   if (Open[pos+1] > Close[pos+1]) Previous_Bar = 1;
   if (Open[pos+1] < Close[pos+1]) Previous_Bar = 2;
   
   int confirm = 0;
   
   if(confirm == 1)
   {
      if (EmaShortPrevious>EmaLongPrevious && EmaShortCurrent<EmaLongCurrent && Previous_Bar == 1) Signal1=High[pos-1];   
      if (EmaShortPrevious<EmaLongPrevious && EmaShortCurrent>EmaLongCurrent && Previous_Bar == 2) Signal2=Low[pos-1];
   }
   else
   {
      if (EmaShortPrevious>EmaLongPrevious && EmaShortCurrent<EmaLongCurrent ) Signal1=High[pos-1];   
      if (EmaShortPrevious<EmaLongPrevious && EmaShortCurrent>EmaLongCurrent ) Signal2=Low[pos-1];
   }
   
   ExtMapBuffer1[pos-1]= Signal1+5*Point;
   ExtMapBuffer2[pos-1]= Signal2-5*Point;
   
   if(Vertical_Lines)
   {
      if(Signal1>0) DrawVertical(pos,0,Blue);
      if(Signal2>0) DrawVertical(pos,0,Red);
   }
   
   if (Show_Thumbs)
   {
      if(Signal1>0 && Open[pos-1] > Close[pos-1])
      {
         DrawThumb(pos-1,1,Signal1+20*Point,Gold);
         right=right+1;
      }
      if(Signal1>0 && Open[pos-1] < Close[pos-1])
      {
         DrawThumb(pos-1,2,Signal1+20*Point,Green);
         wrong=wrong+1;
      }
   
      if(Signal2>0 && Open[pos-1] < Close[pos-1])
      {
         DrawThumb(pos-1,1,Signal2-10*Point,Gold);
         right=right+1;
      }
      if(Signal2>0 && Open[pos-1] > Close[pos-1])
      {
         DrawThumb(pos-1,2,Signal2-10*Point,Green);
         wrong=wrong+1;
      }
   }
    
    if(Draw_Lines)
    {
      ExtMapBuffer3[pos]= EmaLongCurrent;
      ExtMapBuffer4[pos]= EmaShortCurrent;
    }
     
    pos--;
   }
   
   Print ("Wrong = " + wrong + ": Right  = " + right);
   
//----
   return(0);
}