//+------------------------------------------------------------------+
//|                                                      Example.mq4 |
//|                                   Copyright  2005, Sergey Lykov |
//|                                       http://mtexperts.narod.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Serega Lykov"
#property link      "http://mtexperts.narod.ru/"

#property indicator_chart_window

extern string Symbol_1 = "EURUSD";
extern string Symbol_2 = "GBPUSD";

static double point_1;
static double point_2;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorShortName("Example");
   point_1 = MarketInfo(Symbol_1,MODE_POINT);
   point_2 = MarketInfo(Symbol_2,MODE_POINT);
   return(0);
  }

//+------------------------------------------------------------------+
//| Example of Multipair / Multitimeframe indicator                  |
//+------------------------------------------------------------------+
int start()
  {
   // get close at current bars
   double close_0_EU_h1 = iClose(Symbol_1,PERIOD_H1,0);
   double close_0_EU_h4 = iClose(Symbol_1,PERIOD_H4,0);
   double close_0_EU_d1 = iClose(Symbol_1,PERIOD_D1,0);
   double close_0_GU_h1 = iClose(Symbol_2,PERIOD_H1,0);
   double close_0_GU_h4 = iClose(Symbol_2,PERIOD_H4,0);
   double close_0_GU_d1 = iClose(Symbol_2,PERIOD_D1,0);
   // get close at previous bars
   double close_1_EU_h1 = iClose(Symbol_1,PERIOD_H1,1);
   double close_1_EU_h4 = iClose(Symbol_1,PERIOD_H4,1);
   double close_1_EU_d1 = iClose(Symbol_1,PERIOD_D1,1);
   double close_1_GU_h1 = iClose(Symbol_2,PERIOD_H1,1);
   double close_1_GU_h4 = iClose(Symbol_2,PERIOD_H4,1);
   double close_1_GU_d1 = iClose(Symbol_2,PERIOD_D1,1);
   Comment("\n" +
           "The move of price :\n" +
           "\n" +
           Symbol_1 + ":\n" +
           "--------------------------------" + "\n" +
           "H1 = " + DoubleToStr((close_0_EU_h1 - close_1_EU_h1) / point_1,0) + "\n" +
           "H4 = " + DoubleToStr((close_0_EU_h4 - close_1_EU_h4) / point_1,0) + "\n" +
           "D1 = " + DoubleToStr((close_0_EU_d1 - close_1_EU_d1) / point_1,0) + "\n" +
           "\n" +
           Symbol_2 + ":\n" +
           "--------------------------------" + "\n" +
           "H1 = " + DoubleToStr((close_0_GU_h1 - close_1_GU_h1) / point_2,0) + "\n" +
           "H4 = " + DoubleToStr((close_0_GU_h4 - close_1_GU_h4) / point_2,0) + "\n" +
           "D1 = " + DoubleToStr((close_0_GU_d1 - close_1_GU_d1) / point_2,0) + "\n"
          );
   return(0);
  }
//+------------------------------------------------------------------+