//+------------------------------------------------------------------+
//|                                        fibonacci-retracement.mq4 |
//|      Copyright  2011 Forex-indikatoren.com. All rights reserved |
//|                                 http://www.forex-indikatoren.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011 Forex-indikatoren.com."
#property link      "http://www.forex-indikatoren.com"

#property indicator_chart_window
extern double FiboLevel1=0.000;
extern double FiboLevel2=0.236;
extern double FiboLevel3=0.382;
extern double FiboLevel4=0.500;
extern double FiboLevel5=0.618;
extern double FiboLevel6=1.000;
string Copyright="\xA9 WWW.FOREX-INDIKATOREN.COM";  
string MPrefix="FI";
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
ClearObjects(); 
Comment("");
//----
DL("001", Copyright, 5, 20,Gold,"Arial",10,0); 
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
ClearObjects(); 
Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  //----

     int fibHigh = iHighest(Symbol(),Period(),MODE_HIGH,WindowFirstVisibleBar()-1,1);
     int fibLow  = iLowest(Symbol(),Period(),MODE_LOW,WindowFirstVisibleBar()-1,1);
     
     datetime highTime = Time[fibHigh];
     datetime lowTime  = Time[fibLow];
     
      if(fibHigh>fibLow){
      WindowRedraw();
      ObjectCreate(MPrefix+"FIBO_LAB",OBJ_FIBO,0,highTime,High[fibHigh],lowTime,Low[fibLow]);
      color levelColor = Red;
      }
      else{
      WindowRedraw();
      ObjectCreate(MPrefix+"FIBO_LAB",OBJ_FIBO,0,lowTime,Low[fibLow],highTime,High[fibHigh]);
      levelColor = Green;
      }
      
      double fiboPrice1=ObjectGet(MPrefix+"FIBO_LAB",OBJPROP_PRICE1);
      double fiboPrice2=ObjectGet(MPrefix+"FIBO_LAB",OBJPROP_PRICE2);
      
      double fiboPriceDiff = fiboPrice2-fiboPrice1;
      string fiboValue0 = DoubleToStr(fiboPrice2-fiboPriceDiff*FiboLevel1,Digits);
      string fiboValue23 = DoubleToStr(fiboPrice2-fiboPriceDiff*FiboLevel2,Digits);
      string fiboValue38 = DoubleToStr(fiboPrice2-fiboPriceDiff*FiboLevel3,Digits);
      string fiboValue50 = DoubleToStr(fiboPrice2-fiboPriceDiff*FiboLevel4,Digits);
      string fiboValue61 = DoubleToStr(fiboPrice2-fiboPriceDiff*FiboLevel5,Digits);
      string fiboValue100 = DoubleToStr(fiboPrice2-fiboPriceDiff*FiboLevel6,Digits);
  
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIBOLEVELS,6);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIRSTLEVEL+0,FiboLevel1);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIRSTLEVEL+1,FiboLevel2);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIRSTLEVEL+2,FiboLevel3);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIRSTLEVEL+3,FiboLevel4);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIRSTLEVEL+4,FiboLevel5);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_FIRSTLEVEL+5,FiboLevel6);
    
     
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_LEVELCOLOR,levelColor);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_LEVELWIDTH,1);
     ObjectSet(MPrefix+"FIBO_LAB",OBJPROP_LEVELSTYLE,STYLE_DASHDOTDOT);
     ObjectSetFiboDescription( MPrefix+"FIBO_LAB", 0,fiboValue0+" --> "+DoubleToStr(FiboLevel1*100,1)+"%"); 
     ObjectSetFiboDescription( MPrefix+"FIBO_LAB", 1,fiboValue23+" --> "+DoubleToStr(FiboLevel2*100,1)+"%"); 
     ObjectSetFiboDescription( MPrefix+"FIBO_LAB", 2,fiboValue38+" --> "+DoubleToStr(FiboLevel3*100,1)+"%"); 
     ObjectSetFiboDescription( MPrefix+"FIBO_LAB", 3,fiboValue50+" --> "+DoubleToStr(FiboLevel4*100,1)+"%");
     ObjectSetFiboDescription( MPrefix+"FIBO_LAB", 4,fiboValue61+" --> "+DoubleToStr(FiboLevel5*100,1)+"%");
     ObjectSetFiboDescription( MPrefix+"FIBO_LAB", 5,fiboValue100+" --> "+DoubleToStr(FiboLevel6*100,1)+"%");

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| DL function                                                      |
//+------------------------------------------------------------------+
 void DL(string label, string text, int x, int y, color clr, string FontName = "Arial",int FontSize = 12, int typeCorner = 1)
 
{
   string labelIndicator = MPrefix + label;   
   if (ObjectFind(labelIndicator) == -1)
   {
      ObjectCreate(labelIndicator, OBJ_LABEL, 0, 0, 0);
  }
   
   ObjectSet(labelIndicator, OBJPROP_CORNER, typeCorner);
   ObjectSet(labelIndicator, OBJPROP_XDISTANCE, x);
   ObjectSet(labelIndicator, OBJPROP_YDISTANCE, y);
   ObjectSetText(labelIndicator, text, FontSize, FontName, clr);
  
}  

//+------------------------------------------------------------------+
//| ClearObjects function                                            |
//+------------------------------------------------------------------+
void ClearObjects() 
{ 
  for(int i=0;i<ObjectsTotal();i++) 
  if(StringFind(ObjectName(i),MPrefix)==0) { ObjectDelete(ObjectName(i)); i--; } 
}
//+------------------------------------------------------------------+