//+------------------------------------------------------------------+
//|                       _TRO_TREND                                 |
//|                                                                  | 
//|   Copyright  2007, Avery T. Horton, Jr. aka TheRumpledOne       |
//|                                                                  |
//|   PO BOX 43575, TUCSON, AZ 85733                                 |
//|                                                                  |
//|   GIFT AND DONATIONS ACCEPTED                                    | 
//|                                                                  |  
//|    http://docs.mql4.com/constants/wingdings                      |                                         |
//+------------------------------------------------------------------+

#property copyright "Copyright  2007, Avery T. Horton, Jr. aka TheRumpledOne"
#property link      "therumpledone@gmail.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_maximum 11
#property indicator_minimum -1

#property indicator_color1 Lime 
#property indicator_color2 Red
#property indicator_color3 MediumTurquoise 
#property indicator_color4 Red
#property indicator_color5 Yellow
#property indicator_color6 Orange
#property indicator_color7 OrangeRed

//---- For the small screens
//extern string    Display_infos         = "=== If true, displayed on the chart ===";
//extern bool      display_on_chart      =  true ;  // If true, the open trade analysis, daily pivots and daily range will be displayed on the chart window


extern int x.offset= 0 ;//250
extern int y.offset= 100 ;//-160


// indicators parameters

extern bool iPlotChart = false ;
extern bool iPlotGauge = true ;
extern bool iPlotMeter = true ;

extern int LocalTimeZone= 0;
extern int DestTimeZone= 0;

extern int myPeriod  = 0 ;
//extern int myOffset  = 1 ; 
//extern int myChartY = 100 ;

extern int myStyle1  = 2 ;
extern int myStyle2  = 2 ;
extern int myStyle3  = 2 ;
extern int myStyle4  = 2 ;
extern int myStyle5  = 2 ;
extern int myStyle6  = 2 ;
extern int myStyle7  = 2 ;

extern int myWingDing1  = 115 ;
extern int myWingDing2  = 115 ;
extern int myWingDing3  = 115 ;
extern int myWingDing4  = 115 ;
extern int myWingDing5  = 115 ;
extern int myWingDing6  = 115 ;
extern int myWingDing7  = 115 ;

extern color myColor1 =Lime ;
extern color myColor2 =Red;
extern color myColor3 =MediumTurquoise ;
extern color myColor4 =Red;
extern color myColor5 =Yellow;
extern color myColor6 =Orange;
extern color myColor7 =OrangeRed;

//---- buffers

double P1Buffer[];
double P2Buffer[];
double P3Buffer[];
double P4Buffer[];
double P5Buffer[];
double P6Buffer[];
double P7Buffer[];

double yesterday_high=0;
double yesterday_open=0;
double yesterday_low=0;
double yesterday_close=0;
double today_open=0;
double today_high=0;
double today_low=0;

double xPeriod ;
int    window  ;
string short_name ;


//+------------------------------------------------------------------+ 
string Period2Text(int TmPeriod)
{
  switch (TmPeriod)
  {
    case PERIOD_M1  : return("M1");
    case PERIOD_M5  : return("M5");
    case PERIOD_M15 : return("M15");
    case PERIOD_M30 : return("M30");
    case PERIOD_H1  : return("H1");
    case PERIOD_H4  : return("H4");
    case PERIOD_D1  : return("D1");
    case PERIOD_W1  : return("W1");
    case PERIOD_MN1 : return("MN1");
  }      
  return ("ERR");
}

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- name for indicator window

   short_name="TRO_TREND"+myPeriod+Symbol();
   IndicatorShortName(short_name);
   SetIndexBuffer(0, P1Buffer);
   SetIndexBuffer(1, P2Buffer);
   SetIndexBuffer(2, P3Buffer);
   SetIndexBuffer(3, P4Buffer);
   SetIndexBuffer(4, P5Buffer);
   SetIndexBuffer(5, P6Buffer);
   SetIndexBuffer(6, P7Buffer);
//----

SetIndexArrow(0, myWingDing1); 
SetIndexArrow(1, myWingDing2); 
SetIndexArrow(2, myWingDing3); 
SetIndexArrow(3, myWingDing4); 
SetIndexArrow(4, myWingDing5); 
SetIndexArrow(5, myWingDing6); 
SetIndexArrow(6, myWingDing7); 
 


   SetIndexStyle(0, DRAW_LINE, myStyle1, 1);
   SetIndexStyle(1, DRAW_LINE, myStyle2, 1);   
   SetIndexStyle(2, DRAW_HISTOGRAM, myStyle3, 1);
   SetIndexStyle(3, DRAW_HISTOGRAM, myStyle4, 1);
   SetIndexStyle(4, DRAW_HISTOGRAM, myStyle5, 1);
   SetIndexStyle(5, DRAW_HISTOGRAM, myStyle6, 1);
   SetIndexStyle(6, DRAW_HISTOGRAM, myStyle7, 1);  
   
if( myPeriod > 0 ) { xPeriod = myPeriod ; } else { xPeriod = Period() ; }    
     initGraph();
      
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectDelete(short_name+"Fib1_0"); 
   ObjectDelete(short_name+"Fib1_1");
   ObjectDelete(short_name+"Fib1_2");
   ObjectDelete(short_name+"Fib1_3");
   ObjectDelete(short_name+"Fib1_4");  
   ObjectDelete(short_name+"Fib1_5");
   ObjectDelete(short_name+"Fib1_6");
   ObjectDelete(short_name+"Fib1_7");  
   ObjectDelete(short_name+"Fib1_8");   
   ObjectDelete(short_name+"Fib1");
   ObjectDelete(short_name+"Fib1p");

   ObjectDelete(short_name+"Fib2_0"); 
   ObjectDelete(short_name+"Fib2_1");
   ObjectDelete(short_name+"Fib2_2");
   ObjectDelete(short_name+"Fib2_3");
   ObjectDelete(short_name+"Fib2_4");     
   ObjectDelete(short_name+"Fib2_5");
   ObjectDelete(short_name+"Fib2_6");
   ObjectDelete(short_name+"Fib2_7");     
   ObjectDelete(short_name+"Fib2_8");
   ObjectDelete(short_name+"Fib2");
   ObjectDelete(short_name+"Fib2p");
   
     
   ObjectDelete(short_name+"00TRN");
   ObjectDelete(short_name+"line500TRN");
   ObjectDelete(short_name+"X01_Label00TRN");
   ObjectDelete(short_name+"X01_Value00TRN");
   ObjectDelete(short_name+"X02_Label00TRN");
   ObjectDelete(short_name+"X02_Value00TRN");
   ObjectDelete(short_name+"X03_Label00TRN");
   ObjectDelete(short_name+"X03_Value00TRN");
   ObjectDelete(short_name+"X04_Label00TRN");
   ObjectDelete(short_name+"X04_Value00TRN");
   ObjectDelete(short_name+"X05_Label00TRN");
   ObjectDelete(short_name+"X05_Value00TRN");
   ObjectDelete(short_name+"X06_Label00TRN");
   ObjectDelete(short_name+"X06_Value00TRN");
   ObjectDelete(short_name+"X07_Label00TRN");
   ObjectDelete(short_name+"X07_Value00TRN");

   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {

window      = WindowFind(short_name);

double high=0, low=0, open=0, close=0, mid=0 ;
double high1=0, low1=0, open1=0, close1=0, mid1=0 ;
			
   double X01 = 0 ;  
   double X02 = 0 ;
   double X03 = 0 ;
   double X04 = 0 ;	
   double X05 = 0 ;	
   double X06 = 0 ;
	double X07 = 0 ;
	
int limit = 5;
int i;
  

for(i = 0; i < limit  ; i++)
{
open  = iOpen(NULL,xPeriod,i) ;
high  = iHigh(NULL,xPeriod,i) ;
low   = iLow(NULL,xPeriod,i) ;
close = iClose(NULL,xPeriod,i) ;

open1  = iOpen(NULL,xPeriod,i+1) ;
high1  = iHigh(NULL,xPeriod,i+1) ;
low1   = iLow(NULL,xPeriod,i+1) ;
close1 = iClose(NULL,xPeriod,i+1) ;

mid   = ( high + low ) * 0.5 ;
mid1  = ( high1 + low1 ) * 0.5 ;

if(close > mid1 ) { X01 = X01 + 1 ; } else {
if(close < mid1 ) { X02 = X02 + 1 ; } }
			
if(close > close1 ) { X01 = X01 + 1 ; } else {
if(close < close1 ) { X02 = X02 + 1 ; } }

/*
if(close > open ) { X01 = X01 + 1 ; } else {
if(close < open ) { X02 = X02 + 1 ; } } 
 
if(high > high1 ) { X01 = X01 + 1 ; } else {
if(high < high1 ) { X02 = X02 + 1 ; } } 

if(low > low1 ) { X01 = X01 + 1 ; } else {
if(low < low1 ) { X02 = X02 + 1 ; } } 
*/  
} // FOR 
 
//X01 = X01 / 5 ;
//X02 = X02 / 5 ; 
 
if ( iPlotChart ) { 
	
	P1Buffer[i] = X01 / 5 ;
	P2Buffer[i] = X02 / 5 ;
   P3Buffer[i] = X03 ;
	P4Buffer[i] = X04 ;
	P5Buffer[i] = X05 ;
   P6Buffer[i] = X06 ;
   P7Buffer[i] = X07 ;

} // iPlotChart




if ( iPlotMeter ) {  
    
    
   objectBlank();   
   paintCol1(X01);  
   paintCol2(X02);   
}


if ( iPlotGauge ) {  
    
    
   objectBlank();   
   paintCol1(X01);  
   paintCol2(X02);     
    
string StrX01 = "Up" ; 
string StrX02 = "Down" ; 
string StrX03 = "-XO3" ; 
string StrX04 = "-XO4" ; 
string StrX05 = "-XO5" ; 
string StrX06 = "-XO6" ; 
string StrX07 = "-XO7" ; 

   color color_MID_1=Orchid;
                
   color color_X01=Red;
   color color_X02=Red;
   color color_X03=Red;
   color color_X04=Red;
   color color_X05=Red;
   color color_X06=Red;
   color color_X07=Red;  
/*   	
	if( Close[0] < X01) { color_X01=Lime; } 
	if( Close[0] < X02) { color_X02=Lime; } 	
	if( Close[0] < X03) { color_X03=Lime; } 
	if( Close[0] < X04) { color_X04=Lime; } 
	if( Close[0] < X05) { color_X05=Lime; } 
	if( Close[0] < X06) { color_X06=Lime; }		
//	if( Close[0] < X07) { color_X07=Lime; }		
*/		
	int Precision, dig=0;	

//   if( StringFind( Symbol(), "JPY", 0) != -1 ) { Precision = 100; dig = 2;}
//   else                                        { Precision = 10000; dig = 4; }

int sPeriod= Period();

//if (myPeriod != NULL){ sPeriod= myPeriod ;}
       	
//---- Set labels

   int WindowToUse;
   int Corner_line, Xdist_line;
   int Corner_text, Corner_ValueMID, Xdist_text, Xdist_ValueMID;
   int Ydist_line5;
   int Corner_pivots, Xdist_pivots, Ydist_pivots;
   int Ydist_X01, Ydist_X02, Ydist_X03, Ydist_X04, Ydist_X05, Ydist_X06, Ydist_X07;
   int YdistInc ;
   
    WindowToUse     = 0;
    Corner_line     = 1;
    Corner_text     = 1; 
    Corner_ValueMID = 1;
    Xdist_line      = 21+x.offset; 
    Xdist_text      = 93+x.offset; 
    Xdist_ValueMID  = 23+x.offset;
    Corner_pivots   = 1; 
    Xdist_pivots    = 21+x.offset; 
    
    Ydist_pivots    = y.offset;  
    Ydist_line5     = Ydist_pivots + 11; 
    
    YdistInc  = 15 ;
    Ydist_X01 = Ydist_pivots + 25; 
    Ydist_X02 = Ydist_X01 + YdistInc; 
    Ydist_X03 = Ydist_X01 + YdistInc*2; 
    Ydist_X04 = Ydist_X01 + YdistInc*3; 
    Ydist_X05 = Ydist_X01 + YdistInc*4; 
    Ydist_X06 = Ydist_X01 + YdistInc*5; 
    Ydist_X07 = Ydist_X01 + YdistInc*6;

   ObjectCreate(short_name+"00TRN", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText(short_name+"00TRN",sPeriod + " TREND",9, "Verdana", color_MID_1);
   ObjectSet(short_name+"00TRN", OBJPROP_CORNER, Corner_pivots);
   ObjectSet(short_name+"00TRN", OBJPROP_XDISTANCE, Xdist_pivots);
   ObjectSet(short_name+"00TRN", OBJPROP_YDISTANCE, Ydist_pivots);
   
   ObjectCreate(short_name+"line500TRN", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText(short_name+"line500TRN","---------------------",7, "Verdana", color_MID_1);
   ObjectSet(short_name+"line500TRN", OBJPROP_CORNER, Corner_line);
   ObjectSet(short_name+"line500TRN", OBJPROP_XDISTANCE, Xdist_line);
   ObjectSet(short_name+"line500TRN", OBJPROP_YDISTANCE, Ydist_line5);
   
   ObjectCreate(short_name+"X01_Label00TRN", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText(short_name+"X01_Label00TRN",StrX01,9, "Verdana", myColor1);
   ObjectSet(short_name+"X01_Label00TRN", OBJPROP_CORNER, Corner_text);
   ObjectSet(short_name+"X01_Label00TRN", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet(short_name+"X01_Label00TRN", OBJPROP_YDISTANCE, Ydist_X01);
   
   ObjectCreate(short_name+"X01_Value00TRN", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText(short_name+"X01_Value00TRN"," "+DoubleToStr(X01,dig),9, "Verdana", myColor1);
   ObjectSet(short_name+"X01_Value00TRN", OBJPROP_CORNER, Corner_ValueMID);
   ObjectSet(short_name+"X01_Value00TRN", OBJPROP_XDISTANCE, Xdist_ValueMID);
   ObjectSet(short_name+"X01_Value00TRN", OBJPROP_YDISTANCE, Ydist_X01);
   
   ObjectCreate(short_name+"X02_Label00TRN", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText(short_name+"X02_Label00TRN",StrX02,9, "Verdana", myColor2);
   ObjectSet(short_name+"X02_Label00TRN", OBJPROP_CORNER, Corner_text);
   ObjectSet(short_name+"X02_Label00TRN", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet(short_name+"X02_Label00TRN", OBJPROP_YDISTANCE, Ydist_X02);
   
   ObjectCreate(short_name+"X02_Value00TRN", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText(short_name+"X02_Value00TRN"," "+DoubleToStr(X02,dig),9, "Verdana", myColor2);
   ObjectSet(short_name+"X02_Value00TRN", OBJPROP_CORNER, Corner_ValueMID);
   ObjectSet(short_name+"X02_Value00TRN", OBJPROP_XDISTANCE, Xdist_ValueMID);
   ObjectSet(short_name+"X02_Value00TRN", OBJPROP_YDISTANCE, Ydist_X02);

} // iPlotGauge
    
   return(0);
  }
  
  
void objectCreate(string name,int x,int y,string text="-",int size=42,
                  string font="Arial",color colour=CLR_NONE)
  {
   ObjectCreate(name,OBJ_LABEL,window,0,0);
   ObjectSet(name,OBJPROP_CORNER,3);
   ObjectSet(name,OBJPROP_COLOR,colour);
   ObjectSet(name,OBJPROP_XDISTANCE,x);
   ObjectSet(name,OBJPROP_YDISTANCE,y);
   ObjectSetText(name,text,size,font,colour);
  }

void initGraph()
  {
   deleteObject();

   objectCreate(short_name+"Fib1_8",130+x.offset,75+y.offset);
   objectCreate(short_name+"Fib1_7",130+x.offset,67+y.offset);
   objectCreate(short_name+"Fib1_6",130+x.offset,59+y.offset);
   objectCreate(short_name+"Fib1_5",130+x.offset,51+y.offset);
   objectCreate(short_name+"Fib1_4",130+x.offset,43+y.offset);   
   objectCreate(short_name+"Fib1_3",130+x.offset,35+y.offset);
   objectCreate(short_name+"Fib1_2",130+x.offset,27+y.offset);
   objectCreate(short_name+"Fib1_1",130+x.offset,19+y.offset);   
   objectCreate(short_name+"Fib1_0",130+x.offset,11+y.offset);   
   objectCreate(short_name+"Fib1",132+x.offset,12+y.offset,Period2Text(xPeriod),7,"Arial Narrow",SkyBlue);
   objectCreate(short_name+"Fib1p",134+x.offset,21+y.offset,DoubleToStr(9,1),8,"Arial Narrow",Silver);   

   objectCreate(short_name+"Fib2_8",110+x.offset,75+y.offset);
   objectCreate(short_name+"Fib2_7",110+x.offset,67+y.offset);
   objectCreate(short_name+"Fib2_6",110+x.offset,59+y.offset);
   objectCreate(short_name+"Fib2_5",110+x.offset,51+y.offset);
   objectCreate(short_name+"Fib2_4",110+x.offset,43+y.offset);
   objectCreate(short_name+"Fib2_3",110+x.offset,35+y.offset);
   objectCreate(short_name+"Fib2_2",110+x.offset,27+y.offset);
   objectCreate(short_name+"Fib2_1",110+x.offset,19+y.offset);  
   objectCreate(short_name+"Fib2_0",110+x.offset,11+y.offset);
   objectCreate(short_name+"Fib2",112+x.offset,12+y.offset,Period2Text(xPeriod),7,"Arial Narrow",SkyBlue);
   objectCreate(short_name+"Fib2p",114+x.offset,21+y.offset,DoubleToStr(9,1),8,"Arial Narrow",Silver);
}

void paintCol1(double value)
  {
  

   if (value >  8) ObjectSet(short_name+"Fib1_8",OBJPROP_COLOR,LawnGreen);
   if (value >  7) ObjectSet(short_name+"Fib1_7",OBJPROP_COLOR,Chartreuse);
   if (value >  6) ObjectSet(short_name+"Fib1_6",OBJPROP_COLOR,Lime);   
   if (value >  5) ObjectSet(short_name+"Fib1_5",OBJPROP_COLOR,LimeGreen);
   if (value >  4) ObjectSet(short_name+"Fib1_4",OBJPROP_COLOR,ForestGreen);
   if (value >  3) ObjectSet(short_name+"Fib1_3",OBJPROP_COLOR,ForestGreen);   
   if (value >  2) ObjectSet(short_name+"Fib1_2",OBJPROP_COLOR,Green);
   if (value >  1) ObjectSet(short_name+"Fib1_1",OBJPROP_COLOR,Green);
                   ObjectSet(short_name+"Fib1_0",OBJPROP_COLOR,DarkGreen);   
   
   
   ObjectSet(short_name+"Fib1",OBJPROP_COLOR,SkyBlue);
   ObjectSetText(short_name+"Fib1p",DoubleToStr(value,0),8,"Arial Narrow",Silver);
   GlobalVariableSet(short_name+"Fib1",value);
  }
  
void paintCol2(double value)
  {

   if (value >  8) ObjectSet(short_name+"Fib2_8",OBJPROP_COLOR,OrangeRed);
   if (value >  7) ObjectSet(short_name+"Fib2_7",OBJPROP_COLOR,Red);
   if (value >  6) ObjectSet(short_name+"Fib2_6",OBJPROP_COLOR,Red);   
   if (value >  5) ObjectSet(short_name+"Fib2_5",OBJPROP_COLOR,Crimson);
   if (value >  4) ObjectSet(short_name+"Fib2_4",OBJPROP_COLOR,Crimson);
   if (value >  3) ObjectSet(short_name+"Fib2_3",OBJPROP_COLOR,FireBrick);   
   if (value >  2) ObjectSet(short_name+"Fib2_2",OBJPROP_COLOR,FireBrick);
   if (value >  1) ObjectSet(short_name+"Fib2_1",OBJPROP_COLOR,Maroon);
                   ObjectSet(short_name+"Fib2_0",OBJPROP_COLOR,Maroon);     
   ObjectSet(short_name+"Fib2",OBJPROP_COLOR,SkyBlue);
   ObjectSetText(short_name+"Fib2p",DoubleToStr(value,0),8,"Arial Narrow",Silver);
   GlobalVariableSet(short_name+"Fib2",value);
  }
  
void objectBlank()
  {
  
   ObjectSet(short_name+"Fib1_0",OBJPROP_COLOR,DimGray); 
   ObjectSet(short_name+"Fib1_1",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_2",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_3",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_4",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_5",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_6",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_7",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib1_8",OBJPROP_COLOR,DimGray);   
   ObjectSet(short_name+"Fib1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet(short_name+"Fib1p",OBJPROP_COLOR,CLR_NONE);

   ObjectSet(short_name+"Fib2_0",OBJPROP_COLOR,DimGray); 
   ObjectSet(short_name+"Fib2_1",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_2",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_3",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_4",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_5",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_6",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_7",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2_8",OBJPROP_COLOR,DimGray);
   ObjectSet(short_name+"Fib2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet(short_name+"Fib2p",OBJPROP_COLOR,CLR_NONE);

  }
  
void deleteObject()
  {  

   ObjectDelete(short_name+"Fib1_0"); 
   ObjectDelete(short_name+"Fib1_1");
   ObjectDelete(short_name+"Fib1_2");
   ObjectDelete(short_name+"Fib1_3");
   ObjectDelete(short_name+"Fib1_4");  
   ObjectDelete(short_name+"Fib1_5");
   ObjectDelete(short_name+"Fib1_6");
   ObjectDelete(short_name+"Fib1_7");  
   ObjectDelete(short_name+"Fib1_8");   
   ObjectDelete(short_name+"Fib1");
   ObjectDelete(short_name+"Fib1p");

   ObjectDelete(short_name+"Fib2_0"); 
   ObjectDelete(short_name+"Fib2_1");
   ObjectDelete(short_name+"Fib2_2");
   ObjectDelete(short_name+"Fib2_3");
   ObjectDelete(short_name+"Fib2_4");     
   ObjectDelete(short_name+"Fib2_5");
   ObjectDelete(short_name+"Fib2_6");
   ObjectDelete(short_name+"Fib2_7");     
   ObjectDelete(short_name+"Fib2_8");
   ObjectDelete(short_name+"Fib2");
   ObjectDelete(short_name+"Fib2p");
   
   }
   