#property copyright "Copyright  2013 forexsenseo.com"
#property link      "http://www.forexsenseo.com"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 DeepSkyBlue
#property indicator_width1 2
#property indicator_color2 CLR_NONE
#property indicator_color3 CLR_NONE
#property indicator_level1 100000000.0
#property indicator_level2 -100000000.0

extern int RSI1.Price = 0;
extern int RSI1.Length = 2;
extern int RSI2.Price = 0;
extern int RSI2.Length = 8;
extern int RSI3.Price = 0;
extern int RSI3.Length = 14;
extern int Stoch1.KPeriod = 11;
extern int Stoch1.DPeriod = 3;
extern int Stoch1.Slowing = 3;
extern int Stoch2.KPeriod = 39;
extern int Stoch2.DPeriod = 3;
extern int Stoch2.Slowing = 3;
extern int Stoch3.KPeriod = 65;
extern int Stoch3.DPeriod = 3;
extern int Stoch3.Slowing = 3;
extern double Sensitivity = 2.0;
extern bool AlertsON = TRUE;
extern bool SoundAlert = TRUE;
extern string SoundFileAtSignal = "signal.wav";
extern bool EmailAlert = TRUE;
extern bool NotificationAlert = TRUE;
double G_ibuf_200[];
double G_ibuf_204[];
double G_ibuf_208[];
double Gda_212[][3];
int G_acc_number_216;
string Gs_dummy_232;
double G_irsi_240;
double G_irsi_248;
double G_irsi_256;
double G_istochastic_264;
double G_istochastic_272;
double G_istochastic_280;
bool Gi_288;
int G_datetime_300;

// E37F0136AA3FFAF149B351F6A4C948E9
int init() {
   SetIndexBuffer(0, G_ibuf_200);
   SetIndexStyle(0, DRAW_LINE, EMPTY, 2, DeepSkyBlue);
   SetIndexBuffer(1, G_ibuf_204);
   SetIndexBuffer(2, G_ibuf_208);
   SetIndexLabel(1, NULL);
   SetIndexLabel(2, NULL);
   IndicatorShortName("HPRP_BUY_nodll ");
   IndicatorDigits(4);
   return (0);
}
	  	 	 	 				     	 		   		 	 		   	 	  	  			  	 	  	   	 	    	  		  	        	    				 	 	    		 			 				    	 				      	   	  		  			 	   		
int deinit() {
   return (0);
}
				 	     		  	 	  		 	    	 	  			 	 							 			   	 	  		   						    		    				  		 		  	  	    					  	   			 			 	 		 	  						   	 		    	
int start() {
   int Li_0 = IndicatorCounted();
   Gi_288 = FALSE;
   if (IsDemo()) Gi_288 = TRUE;
   G_acc_number_216 = AccountNumber();
   if (Li_0 < 0) return (-1);
   if (Li_0 > 0) Li_0--;
   int Li_12 = Bars - Li_0;
   if (ArrayRange(Gda_212, 0) != Bars) ArrayResize(Gda_212, Bars);
   int Li_4 = Li_12;
   for (int Li_8 = Bars - Li_4 - 1; Li_4 >= 0; Li_8++) {
      G_irsi_240 = iRSI(NULL, 0, RSI1.Length, RSI1.Price, Li_4 + 1);
      G_irsi_248 = iRSI(NULL, 0, RSI2.Length, RSI2.Price, Li_4 + 1);
      G_irsi_256 = iRSI(NULL, 0, RSI3.Length, RSI3.Price, Li_4 + 1);
      G_istochastic_264 = iStochastic(NULL, 0, Stoch1.KPeriod, Stoch1.DPeriod, Stoch1.Slowing, MODE_SMA, 0, MODE_MAIN, Li_4 + 1);
      G_istochastic_272 = iStochastic(NULL, 0, Stoch2.KPeriod, Stoch2.DPeriod, Stoch2.Slowing, MODE_SMA, 0, MODE_MAIN, Li_4 + 1);
      G_istochastic_280 = iStochastic(NULL, 0, Stoch3.KPeriod, Stoch3.DPeriod, Stoch3.Slowing, MODE_SMA, 0, MODE_MAIN, Li_4 + 1);
      G_ibuf_200[Li_4] = HPRPBuy(G_irsi_240, G_irsi_248, G_irsi_256, G_istochastic_264, G_istochastic_272, G_istochastic_280, G_acc_number_216, Gi_288);
      Li_4--;
   }
   if (f0_0()) {
      if (G_ibuf_200[2] - G_ibuf_200[1] > G_ibuf_200[2] * Sensitivity / 100.0 && AlertsON) {
         Alert("fsHPRP Buy Ahead on ", Symbol(), " ", Period());
         PlaySound(SoundFileAtSignal);
         if (NotificationAlert) {
            SendNotification("fsHPRP Buy Ahead on " + Symbol() + " " + Period() 
            + "\n");
         }
         if (EmailAlert) {
            SendMail("fsHPRP Buy Ahead on " + Symbol(), "fsHPRP Buy Ahead on " + Symbol() + " " + Period() 
            + "\n");
         }
      }
   }
   return (0);
}
	  									  	 	 	  		 			    		  				    	 		   	 			 		 		 	    	  			   	 	     		 	  	   	 			  	   				 	   		 		 	     	    	  		 	 		 		 
bool f0_0() {
   int datetime_0 = iTime(Symbol(), 0, 0);
   if (G_datetime_300 != datetime_0) {
      G_datetime_300 = datetime_0;
      return (1);
   }
   return (0);
}

double HPRPBuy(double a0, double a1, double a2, double a3, double a4, double a5, int a6, int a7){
   return(MathArctan(G_irsi_240*G_istochastic_264*G_istochastic_280));
   }