
#property copyright "Copyright 2013  Forexmt4systems"
#property link      "www.Forexmt4systems.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1  Green
#property indicator_color2  Maroon
#property indicator_color3  Maroon
#property indicator_width1  14
#property indicator_width2  14
#property indicator_width3  14

 
extern double PeriodX2        = 32.0;
extern int    ModeX2          = 1;
extern int    PriceX2         = 0;

extern bool   alertsOn        = false;
extern bool   alertsOnCurrent = false;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = true;
extern bool   alertsEmail     = false;
extern string soundfile       = "alert2.wav";


double  buf2[], buf3[], buf4[], slope[];



//------------------------------------------------------------------------------ //

int init()
{
   IndicatorBuffers(4);
   SetIndexBuffer(0, buf4);  
   SetIndexBuffer(1, buf3);  
   SetIndexBuffer(2, buf2); 
   SetIndexBuffer(3, slope);   

   return(0);
  }

// ------------------------------------------------------------------------------------------ //
//                            D E - I N I T I A L I S A T I O N                               //
// ------------------------------------------------------------------------------------------ //

int deinit()
{
   return(0);
}

// ------------------------------------------------------------------------------------------ //
//                                M A I N   P R O C E D U R E                                 //
// ------------------------------------------------------------------------------------------ //

int start()
  {
   int limit,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
        limit = MathMin(Bars-counted_bars,Bars-1);
   
   //
   //
   //
   //
   //
   
   if (slope[limit]==-1) CleanPoint(limit,buf3,buf2); 
   for (int X2 =limit; X2>=0; X2--)
   {
      buf2[X2]  = EMPTY_VALUE; 
      buf3[X2]  = EMPTY_VALUE;
      slope[X2] = slope[X2+1];
      buf4[X2] = iMA(NULL,0,PeriodX2,0,ModeX2,PriceX2,X2);
      if (buf4[X2] > buf4[X2+1]) slope[X2] = 1;
      if (buf4[X2] < buf4[X2+1]) slope[X2] =-1;
      if (slope[X2] == -1) PlotPoint(X2,buf3,buf2,buf4);
   }
   
   //
   //
   //
   //
   //
      
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
         
      if (slope[whichBar] != slope[whichBar+1])
      if (slope[whichBar] == 1)
            doAlert("Buy");
      else  doAlert("Sell");       
   }

return(0);
}
         
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," TrendFilterDominator ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," TrendFilterDominator "),message);
             if (alertsSound)   PlaySound(soundfile);
      }
}
      
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

//
//
//
//
//

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (first[i+1] == EMPTY_VALUE)
      {
      if (first[i+2] == EMPTY_VALUE) {
          first[i]    = from[i];
          first[i+1]  = from[i+1];
          second[i]   = EMPTY_VALUE;
         }
      else {
          second[i]   = from[i];
          second[i+1] = from[i+1];
          first[i]    = EMPTY_VALUE;
         }
      }
   else
      {
         first[i]   = from[i];
         second[i]  = EMPTY_VALUE;
      }
}
              