//+------------------------------------------------------------------+
//|                                                        DayMA.mq4 |
//|                                 Copyright 2010-2015, Excstrategy |
//|                                        http://www.ExcStrategy.ru |
//+------------------------------------------------------------------+
#property copyright "ExcStrategy"
#property link      "http://www.ExcStrategy.ru"
#property version   "1.1"
#property description "Moving average"
#property strict
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Magenta
#property indicator_width1 1  
//---- input parameters
extern int Ma_shift=0;
extern int Ma_method=1;
extern int Applied_price=0;
//----
extern int DaysForCalculation=2;
//---- buffers
double Buffer1[];
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(1);
//---- indicator lines
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,Buffer1);
//---- 
   SetIndexLabel(0,"MA");
//---
   DaysForCalculation=DaysForCalculation+1;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   if(Period()>1400)
     {
      Alert("Error! Period can not be greater than D1");
      return(0);
     }
//----
   int counted_bars=IndicatorCounted();
   int barsday;
   bool rangeday;
   datetime Time1=Time[0],Time2;
//----
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
//----
   for(int i=0; i<limit; i++)
     {
      //----
      rangeday= false;
      barsday = 0;
      //----
      Time2=Time[i]+(1440*60*DaysForCalculation);
      if(Time1<Time2)
         if(i<Bars-MathRound(1500/Period()))
            for(int a=i; a<i+1441; a++)
              {
               //----
               barsday++;
               //----
               if(TimeDayOfYear(Time[a])!=TimeDayOfYear(Time[a+1])) a=i+1442;
              }
      //----
      Buffer1[i]=iMA(NULL,0,barsday,Ma_method,Ma_shift,Applied_price,i);
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
