//+------------------------------------------------------------------+
//|                                                  i-DayOfWeek.mq4 |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//| 13.10.2005                          |
//+------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 LightBlue
#property indicator_color2 Salmon

//-------    -------------------------------
extern int NumberDayOfWeek = 1;   //   
extern int NumberOfBars    = 0;   //    (0-)

//-------   --------------------------------------
int ArrowInterval, prevDay;

//-------    ---------------------------------

//-------   ------------------------------------------
double UpLine[];
double DnLine[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void init() {
  SetIndexBuffer(0, UpLine);
  SetIndexStyle (0, DRAW_ARROW);
  SetIndexArrow (0, 159);
  SetIndexEmptyValue(0, EMPTY_VALUE);

  SetIndexBuffer(1, DnLine);
  SetIndexStyle (1, DRAW_ARROW);
  SetIndexArrow (1, 159);
  SetIndexEmptyValue(1, EMPTY_VALUE);

  ArrowInterval = GetArrowInterval();
  Comment(NameDayOfWeek(NumberDayOfWeek));
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void deinit() {
  Comment("");
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
void start() {
  double dMax, dMin;
  int    loopbegin, nsb, shift;

 	if (NumberOfBars==0) loopbegin = Bars - 1;
  else loopbegin = NumberOfBars - 1;

  for (shift=0; shift<=loopbegin; shift++) {
    if (prevDay!=TimeDay(Time[shift])) {
      nsb=iBarShift(NULL, PERIOD_D1, Time[shift]);
      dMax=iHigh(NULL, PERIOD_D1, nsb)+ArrowInterval*Point;
      dMin=iLow (NULL, PERIOD_D1, nsb)-ArrowInterval*Point;
    }
    if (TimeDayOfWeek(Time[shift])==NumberDayOfWeek) {
      UpLine[shift] = dMax;
      DnLine[shift] = dMin;
    }
    prevDay=TimeDay(Time[shift]);
  }
}

//+------------------------------------------------------------------+
//|                   |
//+------------------------------------------------------------------+
int GetArrowInterval() {
  int p = Period();

  switch (p) {
    case 1:     return(5);
    case 5:     return(7);
    case 15:    return(10);
    case 30:    return(15);
    case 60:    return(20);
    case 240:   return(30);
    case 1440:  return(40);
    case 10080: return(150);
    case 43200: return(250);
  }
}

//+------------------------------------------------------------------+
//|                                   |
//+------------------------------------------------------------------+
string NameDayOfWeek(int ndw) {
  if (ndw==0) return("");
  if (ndw==1) return("");
  if (ndw==2) return("");
  if (ndw==3) return("");
  if (ndw==4) return("");
  if (ndw==5) return("");
  if (ndw==6) return("");
}
//+------------------------------------------------------------------+

