//+------------------------------------------------------------------+
//|                                                    CandleTime.mq4|
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+

#property indicator_chart_window
//---- input parameters

extern color  Clock_Color = DimGray;
extern color  Simbol_Color = Gray;
extern string Corner_Placement = "1 is top right 3 is bottom right";
extern int    Corner    = 1;
extern int    Font_size_Simbol = 10;
extern int    Font_size_TimeBar = 12;
extern int    ShiftClock_Y = 25;
extern int    ShiftSimbol_Y = 45;
extern int    ShiftSimbol_X = 10;


string objname="TimeBar";
string objsimb="Simbol";
double s1[];

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init(){

  ObjectCreate(objname, OBJ_LABEL,0, 0, 0);
  ObjectSet(objname, OBJPROP_CORNER, Corner);
  ObjectSet(objname, OBJPROP_XDISTANCE, ShiftSimbol_X);
  ObjectSet(objname, OBJPROP_YDISTANCE, ShiftSimbol_Y);
  
  ObjectCreate(objsimb, OBJ_LABEL,0, 0, 0);
  ObjectSet(objsimb, OBJPROP_CORNER, Corner);
  ObjectSet(objsimb, OBJPROP_XDISTANCE, ShiftSimbol_X);
  ObjectSet(objsimb, OBJPROP_YDISTANCE, ShiftClock_Y);     
   
   //----
   return(0);
}
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit(){

  ObjectDelete(objname);

  //----
  return(0);
} 


//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{

   //Time to bar expiry
  int m,s;

  m=Time[0]+Period()*60-CurTime();
  s=m%60;
  m=(m-s)/60;
  string pairss= ChartSymbol();

  string _m="",_s="";

  if (m<10) _m="0";
  if (s<10) _s="0";
  
  ObjectSetText(objname,_m+DoubleToStr(m,0)+":"+_s+DoubleToStr(s,0), Font_size_TimeBar, "Arial", Clock_Color);
  ObjectSetText(objsimb,pairss, Font_size_Simbol, "Arial Black", Simbol_Color);
  return(0);
}
//+---------------------------------------------------------