//+------------------------------------------------------------------+
//|                                                          ZEC.mq4 |
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 clrDodgerBlue
#property indicator_width1 1
#property indicator_color2 clrRed
#property indicator_width2 1

extern int    =800;
extern int    Width=0;
extern bool   ShowSignal = true;
extern int    gap = 20;
extern bool   use233 = true;

double ArrowUp[], ArrowDn[]; 
datetime key; 
//+------------------------------------------------------------------+
int init()  {
  SetIndexBuffer(0,ArrowUp);       SetIndexStyle(0,DRAW_ARROW,0,Width);    SetIndexLabel(0,"Up");   SetIndexArrow(0,233);
  SetIndexBuffer(1,ArrowDn);       SetIndexStyle(1,DRAW_ARROW,0,Width);    SetIndexLabel(1,"Dn");   SetIndexArrow(1,234);
  IndicatorShortName ("911");
   return(0);
}
//+------------------------------------------------------------------+
int deinit()  {   return(0);  }
//+------------------------------------------------------------------+
int start()  {
   int limit;
   double Kidjun, SpanA, SpanB, ma233;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if(limit>) limit=;
   
   if(key!=Time[0])  {
     for(int i=limit;i>0;i--) {
       ArrowUp[i] = 0;
       ArrowDn[i] = 0;
       Kidjun = iIchimoku(NULL,0,9,26,52,MODE_KIJUNSEN,i);
       SpanA  = iIchimoku(NULL,0,9,26,52,MODE_SENKOUSPANA,i);
       SpanB  = iIchimoku(NULL,0,9,26,52,MODE_SENKOUSPANB,i);
       ma233  = iMA(NULL,0,233,0,1,0,i);
       
       if(use233)  {
         if((Close[i] > Kidjun  && 
             Close[i] > SpanA   &&
             Close[i] > SpanB   &&
             Close[i] > ma233)  &&
            (Open[i] < Kidjun   ||
             Open[i] < SpanA    ||
             Open[i] < SpanB    ||
             Open[i] < ma233))
             ArrowUp[i] = High[i] + gap*_Point;

         if((Close[i] < Kidjun  && 
             Close[i] < SpanA   &&
             Close[i] < SpanB   &&
             Close[i] < ma233)  &&
            (Open[i] > Kidjun   ||
             Open[i] > SpanA    ||
             Open[i] > SpanB    ||
             Open[i] > ma233))
             ArrowDn[i] = Low[i] - gap*_Point;
       }
       else  {
         if((Close[i] > Kidjun  && 
             Close[i] > SpanA   &&
             Close[i] > SpanB)  &&
            (Open[i] < Kidjun   ||
             Open[i] < SpanA    ||
             Open[i] < SpanB))
             ArrowUp[i] = High[i] + gap*_Point;

         if((Close[i] < Kidjun  && 
             Close[i] < SpanA   &&
             Close[i] < SpanB)  &&
            (Open[i] > Kidjun   ||
             Open[i] > SpanA    ||
             Open[i] > SpanB))
             ArrowDn[i] = Low[i] - gap*_Point;
       }
     
       if(i==1)  {
         if(ArrowUp[i]>0)  Alert(Symbol(),"   ", _Period, "     911");  
         if(ArrowDn[i]>0)  Alert(Symbol(),"   ", _Period, "     911"); 
       }
     }
     key=Time[0]; 
   }
   return(0);
}
//+------------------------------------------------------------------+