//+------------------------------------------------------------------+
//| BOLLINGER+STARC (BollStarc-TC.mq4)                                    |
//| Copyright  2006                                                 |
//| http://www.                                                      |
//+------------------------------------------------------------------+
//+sigArrows
#property copyright "Copyright  2006, "
#property link "http://www.   "



#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1  DimGray
#property indicator_color2  Yellow 
#property indicator_color3  Yellow
#property indicator_color4  RoyalBlue 
#property indicator_color5  RoyalBlue
#property indicator_color6  LimeGreen 
#property indicator_color7  Red





extern int    BB_Period        = 20;
extern double BB_Deviations    = 2;
extern int    Length           = 13;
extern double Phase            = 0;
extern int    Price            = 0;
extern int    ATR_Period       = 21; 
extern double KATR             = 2.0;
extern int    Shift            = 0; 
extern double ArrowDistance    = 0.3;
extern int    arrowthickness   = 2;

extern string note             = "turn on Alert = true; turn off = false";
extern bool   alertsOn         = true;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = true;
extern bool   alertsEmail      = false;
extern string soundfile        = "alert2.wav";



double MovingBuffer[];
double UpperBuffer[];
double LowerBuffer[];
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double SigBufferUp[];
double SigBufferDn[];
double trend[];





int init()
{
   IndicatorBuffers(8);
   SetIndexBuffer(0, MovingBuffer); SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(1,  UpperBuffer); SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(2,  LowerBuffer); SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(3,ExtMapBuffer1); SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(4,ExtMapBuffer2); SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(5,  SigBufferUp); SetIndexStyle(5,DRAW_ARROW,0,arrowthickness); SetIndexArrow(5,241);
   SetIndexBuffer(6,  SigBufferDn); SetIndexStyle(6,DRAW_ARROW,0,arrowthickness); SetIndexArrow(6,242);
   SetIndexBuffer(7,  trend);

  return(0);
}


int start()
{
   int counted_bars=IndicatorCounted();
   int i,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
         
         
    for(i=limit; i>=0; i--)
    {
    MovingBuffer[i]  = iSmooth(iMA(NULL,0,1,0,MODE_SMA,Price,i),Length,Phase,i);
    UpperBuffer[i]   = MovingBuffer[i] + (KATR * iATR(NULL,0,ATR_Period,i+Shift));
    LowerBuffer[i]   = MovingBuffer[i] - (KATR * iATR(NULL,0,ATR_Period,i+Shift));
    ExtMapBuffer1[i] = iBands(NULL,0,BB_Period,BB_Deviations,0,PRICE_CLOSE,MODE_UPPER,i);
    ExtMapBuffer2[i] = iBands(NULL,0,BB_Period,BB_Deviations,0,PRICE_CLOSE,MODE_LOWER,i);
    
    double SigDistance = ArrowDistance*(KATR * iATR(NULL,0,ATR_Period,i+Shift));
 
       trend[i] = trend[i+1];
    if (ExtMapBuffer1[i+1]<UpperBuffer[i+1]&& ExtMapBuffer2[i+1]>=LowerBuffer[i+1] &&
        ExtMapBuffer2[i]<LowerBuffer[i]&& MovingBuffer[i+1]<MovingBuffer[i]) trend[i] = 1;
           
  
    if (ExtMapBuffer1[i+1]<=UpperBuffer[i+1]&& ExtMapBuffer2[i+1]>LowerBuffer[i+1] &&
        ExtMapBuffer1[i]>UpperBuffer[i]&& MovingBuffer[i+1]>MovingBuffer[i]) trend[i] = -1;
            
         SigBufferUp[i] = EMPTY_VALUE;
         SigBufferDn[i] = EMPTY_VALUE;
         if (trend[i]  !=trend[i+1])
         if (trend[i]   == 1)
               SigBufferUp[i] = ExtMapBuffer2[i] - SigDistance;
         else  SigBufferDn[i] = ExtMapBuffer1[i] + SigDistance;
         }
         
         if (alertsOn)
      {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;

         //
         //
         //
         //
         //
         
         if (trend[whichBar] != trend[whichBar+1])
         if (trend[whichBar] == 1)
               doAlert("uptrend");
         else  doAlert("downtrend");       
   }
   
   return(0);
}
//+------------------------------------------------------------------+

double wrk[][10];

#define bsmax  5
#define bsmin  6
#define volty  7
#define vsum   8
#define avolty 9

//
//
//
//
//

double iSmooth(double price, double length, double phase, int i)
{
   if (ArrayRange(wrk,0) != Bars) ArrayResize(wrk,Bars);
   
   int r = Bars-i-1; 
      if (r==0) { for(int k=0; k<7; k++) wrk[0][k]=price; for(; k<10; k++) wrk[0][k]=0; return(price); }

   //
   //
   //
   //
   //
   
      double len1   = MathMax(MathLog(MathSqrt(0.5*(length-1)))/MathLog(2.0)+2.0,0);
      double pow1   = MathMax(len1-2.0,0.5);
      double del1   = price - wrk[r-1][bsmax];
      double del2   = price - wrk[r-1][bsmin];
      double div    = 1.0/(10.0+10.0*(MathMin(MathMax(length-10,0),100))/100);
      int    forBar = MathMin(r,10);
	
         wrk[r][volty] = 0;
               if(MathAbs(del1) > MathAbs(del2)) wrk[r][volty] = MathAbs(del1); 
               if(MathAbs(del1) < MathAbs(del2)) wrk[r][volty] = MathAbs(del2); 
         wrk[r][vsum] =	wrk[r-1][vsum] + (wrk[r][volty]-wrk[r-forBar][volty])*div;
   
         //
         //
         //
         //
         //
   
         wrk[r][avolty] = wrk[r-1][avolty]+(2.0/(MathMax(4.0*length,30)+1.0))*(wrk[r][vsum]-wrk[r-1][avolty]);
            if (wrk[r][avolty] > 0)
               double dVolty = wrk[r][volty]/wrk[r][avolty]; else dVolty = 0;   
	               if (dVolty > MathPow(len1,1.0/pow1)) dVolty = MathPow(len1,1.0/pow1);
                  if (dVolty < 1)                      dVolty = 1.0;

      //
      //
      //
      //
      //
	        
   	double pow2 = MathPow(dVolty, pow1);
      double len2 = MathSqrt(0.5*(length-1))*len1;
      double Kv   = MathPow(len2/(len2+1), MathSqrt(pow2));

         if (del1 > 0) wrk[r][bsmax] = price; else wrk[r][bsmax] = price - Kv*del1;
         if (del2 < 0) wrk[r][bsmin] = price; else wrk[r][bsmin] = price - Kv*del2;
	
   //
   //
   //
   //
   //
      
      double R     = MathMax(MathMin(phase,100),-100)/100.0 + 1.5;
      double beta  = 0.45*(length-1)/(0.45*(length-1)+2);
      double alpha = MathPow(beta,pow2);

         wrk[r][0] = price + alpha*(wrk[r-1][0]-price);
         wrk[r][1] = (price - wrk[r][0])*(1-beta) + beta*wrk[r-1][1];
         wrk[r][2] = (wrk[r][0] + R*wrk[r][1]);
         wrk[r][3] = (wrk[r][2] - wrk[r-1][4])*MathPow((1-alpha),2) + MathPow(alpha,2)*wrk[r-1][3];
         wrk[r][4] = (wrk[r-1][4] + wrk[r][3]); 

   //
   //
   //
   //
   //

   return(wrk[r][4]);
}



void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," BollStarc-TC_Sig ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," BollStarc-TC_Sig "),message);
             if (alertsSound)   PlaySound(soundfile);
      }
}

