//+------------------------------------------------------------------+
//|                                                 Macd_Correct.mq4 |
//|                                Copyright  2005, David W. Thomas |
//|                                           mailto:davidwt@usa.net |
//+------------------------------------------------------------------+

// This is the correct computation and display of MACD.

#property copyright "Copyright  2005, David W. Thomas"
#property link      "mailto:davidwt@usa.net"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Green

//---- input parameters

extern int IndexMultiplier     = 0;
extern string separator0 = "-------------------------";
extern int Fast_MAPeriod       =  12;
extern int Fast_MA_Shift       =  0;
extern int Fast_MA_Method      =  1; // 0: sma // 1: ema // 2: smma // 3: lwma
extern int Fast_Applied_Price  =  0; // 0: Close // 1: Open // 2: High // 3: Low // 4: Median (H+L/2) // 5: Typical (H+L+C/3) // 6: Weighted (H+L+C+C/4)
extern string separator1 = "-------------------------";
extern int Slow_MAPeriod       =  26;
extern int Slow_MA_Shift       =  0;
extern int Slow_MA_Method      =  1; // 0: sma // 1: ema // 2: smma // 3: lwma
extern int Slow_Applied_Price  =  0; // 0: Close // 1: Open // 2: High // 3: Low // 4: Median (H+L/2) // 5: Typical (H+L+C/3) // 6: Weighted (H+L+C+C/4)
extern string separator2 = "-------------------------";
extern int SignalPeriod        =  9;
extern string separator3 = "-------------------------";
extern int MacdWidth           =  2;
extern int SignalWidth         =  1;
extern int HistogramWidth      =  3;
extern int ShowBars            =  1000;

//---- buffers

double MACDLineBuffer[];
double SignalLineBuffer[];
double HistogramBuffer[];

//---- variables

double alpha = 0;
double alpha_1 = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+1);
   
   //---- indicators
   
   SetIndexEmptyValue(0,0.0);
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,HistogramWidth);
   SetIndexBuffer(0,HistogramBuffer);
   SetIndexDrawBegin(0,Slow_MAPeriod+SignalPeriod);
   SetIndexLabel(0,"Histogram");
   
   SetIndexEmptyValue(1,0.0);
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT,SignalWidth);
   SetIndexBuffer(1,SignalLineBuffer);
   SetIndexDrawBegin(1,Slow_MAPeriod+SignalPeriod);
   SetIndexLabel(1,"Signal");
   
   SetIndexEmptyValue(2,0.0);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,MacdWidth);
   SetIndexBuffer(2,MACDLineBuffer);
   SetIndexDrawBegin(2,Slow_MAPeriod);
   SetIndexLabel(2,"MACD");
   
   //---- name for DataWindow and indicator subwindow label
   
   IndicatorShortName("Macd_Correct("+Fast_MAPeriod+","+Slow_MAPeriod+","+SignalPeriod+")");
   
   //----
	
	alpha = 2.0 / (SignalPeriod + 1.0);
	alpha_1 = 1.0 - alpha;
   
   //----
   
   return(0);
}

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+

int deinit()
{
   //---- 
   
   //----
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int start()
{
   
   if (IndexMultiplier == 0) IndexMultiplier = 1;
   
   int limit;
   int counted_bars = IndicatorCounted();
   
   //---- check for possible errors
   
   if (counted_bars<0) return(-1);
   
   //---- last counted bar will be recounted
   
   if (counted_bars>0) counted_bars--;
   
   limit = ShowBars;
   if (limit > Bars) limit = Bars - counted_bars;
   
   for(int i=limit; i>=0; i--)
   {
      
      MACDLineBuffer[i]   = (iMA(Symbol(),0,Fast_MAPeriod,Fast_MA_Shift,Fast_MA_Method,Fast_Applied_Price,i)
                          - iMA(Symbol(),0,Slow_MAPeriod,Slow_MA_Shift,Slow_MA_Method,Slow_Applied_Price,i))*IndexMultiplier;
      
      SignalLineBuffer[i] = alpha*MACDLineBuffer[i] + alpha_1*SignalLineBuffer[i+1];
      
      HistogramBuffer[i]  = MACDLineBuffer[i] - SignalLineBuffer[i];
      
   }
   
   //----
   
   return(0);
}
//+------------------------------------------------------------------+