//+------------------------------------------------------------------+
//|                                                   MarketInfo.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                http://www.megadelfi.com/experts/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.megadelfi.com/experts/"

#property indicator_chart_window

extern bool ShowMarketInfo = true;
extern bool ShowAccountStatus = true;
extern string myobj = "uGj8JgG7"; // random string to give unique name to the objects
extern double startinglevel = 2.0345;
extern color textcolor = LightSteelBlue;
extern int startbarno = 1;
extern int spacebetweenlines = 5;
double nextlinelevel = 0;
int counter = 0;

double ModeLow;
double ModeHigh;
double ModeTime;
double ModeBid;
double ModeAsk;
double ModePoint;
double ModeDigits;
double ModeSpread;
double ModeStopLevel;
double ModeFreezeLevel;
double ModeLotSize;
double ModeTickValue;
double ModeTickSize;
double ModeSwapLong;
double ModeSwapShort;
double ModeStarting;
double ModeExpiration;
double ModeTradeAllowed;
double ModeMinLot;
double ModeLotStep;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
AccountStatus();  
GetMarketInfo();

//PrintOnGraph("jsafhajdf adf kh");   

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
  int i;
//----
for (i=counter;i>0;i--)
ObjectDelete(myobj+i);   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----

//----
   return(0);
  }
//+------------------------------------------------------------------+

int PrintOnGraph(string mytext)
{
if (nextlinelevel == 0)
nextlinelevel = startinglevel;
else
nextlinelevel = nextlinelevel -spacebetweenlines*Point;

counter++;
 
          ObjectCreate(myobj+counter, OBJ_LABEL, 0, Time[startbarno], nextlinelevel);
          ObjectSet(myobj+counter, OBJPROP_CORNER, 0);                    
          ObjectSet(myobj+counter, OBJPROP_XDISTANCE, 400);                    
          ObjectSet(myobj+counter, OBJPROP_YDISTANCE, 10+counter*10);                    
          ObjectSet(myobj+counter, OBJPROP_COLOR, textcolor);                    
          ObjectSet(myobj+counter, OBJPROP_BACK, true);          
          ObjectSetText(myobj+counter, mytext, 8);   


   return ( 0 );
}

int AccountStatus()
  {
   if(ShowAccountStatus == True )
     {
       Print ("AccountBalance:", AccountBalance());
       Print ("AccountCompany:", AccountCompany());
       Print ("AccountCredit:", AccountCredit());
       Print ("AccountCurrency:", AccountCurrency());
       Print ("AccountEquity:", AccountEquity());
       Print ("AccountFreeMargin:", AccountFreeMargin());
       Print ("AccountLeverage:", AccountLeverage());
       Print ("AccountMargin:", AccountMargin());
       Print ("AccountName:", AccountName());
       Print ("AccountNumber:", AccountNumber());
       Print ("AccountProfit:", AccountProfit());
       
       
       PrintOnGraph ("AccountBalance: "+ AccountBalance());
       PrintOnGraph ("AccountCompany: "+ AccountCompany());
       PrintOnGraph ("AccountCredit: "+ AccountCredit());
       PrintOnGraph ("AccountCurrency: "+ AccountCurrency());
       PrintOnGraph ("AccountEquity: "+ AccountEquity());
       PrintOnGraph ("AccountFreeMargin: "+ AccountFreeMargin());
       PrintOnGraph ("AccountLeverage: "+ AccountLeverage());
       PrintOnGraph ("AccountMargin: "+ AccountMargin());
       PrintOnGraph ("AccountName: "+ AccountName());
       PrintOnGraph ("AccountNumber: "+ AccountNumber());
       PrintOnGraph ("AccountProfit: "+ AccountProfit());
       
       
     }    
   return ( 0 );
  }

int GetMarketInfo()
  {
   // Schityvaem informatsiyu o rynke
   ModeLow = MarketInfo(Symbol(), MODE_LOW);
   ModeHigh = MarketInfo(Symbol(), MODE_HIGH);
   ModeTime = MarketInfo(Symbol(), MODE_TIME);
   ModeBid = MarketInfo(Symbol(), MODE_BID);
   ModeAsk = MarketInfo(Symbol(), MODE_ASK);
   ModePoint = MarketInfo(Symbol(), MODE_POINT);
   ModeDigits = MarketInfo(Symbol(), MODE_DIGITS);
   ModeSpread = MarketInfo(Symbol(), MODE_SPREAD);
   ModeStopLevel = MarketInfo(Symbol(), MODE_STOPLEVEL);
   ModeFreezeLevel = MarketInfo(Symbol(), MODE_FREEZELEVEL);
   ModeLotSize = MarketInfo(Symbol(), MODE_LOTSIZE);
   ModeTickValue = MarketInfo(Symbol(), MODE_TICKVALUE);
   ModeTickSize = MarketInfo(Symbol(), MODE_TICKSIZE);
   ModeSwapLong = MarketInfo(Symbol(), MODE_SWAPLONG);
   ModeSwapShort = MarketInfo(Symbol(), MODE_SWAPSHORT);
   ModeStarting = MarketInfo(Symbol(), MODE_STARTING);
   ModeExpiration = MarketInfo(Symbol(), MODE_EXPIRATION);
   ModeTradeAllowed = MarketInfo(Symbol(), MODE_TRADEALLOWED);
   ModeMinLot = MarketInfo(Symbol(), MODE_MINLOT);
   ModeLotStep = MarketInfo(Symbol(), MODE_LOTSTEP);
   // Vyvodim informatsiyu o rynke
   if ( ShowMarketInfo == True )
     {
       Print("ModeLow:",ModeLow);
       Print("ModeHigh:",ModeHigh);
       Print("ModeTime:",ModeTime);
       Print("ModeBid:",ModeBid);
       Print("ModeAsk:",ModeAsk);
       Print("ModePoint:",ModePoint);
       Print("ModeDigits:",ModeDigits);
       Print("ModeSpread:",ModeSpread);
       Print("ModeStopLevel:",ModeStopLevel);
       Print("ModeFreezeLevel:",ModeFreezeLevel);
       Print("ModeLotSize:",ModeLotSize);
       Print("ModeTickValue:",ModeTickValue);
       Print("ModeTickSize:",ModeTickSize);
       Print("ModeSwapLong:",ModeSwapLong);
       Print("ModeSwapShort:",ModeSwapShort);
       Print("ModeStarting:",ModeStarting);
       Print("ModeExpiration:",ModeExpiration);
       Print("ModeTradeAllowed:",ModeTradeAllowed);
       Print("ModeMinLot:",ModeMinLot);
       Print("ModeLotStep:",ModeLotStep);
       
       
       PrintOnGraph("ModeLow: "+ModeLow);
       PrintOnGraph("ModeHigh: "+ModeHigh);
       PrintOnGraph("ModeTime: "+ModeTime);
       PrintOnGraph("ModeBid: "+ModeBid);
       PrintOnGraph("ModeAsk: "+ModeAsk);
       PrintOnGraph("ModePoint: "+ModePoint);
       PrintOnGraph("ModeDigits: "+ModeDigits);
       PrintOnGraph("ModeSpread: "+ModeSpread);
       PrintOnGraph("ModeStopLevel: "+ModeStopLevel);
       PrintOnGraph("ModeFreezeLevel: "+ModeFreezeLevel);
       PrintOnGraph("ModeLotSize: "+ModeLotSize);
       PrintOnGraph("ModeTickValue: "+ModeTickValue);
       PrintOnGraph("ModeTickSize: "+ModeTickSize);
       PrintOnGraph("ModeSwapLong: "+ModeSwapLong);
       PrintOnGraph("ModeSwapShort: "+ModeSwapShort);
       PrintOnGraph("ModeStarting: "+ModeStarting);
       PrintOnGraph("ModeExpiration: "+ModeExpiration);
       PrintOnGraph("ModeTradeAllowed: "+ModeTradeAllowed);
       PrintOnGraph("ModeMinLot: "+ModeMinLot);
       PrintOnGraph("ModeLotStep: "+ModeLotStep);
       
     }
   return (0);
  }