// LindencourtFX Signal
// modified by San May 31, 2010

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 LawnGreen
#property indicator_color2 Red

double CrossUp[];
double CrossDown[];
double Silience[];
double tri[];
double chetire[];
double pyat[];

string SignalText;

extern bool       RepeatSignals        = false;
extern int        CountBars            = 250;
extern bool       EmailON              = false;
extern bool       SoundON              = false;
extern bool       AlertON              = true;
int Alert_Count = 0;
datetime    Prior_Time;

int init() {
  SetIndexStyle(0, DRAW_ARROW, 3);
  SetIndexArrow(0, 233);
  SetIndexBuffer(0, CrossUp);
  SetIndexStyle(1, DRAW_ARROW, 3);
  SetIndexArrow(1, 234);
  SetIndexBuffer(1, CrossDown);
  SetIndexBuffer(2, Silience);
  SetIndexBuffer(3, tri);
  SetIndexBuffer(4, chetire);  
  SetIndexBuffer(5, pyat);  
  
  
   return (0);
}

int deinit() {
   return (0);
}

int start() {
   int counted_bars=IndicatorCounted();
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
 
   if (iTime(Symbol(),Period(),1) != Prior_Time)
    {
     Prior_Time = iTime(Symbol(),Period(),1);
     Alert_Count = 0;
    }
   else
    {
     return;
    }   
   
   int limit = MathMin(Bars-counted_bars,CountBars);
   
   static int prevtime = 0;   
   if(Time[0] <= prevtime)   return(0);//   
   prevtime = Time[0];//    , 
   
   for (int i=limit; i>=0; i--)
   {
      double PB0 = iCustom(NULL, 0, "PBF_PB_Direction",21,0,i);
      double PB01 = iCustom(NULL, 0, "PBF_PB_Direction",21,0,i+1);      
      double PB02 = iCustom(NULL, 0, "PBF_PB_Direction",21,0,i+2);      
      double PB03 = iCustom(NULL, 0, "PBF_PB_Direction",21,0,i+3);      
      double PB1 = iCustom(NULL, 0, "PBF_PB_Direction",21,1,i);                
      double Fast0 = iCustom(NULL, 0, "PBF_Fast_3MAs",2,13,17,1,0,0,i);
      double Fast1 = iCustom(NULL, 0, "PBF_Fast_3MAs",2,13,17,1,0,1,i);      
      double Squeeze0 = iCustom(NULL, 0, "PBF_Squeeze",21,0,i);
      double Squeeze1 = iCustom(NULL, 0, "PBF_Squeeze",21,1,i);      
      double Squeeze2 = iCustom(NULL, 0, "PBF_Squeeze",21,2,i);      
      double Squeeze3 = iCustom(NULL, 0, "PBF_Squeeze",21,3,i);     
      double Squeeze4 = iCustom(NULL, 0, "PBF_Squeeze",21,4,i);      
      double Squeeze5 = iCustom(NULL, 0, "PBF_Squeeze",21,5,i);      
      double Trend0 = iCustom(NULL, 0, "PBF_Trend_Bars_v2",13,34,89,35,0,-35,0,i);
      double Trend1 = iCustom(NULL, 0, "PBF_Trend_Bars_v2",13,34,89,35,0,-35,1,i);                        
      double OSOB = iCustom(NULL, 0, "PBF_OSOB", 0, i); 
            
      if(High[i] == PB0 && Close[i] > Fast0 && (Squeeze0 < 1 || Squeeze2 < 0) && Squeeze4 == 0 && Trend0 == 35 && OSOB < 35 && (PB01 > 2 || PB02 > 2)) { // long conditions
         if(RepeatSignals){
            CrossUp[i]=Low[i]-0.0010;
            if (SoundON == 1 && Alert_Count == 0) PlaySound("alert.wav");
            if (AlertON == 1 && Alert_Count == 0) Alert("PBF BUY Signal: " + Symbol());
            if (EmailON == 1 && Alert_Count == 0) SendMail("PBF Signal: BUY", "You have PBF BUY signal on " + Symbol());}
         else if(CrossUp[i+1] == EMPTY_VALUE){
            CrossUp[i]=Low[i]-0.0010;
            if (SoundON == 1 && Alert_Count == 0) PlaySound("alert.wav");
            if (AlertON == 1 && Alert_Count == 0) Alert("PBF BUY Signal: " + Symbol());
            if (EmailON == 1 && Alert_Count == 0) SendMail("PBF: BUY", "You have PBF BUY signal on " + Symbol());
         }
      }
      else if(High[i] == PB1 && Close[i] < Fast1 && (Squeeze1 < 0 || Squeeze3 > 0) && Squeeze5 == 0 && Trend1 == 35 && OSOB > -35 && (PB01 > 2 || PB02 > 2)) { // short conditions
         if(RepeatSignals){
            CrossDown[i]=High[i]+0.0010;
            if (SoundON == 1 && Alert_Count == 0) PlaySound("alert.wav");
            if (AlertON == 1 && Alert_Count == 0) Alert("PBF SELL Signal: " + Symbol());
            if (EmailON == 1 && Alert_Count == 0) SendMail("PBF Signal: SELL", "You have PBF SELL signal on " + Symbol());}
         else if(CrossUp[i+1] == EMPTY_VALUE){
            CrossDown[i]=High[i]+0.0010;
            if (SoundON == 1 && Alert_Count == 0) PlaySound("alert.wav");
            if (AlertON == 1 && Alert_Count == 0) Alert("PBF SELL Signal: " + Symbol());
            if (EmailON == 1 && Alert_Count == 0) SendMail("PBF Signal: SELL", "You have PBF SELL signal on " + Symbol()); 
         }
      }
   }
   return (0);
}

