//+------------------------------------------------------------------+
//|                                                          ATR.mq4 |
//|                   Copyright 2005-2014, MetaQuotes Software Corp. |
//|                                              http://www.mql4.com |
//+------------------------------------------------------------------+
#property copyright   "2005-2014, MetaQuotes Software Corp."
#property link        "http://www.mql4.com"
#property description "Oscillating MA"
#property strict

//--- indicator settings
#property indicator_separate_window
#property indicator_buffers 1

//#property indicator_maximum .6
//#property indicator_minimum -.6

//--- buffers
double FFT_0[];

//--- input parameters
input int N = 90;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {

   IndicatorBuffers(1);
   IndicatorDigits(Digits);

   SetIndexStyle(0,DRAW_LINE,0,1,Red);
   SetIndexBuffer(0,FFT_0);
   
   
   SetLevelValue(0,0);
   SetLevelValue(1,.1);
   SetLevelValue(2,-.1);
   SetLevelValue(3,.15);
   SetLevelValue(4,-.15);
   
   //SetLevelStyle(0,2);
   
   IndicatorShortName("N = " + IntegerToString(N) + " : ");
      
   return(INIT_SUCCEEDED);
  }

int deinit()
  {
      ObjectsDeleteAll(0,OBJ_TEXT);
      return(0);
  }

int start()
{
   int   i, n, k, limit;
   double FFT_R[1], FFT_I[1];
   int    counted_bars = IndicatorCounted();
   if(counted_bars > 0) counted_bars--;
   limit = Bars - counted_bars - 1;
     
   for( i = 0 ; i <= limit ; i++ )
   {
      FFT_R[n] = 0;
      for ( k = 0 ; k < N ; k++ )
      {
         FFT_R[n] += iClose(NULL, 0, k + i); // * MathCos( 2 * 3.14 * n * k / N );
      }
      FFT_0[i] = 0;
      FFT_0[i] = N - FFT_R[0] / iClose(NULL, 0, i); //MathSqrt( MathPow(FFT_R[0],2) + MathPow(FFT_I[0],2) );
   }
   return(0);
}
