#property copyright "Dr.Zain Agha"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Aqua
#property indicator_color2 Blue


extern int period = 13;
extern int method = 3;
extern int price = 0;
double Gl_ibuf_88[];
double Gl_ibuf_92[];
double Gl_ibuf_96[];

// E37F0136AA3FFAF149B351F6A4C948E9
int init() {
   IndicatorBuffers(3);
   SetIndexBuffer(0, Gl_ibuf_88);
   SetIndexBuffer(1, Gl_ibuf_92);
   SetIndexBuffer(2, Gl_ibuf_96);
   ArraySetAsSeries(Gl_ibuf_96, TRUE);
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID, 2);
   IndicatorShortName("ZWinnerColorSignals(" + period + ")");
   return (0);
}

// 52D46093050F38C27267BCE42543EF60
int deinit() {
   return (0);
}

// D954202506588335BC40071F1425E064
double f0_0(int Ari_0, int Ar_period_4) {
   return (iMA(NULL, 0, Ar_period_4, 0, method, price, Ari_0));
}

// EA2B2676C28C0DB26D39331A336C6B92
int start() {
   double Lcda_0[];
   double Lcda_4[];
   int ind_counted_8 = IndicatorCounted();
   if (ind_counted_8 < 0) return (-1);
   int Lci_12 = 0;
   int period_16 = MathSqrt(period);
   int Lci_20 = Bars - ind_counted_8 + period + 1;
   if (Lci_20 > Bars) Lci_20 = Bars;
   ArrayResize(Lcda_0, Lci_20);
   ArraySetAsSeries(Lcda_0, TRUE);
   ArrayResize(Lcda_4, Lci_20);
   ArraySetAsSeries(Lcda_4, TRUE);
   for (Lci_12 = 0; Lci_12 < Lci_20; Lci_12++) Lcda_0[Lci_12] = 2.0 * f0_0(Lci_12, period / 2) - f0_0(Lci_12, period);
   for (Lci_12 = 0; Lci_12 < Lci_20 - period; Lci_12++) Gl_ibuf_96[Lci_12] = iMAOnArray(Lcda_0, 0, period_16, 0, method, Lci_12);
   for (Lci_12 = Lci_20 - period; Lci_12 >= 0; Lci_12--) {
      Lcda_4[Lci_12] = Lcda_4[Lci_12 + 1];
      if (Gl_ibuf_96[Lci_12] > Gl_ibuf_96[Lci_12 + 1]) Lcda_4[Lci_12] = 1;
      if (Gl_ibuf_96[Lci_12] < Gl_ibuf_96[Lci_12 + 1]) Lcda_4[Lci_12] = -1;
      if (Lcda_4[Lci_12] > 0.0) {
         Gl_ibuf_88[Lci_12] = Gl_ibuf_96[Lci_12];
         if (Lcda_4[Lci_12 + 1] < 0.0) Gl_ibuf_88[Lci_12 + 1] = Gl_ibuf_96[Lci_12 + 1];
         Gl_ibuf_92[Lci_12] = EMPTY_VALUE;
      } else {
         if (Lcda_4[Lci_12] < 0.0) {
            Gl_ibuf_92[Lci_12] = Gl_ibuf_96[Lci_12];
            if (Lcda_4[Lci_12 + 1] > 0.0) Gl_ibuf_92[Lci_12 + 1] = Gl_ibuf_96[Lci_12 + 1];
            Gl_ibuf_88[Lci_12] = EMPTY_VALUE;
         }
      }
   }
   return (0);
}