//+------------------------------------------------------------------+
//|                                               Pivot Point EA.mq4 |
//|                        Copyright  2007, Thomas Gonzalez Miranda |
//|                                         http://www.emulatore.org |
//|                                                      Version 1.0 |
//| History:                                                         |
//| 1.0 => release version to the public                             |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Thomas Gonzalez Miranda"
#property link      "http://www.emulatore.org"

#include <WinUser32.mqh>
#include <stderror.mqh>
#include <stdlib.mqh>

extern double LotSize = 0.1;
extern double TakeProfit = 40;
extern double StopLoss = 20;
extern double DistanceFromSupport = 1; // distancia que o BUYLIMIT vai ter do support 3
extern double DistanceFromResistance = 1; // distancia que o SELLLIMIT vai ter da resistance 3
extern bool UsePivotPointTakeProfit = true;
extern int MinimumToContinue = 10; // the distances from one pivot to another need to be more than 10 pips.
extern string BuyComment = "AutoPivot BUY";
extern string SellComment = "AutoPivot SELL";

   extern bool Previous          = True;
   extern bool Previous_SR_Levels   = True;
   extern bool Use_Sunday_Data   = True;
   extern bool Daily             = False;
   extern bool Daily_SR_Levels   = false;
   extern bool Weekly            = false;
   extern bool Weekly_SR_Levels  = False;
   extern bool Monthly           = false;
   extern bool Monthly_SR_Levels = False;

   double YesterdayHigh;
   double YesterdayLow;
   double YesterdayClose;
   double Day_Price[][6];
   double Pivot,S1,S2,S3,R1,R2,R3;
      
   double WeekHigh;
   double WeekLow;
   double WeekClose;
   double Weekly_Price[][6];
   double WeekPivot,WS1,WS2,WS3,WR1,WR2,WR3;
   
   double MonthHigh;
   double MonthLow;
   double MonthClose;
   double Month_Price[][6];
   double MonthPivot,MS1,MS2,MS3,MR1,MR2,MR3;

   double PreviousHigh;
   double PreviousLow;
   double PreviousClose;
   double Previous_Price[][6];
   double PreviousPivot,PS1,PS2,PS3,PR1,PR2,PR3;
   
int init()
  {
   return(0);
  }
  
//-------------------------------------------------------- 
  
int deinit()
  {
ObjectDelete("PivotLine");

ObjectDelete("R1_Line");
ObjectDelete("R2_Line");
ObjectDelete("R3_Line");

ObjectDelete("S1_Line");
ObjectDelete("S2_Line");
ObjectDelete("S3_Line");  

//--------------------------------

ObjectDelete("PivotLabel");

ObjectDelete("R1_Label");
ObjectDelete("R2_Label");
ObjectDelete("R3_Label");

ObjectDelete("S1_Label");
ObjectDelete("S2_Label");
ObjectDelete("S3_Label"); 

//--------------------------------------------------------

ObjectDelete("WeekPivotLine");

ObjectDelete("WR1_Line");
ObjectDelete("WR2_Line");
ObjectDelete("WR3_Line");

ObjectDelete("WS1_Line");
ObjectDelete("WS2_Line");
ObjectDelete("WS3_Line");  

//--------------------------------

ObjectDelete("WeekPivotLabel");

ObjectDelete("WR1_Label");
ObjectDelete("WR2_Label");
ObjectDelete("WR3_Label");

ObjectDelete("WS1_Label");
ObjectDelete("WS2_Label");
ObjectDelete("WS3_Label");  

//--------------------------------------------------------

ObjectDelete("MonthPivotLine");

ObjectDelete("MR1_Line");
ObjectDelete("MR2_Line");
ObjectDelete("MR3_Line");

ObjectDelete("MS1_Line");
ObjectDelete("MS2_Line");
ObjectDelete("MS3_Line");  

//--------------------------------

ObjectDelete("MonthPivotLabel");

ObjectDelete("MR1_Label");
ObjectDelete("MR2_Label");
ObjectDelete("MR3_Label");

ObjectDelete("MS1_Label");
ObjectDelete("MS2_Label");
ObjectDelete("MS3_Label");

//--------------------------------------------------------

ObjectDelete("PreviousPivotLine");

ObjectDelete("PR1_Line");
ObjectDelete("PR2_Line");
ObjectDelete("PR3_Line");

ObjectDelete("PS1_Line");
ObjectDelete("PS2_Line");
ObjectDelete("PS3_Line");  

//--------------------------------

ObjectDelete("PreviousPivotLabel");

ObjectDelete("PR1_Label");
ObjectDelete("PR2_Label");
ObjectDelete("PR3_Label");

ObjectDelete("PS1_Label");
ObjectDelete("PS2_Label");
ObjectDelete("PS3_Label");

return(0);
}
//--------------------------------------------------------- 

int start()
{
ObjectDelete("PivotLine");

ObjectDelete("R1_Line");
ObjectDelete("R2_Line");
ObjectDelete("R3_Line");

ObjectDelete("S1_Line");
ObjectDelete("S2_Line");
ObjectDelete("S3_Line");  

//--------------------------------

ObjectDelete("PivotLabel");

ObjectDelete("R1_Label");
ObjectDelete("R2_Label");
ObjectDelete("R3_Label");

ObjectDelete("S1_Label");
ObjectDelete("S2_Label");
ObjectDelete("S3_Label"); 

//--------------------------------------------------------

ObjectDelete("WeekPivotLine");

ObjectDelete("WR1_Line");
ObjectDelete("WR2_Line");
ObjectDelete("WR3_Line");

ObjectDelete("WS1_Line");
ObjectDelete("WS2_Line");
ObjectDelete("WS3_Line");  

//--------------------------------

ObjectDelete("WeekPivotLabel");

ObjectDelete("WR1_Label");
ObjectDelete("WR2_Label");
ObjectDelete("WR3_Label");

ObjectDelete("WS1_Label");
ObjectDelete("WS2_Label");
ObjectDelete("WS3_Label");  

//--------------------------------------------------------

ObjectDelete("MonthPivotLine");

ObjectDelete("MR1_Line");
ObjectDelete("MR2_Line");
ObjectDelete("MR3_Line");

ObjectDelete("MS1_Line");
ObjectDelete("MS2_Line");
ObjectDelete("MS3_Line");  

//--------------------------------

ObjectDelete("MonthPivotLabel");

ObjectDelete("MR1_Label");
ObjectDelete("MR2_Label");
ObjectDelete("MR3_Label");

ObjectDelete("MS1_Label");
ObjectDelete("MS2_Label");
ObjectDelete("MS3_Label");

//--------------------------------------------------------

ObjectDelete("PreviousPivotLine");

ObjectDelete("PR1_Line");
ObjectDelete("PR2_Line");
ObjectDelete("PR3_Line");

ObjectDelete("PS1_Line");
ObjectDelete("PS2_Line");
ObjectDelete("PS3_Line");  

//--------------------------------

ObjectDelete("PreviousPivotLabel");

ObjectDelete("PR1_Label");
ObjectDelete("PR2_Label");
ObjectDelete("PR3_Label");

ObjectDelete("PS1_Label");
ObjectDelete("PS2_Label");
ObjectDelete("PS3_Label");




ArrayCopyRates(Day_Price,(Symbol()), 1440);

   
  
   YesterdayHigh  = Day_Price[1][3];
   YesterdayLow   = Day_Price[1][2];
   YesterdayClose = Day_Price[1][4];
   
   Pivot = ((YesterdayHigh + YesterdayLow + YesterdayClose)/3);

   R1 = (2*Pivot)-YesterdayLow;
   S1 = (2*Pivot)-YesterdayHigh;

   R2 = Pivot+(R1-S1);
   S2 = Pivot-(R1-S1);
   
   R3 = (YesterdayHigh + (2*(Pivot-YesterdayLow)));
   S3 = (YesterdayLow - (2*(YesterdayHigh-Pivot)));  
  
  
if (Use_Sunday_Data == false)
 {   
   while (DayOfWeek() == 1)
      {
       
              
       YesterdayHigh  = Day_Price[2][3];
       YesterdayLow   = Day_Price[2][2];
       YesterdayClose = Day_Price[2][4];
   
       Pivot = ((YesterdayHigh + YesterdayLow + YesterdayClose)/3);

       R1 = (2*Pivot)-YesterdayLow;
       S1 = (2*Pivot)-YesterdayHigh;

       R2 = Pivot+(R1-S1);
       S2 = Pivot-(R1-S1);
   
       R3 = (YesterdayHigh + (2*(Pivot-YesterdayLow)));
       S3 = (YesterdayLow - (2*(YesterdayHigh-Pivot)));
       break;
      }
 }
  
//--------------------------------------------------------
//--------------------------------------------------------


ArrayCopyRates(Weekly_Price, Symbol(), 10080);

WeekHigh  = Weekly_Price[1][3];
WeekLow   = Weekly_Price[1][2];
WeekClose = Weekly_Price[1][4];

WeekPivot = ((WeekHigh + WeekLow + WeekClose)/3);

      WR1 = (2*WeekPivot)-WeekLow;
      WS1 = (2*WeekPivot)-WeekHigh;

      WR2 = WeekPivot+(WR1-WS1);
      WS2 = WeekPivot-(WR1-WS1);

      WS3 = (WeekLow - (2*(WeekHigh-WeekPivot)));
      WR3 = (WeekHigh + (2*(WeekPivot-WeekLow)));

//--------------------------------------------------------
//--------------------------------------------------------


ArrayCopyRates(Month_Price, Symbol(), 43200);

MonthHigh  = Month_Price[1][3];
MonthLow   = Month_Price[1][2];
MonthClose = Month_Price[1][4];

MonthPivot = ((MonthHigh + MonthLow + MonthClose)/3);

      MR1 = (2*MonthPivot)-MonthLow;
      MS1 = (2*MonthPivot)-MonthHigh;

      MR2 = MonthPivot+(MR1-MS1);
      MS2 = MonthPivot-(MR1-MS1);

      MS3 = (MonthLow - (2*(MonthHigh-MonthPivot)));
      MR3 = (MonthHigh + (2*(MonthPivot-MonthLow)));

//--------------------------------------------------------

ArrayCopyRates(Previous_Price, Symbol(), 0);

PreviousHigh  = Previous_Price[1][3];
PreviousLow   = Previous_Price[1][2];
PreviousClose = Previous_Price[1][4];

PreviousPivot = ((PreviousHigh + PreviousLow + PreviousClose)/3);

      PR1 = (2*PreviousPivot)-PreviousLow;
      PS1 = (2*PreviousPivot)-PreviousHigh;

      PR2 = PreviousPivot+(PR1-PS1);
      PS2 = PreviousPivot-(PR1-PS1);

      PS3 = (PreviousLow - (2*(PreviousHigh-PreviousPivot)));
      PR3 = (PreviousHigh + (2*(PreviousPivot-PreviousLow)));

//--------------------------------------------------------

if (Daily==true)
 {
  TimeToStr(CurTime());
  ObjectCreate("PivotLine", OBJ_HLINE,0, CurTime(),Pivot);
  ObjectSet("PivotLine", OBJPROP_COLOR, Magenta);
  ObjectSet("PivotLine", OBJPROP_STYLE, STYLE_DASH);

 if(ObjectFind("PivotLabel") != 0)
  {
   ObjectCreate("PivotLabel", OBJ_TEXT, 0, Time[20], Pivot);
   ObjectSetText("PivotLabel", ("Daily Pivot"), 12, "Arial", Magenta);
  }
 else
  {
   ObjectMove("PivotLabel", 0, Time[20], Pivot);
  }
ObjectsRedraw();

//--------------------------------------------------------

if (Daily_SR_Levels==true)
 {
  ObjectCreate("R1_Line", OBJ_HLINE,0, CurTime(),R1);
  ObjectSet("R1_Line", OBJPROP_COLOR, Red);
  ObjectSet("R1_Line", OBJPROP_STYLE, STYLE_DASH);

 if(ObjectFind("R1_Label") != 0)
  {
   ObjectCreate("R1_Label", OBJ_TEXT, 0, Time[20], R1);
   ObjectSetText("R1_Label", "Daily R1", 12, "Arial", Red);
  }
 else
  {
   ObjectMove("R1_Label", 0, Time[20], R1);
  }

//--------------------------------------------------------

   ObjectCreate("R2_Line", OBJ_HLINE,0, CurTime(),R2);
   ObjectSet("R2_Line", OBJPROP_COLOR, Red);
   ObjectSet("R2_Line", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("R2_Label") != 0)
  {
   ObjectCreate("R2_Label", OBJ_TEXT, 0, Time[20], R2);
   ObjectSetText("R2_Label", "Daily R2", 12, "Arial", Red);
  }
 else
  {
   ObjectMove("R2_Label", 0, Time[20], R2);
  }

//---------------------------------------------------------

   ObjectCreate("R3_Line", OBJ_HLINE,0, CurTime(),R3);
   ObjectSet("R3_Line", OBJPROP_COLOR, Red);
   ObjectSet("R3_Line", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("R3_Label") != 0)
  {
   ObjectCreate("R3_Label", OBJ_TEXT, 0, Time[20], R3);
   ObjectSetText("R3_Label", "Daily R3", 12, "Arial", Red);
  }
 else
  {
   ObjectMove("R3_Label", 0, Time[20], R3);
  }

//---------------------------------------------------------

   ObjectCreate("S1_Line", OBJ_HLINE,0, CurTime(),S1);
   ObjectSet("S1_Line", OBJPROP_COLOR, LimeGreen);
   ObjectSet("S1_Line", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("S1_Label") != 0)
  {
   ObjectCreate("S1_Label", OBJ_TEXT, 0, Time[20], S1);
   ObjectSetText("S1_Label", "Daily S1", 12, "Arial", DarkBlue);
  }
 else
  {
   ObjectMove("S1_Label", 0, Time[20], S1);
  }

//---------------------------------------------------------

   ObjectCreate("S2_Line", OBJ_HLINE,0, CurTime(),S2);
   ObjectSet("S2_Line", OBJPROP_COLOR, LimeGreen);
   ObjectSet("S2_Line", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("S2_Label") != 0)
  {
   ObjectCreate("S2_Label", OBJ_TEXT, 0, Time[20], S2);
   ObjectSetText("S2_Label", "Daily S2", 12, "Arial", DarkBlue);
  }
 else
  {
   ObjectMove("S2_Label", 0, Time[20], S2);
  }

//---------------------------------------------------------

   ObjectCreate("S3_Line", OBJ_HLINE,0, CurTime(),S3);
   ObjectSet("S3_Line", OBJPROP_COLOR, LimeGreen);
   ObjectSet("S3_Line", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("S3_Label") != 0)
  {
   ObjectCreate("S3_Label", OBJ_TEXT, 0, Time[20], S3);
   ObjectSetText("S3_Label", "Daily S3", 12, "Arial", DarkBlue);
  }
 else
  {
   ObjectMove("S3_Label", 0, Time[20], S3);
  }
 }
ObjectsRedraw();
}

//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------

if (Weekly==true)
 {
  ObjectCreate("WeekPivotLine", OBJ_HLINE,0, CurTime(),WeekPivot);
  ObjectSet("WeekPivotLine", OBJPROP_COLOR, Aqua);
  ObjectSet("WeekPivotLine", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("WeekPivotLabel") != 0)
  {
   ObjectCreate("WeekPivotLabel", OBJ_TEXT, 0, Time[30], WeekPivot);
   ObjectSetText("WeekPivotLabel", "WeeklyPivot", 12, "Arial", Aqua);
  }
 else
  {
   ObjectMove("WeekPivotLabel", 0, Time[30], WeekPivot);
  }

//--------------------------------------------------------

if (Weekly_SR_Levels==true)
 {
  ObjectCreate("WR1_Line", OBJ_HLINE,0, CurTime(),WR1);
  ObjectSet("WR1_Line", OBJPROP_COLOR, Yellow);
  ObjectSet("WR1_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("WR1_Label") != 0)
  {
   ObjectCreate("WR1_Label", OBJ_TEXT, 0, Time[30], WR1);
   ObjectSetText("WR1_Label", " Weekly R1", 12, "Arial", Yellow);
  }
 else
  {
   ObjectMove("WR1_Label", 0, Time[30], WR1);
  }

//--------------------------------------------------------

   ObjectCreate("WR2_Line", OBJ_HLINE,0, CurTime(),WR2);
   ObjectSet("WR2_Line", OBJPROP_COLOR, Yellow);
   ObjectSet("WR2_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("WR2_Label") != 0)
  {
   ObjectCreate("WR2_Label", OBJ_TEXT, 0, Time[30], WR2);
   ObjectSetText("WR2_Label", " Weekly R2", 12, "Arial", Yellow);
  }
 else
  {
   ObjectMove("WR2_Label", 0, Time[30], WR2);
  }

//---------------------------------------------------------

   ObjectCreate("WR3_Line", OBJ_HLINE,0, CurTime(),WR3);
   ObjectSet("WR3_Line", OBJPROP_COLOR, Yellow);
   ObjectSet("WR3_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("WR3_Label") != 0)
  {
   ObjectCreate("WR3_Label", OBJ_TEXT, 0, Time[30], WR3);
   ObjectSetText("WR3_Label", " Weekly R3", 12, "Arial", Yellow);
  }
 else
  {
   ObjectMove("WR3_Label", 0, Time[30], WR3);
  }

//---------------------------------------------------------

   ObjectCreate("WS1_Line", OBJ_HLINE,0, CurTime(),WS1);
   ObjectSet("WS1_Line", OBJPROP_COLOR, SteelBlue);
   ObjectSet("WS1_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("WS1_Label") != 0)
  {
   ObjectCreate("WS1_Label", OBJ_TEXT, 0, Time[30], WS1);
   ObjectSetText("WS1_Label", "Weekly S1", 12, "Arial", SteelBlue);
  }
 else
  {
   ObjectMove("WS1_Label", 0, Time[30], WS1);
  }

//---------------------------------------------------------

   ObjectCreate("WS2_Line", OBJ_HLINE,0, CurTime(),WS2);
   ObjectSet("WS2_Line", OBJPROP_COLOR, SteelBlue);
   ObjectSet("WS2_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("WS2_Label") != 0)
  {
   ObjectCreate("WS2_Label", OBJ_TEXT, 0, Time[30], WS2);
   ObjectSetText("WS2_Label", "Weekly S2", 12, "Arial", SteelBlue);
  }
 else
  {
   ObjectMove("WS2_Label", 0, Time[30], WS2);
  }

//---------------------------------------------------------

   ObjectCreate("WS3_Line", OBJ_HLINE,0, CurTime(),WS3);
   ObjectSet("WS3_Line", OBJPROP_COLOR, SteelBlue);
   ObjectSet("WS3_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("WS3_Label") != 0)
  {
   ObjectCreate("WS3_Label", OBJ_TEXT, 0, Time[30], WS3);
   ObjectSetText("WS3_Label", "Weekly S3", 12, "Arial", SteelBlue);
  }
 else
  {
   ObjectMove("WS3_Label", 0, Time[30], WS3);
  }
 }
}

//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------

if (Monthly==true)
 {
  ObjectCreate("MonthPivotLine", OBJ_HLINE,0, CurTime(),MonthPivot);
  ObjectSet("MonthPivotLine", OBJPROP_COLOR, White);
  ObjectSet("MonthPivotLine", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("MonthPivotLabel") != 0)
  {
   ObjectCreate("MonthPivotLabel", OBJ_TEXT, 0, Time[40], MonthPivot);
   ObjectSetText("MonthPivotLabel", "MonthlyPivot", 12, "Arial", White);
  }
 else
  {
   ObjectMove("MonthPivotLabel", 0, Time[40], MonthPivot);
  }

//--------------------------------------------------------

if (Monthly_SR_Levels==true)
 {
  ObjectCreate("MR1_Line", OBJ_HLINE,0, CurTime(),MR1);
  ObjectSet("MR1_Line", OBJPROP_COLOR, Blue);
  ObjectSet("MR1_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("MR1_Label") != 0)
  {
   ObjectCreate("MR1_Label", OBJ_TEXT, 0, Time[40], MR1);
   ObjectSetText("MR1_Label", " Monthly R1", 12, "Arial", Blue);
  }
 else
  {
   ObjectMove("MR1_Label", 0, Time[40], MR1);
  }

//--------------------------------------------------------

   ObjectCreate("MR2_Line", OBJ_HLINE,0, CurTime(),MR2);
   ObjectSet("MR2_Line", OBJPROP_COLOR, Blue);
   ObjectSet("MR2_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("MR2_Label") != 0)
  {
   ObjectCreate("MR2_Label", OBJ_TEXT, 0, Time[40], MR2);
   ObjectSetText("MR2_Label", " Monthly R2", 12, "Arial", Blue);
  }
 else
  {
   ObjectMove("MR2_Label", 0, Time[40], MR2);
  }

//---------------------------------------------------------

   ObjectCreate("MR3_Line", OBJ_HLINE,0, CurTime(),MR3);
   ObjectSet("MR3_Line", OBJPROP_COLOR, Blue);
   ObjectSet("MR3_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("MR3_Label") != 0)
  {
   ObjectCreate("MR3_Label", OBJ_TEXT, 0, Time[40], MR3);
   ObjectSetText("MR3_Label", " Monthly R3", 12, "Arial", Blue);
  }
 else
  {
   ObjectMove("MR3_Label", 0, Time[40], MR3);
  }

//---------------------------------------------------------

   ObjectCreate("MS1_Line", OBJ_HLINE,0, CurTime(),MS1);
   ObjectSet("MS1_Line", OBJPROP_COLOR, Silver);
   ObjectSet("MS1_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("MS1_Label") != 0)
  {
   ObjectCreate("MS1_Label", OBJ_TEXT, 0, Time[40], MS1);
   ObjectSetText("MS1_Label", "Monthly S1", 12, "Arial", Silver);
  }
 else
  {
   ObjectMove("MS1_Label", 0, Time[40], MS1);
  }

//---------------------------------------------------------

   ObjectCreate("MS2_Line", OBJ_HLINE,0, CurTime(),MS2);
   ObjectSet("MS2_Line", OBJPROP_COLOR, Silver);
   ObjectSet("MS2_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("MS2_Label") != 0)
  {
   ObjectCreate("MS2_Label", OBJ_TEXT, 0, Time[40], MS2);
   ObjectSetText("MS2_Label", "Monthly S2", 12, "Arial", Silver);
  }
 else
  {
   ObjectMove("MS2_Label", 0, Time[40], MS2);
  }

//---------------------------------------------------------

   ObjectCreate("MS3_Line", OBJ_HLINE,0, CurTime(),MS3);
   ObjectSet("MS3_Line", OBJPROP_COLOR, Silver);
   ObjectSet("MS3_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("MS3_Label") != 0)
  {
   ObjectCreate("MS3_Label", OBJ_TEXT, 0, Time[40], MS3);
   ObjectSetText("MS3_Label", "Monthly S3", 12, "Arial", Silver);
  }
 else
  {
   ObjectMove("MS3_Label", 0, Time[40], MS3);
  }
 }
}
//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------

if (Previous==true)
 {
  ObjectCreate("PreviousPivotLine", OBJ_HLINE,0, CurTime(),PreviousPivot);
  ObjectSet("PreviousPivotLine", OBJPROP_COLOR, Red);
  ObjectSet("PreviousPivotLine", OBJPROP_STYLE, STYLE_DASH);
 if(ObjectFind("PreviousPivotLabel") != 0)
  {
   ObjectCreate("PreviousPivotLabel", OBJ_TEXT, 0, Time[40], PreviousPivot);
   ObjectSetText("PreviousPivotLabel", "PreviousPivot", 12, "Arial", Red);
  }
 else
  {
   ObjectMove("PreviousPivotLabel", 0, Time[40], PreviousPivot);
  }

//--------------------------------------------------------

if (Previous_SR_Levels==true)
 {
  ObjectCreate("PR1_Line", OBJ_HLINE,0, CurTime(),PR1);
  ObjectSet("PR1_Line", OBJPROP_COLOR, Blue);
  ObjectSet("PR1_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("PR1_Label") != 0)
  {
   ObjectCreate("PR1_Label", OBJ_TEXT, 0, Time[40], PR1);
   ObjectSetText("PR1_Label", " Previous Bar R1", 12, "Arial", Blue);
  }
 else
  {
   ObjectMove("PR1_Label", 0, Time[40], PR1);
  }

//--------------------------------------------------------

   ObjectCreate("PR2_Line", OBJ_HLINE,0, CurTime(),PR2);
   ObjectSet("PR2_Line", OBJPROP_COLOR, Blue);
   ObjectSet("PR2_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("PR2_Label") != 0)
  {
   ObjectCreate("PR2_Label", OBJ_TEXT, 0, Time[40], PR2);
   ObjectSetText("PR2_Label", " Previous Bar R2", 12, "Arial", Blue);
  }
 else
  {
   ObjectMove("PR2_Label", 0, Time[40], PR2);
  }

//---------------------------------------------------------

   ObjectCreate("PR3_Line", OBJ_HLINE,0, CurTime(),PR3);
   ObjectSet("PR3_Line", OBJPROP_COLOR, Blue);
   ObjectSet("PR3_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("PR3_Label") != 0)
  {
   ObjectCreate("PR3_Label", OBJ_TEXT, 0, Time[40], PR3);
   ObjectSetText("PR3_Label", " Previous Bar R3", 12, "Arial", Blue);
  }
 else
  {
   ObjectMove("PR3_Label", 0, Time[40], PR3);
  }

//---------------------------------------------------------

   ObjectCreate("PS1_Line", OBJ_HLINE,0, CurTime(),PS1);
   ObjectSet("PS1_Line", OBJPROP_COLOR, Silver);
   ObjectSet("PS1_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("PS1_Label") != 0)
  {
   ObjectCreate("PS1_Label", OBJ_TEXT, 0, Time[40], PS1);
   ObjectSetText("PS1_Label", "Previous Bar S1", 12, "Arial", Silver);
  }
 else
  {
   ObjectMove("PS1_Label", 0, Time[40], PS1);
  }

//---------------------------------------------------------

   ObjectCreate("PS2_Line", OBJ_HLINE,0, CurTime(),PS2);
   ObjectSet("PS2_Line", OBJPROP_COLOR, Silver);
   ObjectSet("PS2_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("PS2_Label") != 0)
  {
   ObjectCreate("PS2_Label", OBJ_TEXT, 0, Time[40], PS2);
   ObjectSetText("PS2_Label", "Previous Bar S2", 12, "Arial", Silver);
  }
 else
  {
   ObjectMove("PS2_Label", 0, Time[40], PS2);
  }

//---------------------------------------------------------

   ObjectCreate("PS3_Line", OBJ_HLINE,0, CurTime(),PS3);
   ObjectSet("PS3_Line", OBJPROP_COLOR, Silver);
   ObjectSet("PS3_Line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
 if(ObjectFind("PS3_Label") != 0)
  {
   ObjectCreate("PS3_Label", OBJ_TEXT, 0, Time[40], PS3);
   ObjectSetText("PS3_Label", "Previous Bar S3", 12, "Arial", Silver);
  }
 else
  {
   ObjectMove("PS3_Label", 0, Time[40], PS3);
  }
 }
}
//---------------------------------------------------------

ObjectsRedraw();


// EA starts here:
int ticket_buy, ticket_sell;
double open_price;
datetime ctm_buy, ctm_sell;

   double curr_open = iOpen(NULL, 0, 0);
   double last_high = iHigh(NULL, 0, 1);
   double last_low = iLow(NULL, 0, 1);
   double last_close = iClose(NULL, 0, 1);
   
   double is_able_to_continue = (PS2-PreviousPivot)*MathPow(10,Digits);
   is_able_to_continue = +is_able_to_continue;
   if (is_able_to_continue < MinimumToContinue) {
      Comment("EA is not able to continue distance from PS2 and Pivot are less than ", MinimumToContinue, " pips");
      return(0);
   } else {
      Comment("EA is able to continue :). Good trade.");
   }

double buy_stop = PS2;
double buy_stoploss= NormalizeDouble(PS2-StopLoss*Point, Digits);

double buy_takeprofit = NormalizeDouble(buy_stop+TakeProfit*Point,Digits);

double sell_stop = PR2;
double sell_stoploss = NormalizeDouble(PR2+StopLoss*Point, Digits);

double sell_takeprofit = NormalizeDouble(sell_stop-TakeProfit*Point,Digits);

if (UsePivotPointTakeProfit == true) {
   buy_takeprofit = PreviousPivot;
   sell_takeprofit = PreviousPivot;
}

MathSrand(TimeLocal());
int rand_magic = MathRand();
   int check_buy = get_pending_order(OP_BUYLIMIT, BuyComment);
   if (check_buy != 0) {
      ticket_buy = check_buy;
   }
   int check_sell = get_pending_order(OP_SELLLIMIT, SellComment);
   if (check_sell != 0) {
      ticket_sell = check_sell;
   }   
   
   if(OrderSelect(ticket_buy,SELECT_BY_TICKET,MODE_TRADES)) {
      open_price = NormalizeDouble(OrderOpenPrice(),Digits);
      //Alert("buy_stop: ",buy_stop," open_price: ", open_price);
      if (!CompareDoubles(buy_stop, open_price)) { // Support 3 mudou, muda a ordem
        if (!OrderModify(ticket_buy,buy_stop,buy_stoploss,buy_takeprofit,0,CLR_NONE)) {
            Alert("Last error: ",ErrorDescription(GetLastError()));
        }
      }
      ctm_buy=OrderCloseTime();
      if(ctm_buy>0) { // checa se a ordem foi fechada
        ticket_buy = 0;
      }
   } else {
      ticket_buy=OrderSend(Symbol(),OP_BUYLIMIT,LotSize,buy_stop,3,buy_stoploss,buy_takeprofit,BuyComment,rand_magic,0,CLR_NONE);
      if(ticket_buy<0)
         {
            Comment("OrderSend BUYLIMIT failed with error #",ErrorDescription(GetLastError()));
            return(0);
         }
   } // fim ticket_buy

   if(OrderSelect(ticket_sell,SELECT_BY_TICKET,MODE_TRADES)) {
      open_price = NormalizeDouble(OrderOpenPrice(),Digits);
      //Alert("sell_stop: ",sell_stop," open_price: ", open_price);
      if (!CompareDoubles(sell_stop, open_price)) { // Resistencia 3 mudou, muda a ordem
        if (!OrderModify(ticket_sell,sell_stop,sell_stoploss,sell_takeprofit,0,CLR_NONE)) {
           Alert("Last error: ",ErrorDescription(GetLastError()));
        }
      }
      ctm_sell=OrderCloseTime();
      if(ctm_sell>0) { // checa se a ordem foi fechada
        ticket_sell = 0;
      }
   } else {
     ticket_sell=OrderSend(Symbol(),OP_SELLLIMIT,LotSize,sell_stop,3,sell_stoploss,sell_takeprofit,SellComment,rand_magic,0,CLR_NONE);
     if(ticket_sell<0)
      {
       Comment("OrderSend SELLIMIT failed with error #",ErrorDescription(GetLastError()));
       return(0);
      }
   } // fim ticket_sell

   return(0);
}

int get_pending_order(int order_type, string order_comment) {
   int    cmd,total,order_ticket;
//----
   total=OrdersTotal();
//----
   for(int i=0; i<total; i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
        {
         cmd=OrderType();
         //---- pending orders only are considered
         if(cmd==order_type && OrderComment() == order_comment)
           {
            //---- print selected order
            OrderPrint();
            //---- delete first pending order
            //result=OrderDelete(OrderTicket());
            //if(result!=TRUE) Print("LastError = ", ErrorDescription(GetLastError()));
            order_ticket = OrderTicket();
            break;
           }
        } else {
           Comment( "Error when order select ", ErrorDescription(GetLastError())); break;
        }
     }
     return(order_ticket);
}