#property copyright "Rosen Marinchev"
#property link      "rmarinchev@gmail.com"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Yellow
#property indicator_color2 Gray
#property indicator_color3 Gray
#property indicator_color4 Green
#property indicator_color5 Red
#property indicator_color6 Green
#property indicator_color7 Red

extern string comment1 = "MBFX system settings";
extern int smoothing = 30;
extern double ext = 25.0;
extern string comment2 = "Money management settings";
extern int firstStop = 6;
extern int secondStop = 6;
extern double minRewardRisk = 2.0;
extern int stopMethod = 1;
extern bool removeObjectivesWhenHit = FALSE;
extern string comment3 = "Alert settings";
extern bool email = FALSE;
// extern bool Setup = FALSE;
extern bool Entry = FALSE;
extern bool targetHit = FALSE;
extern bool stopHit = FALSE;
extern bool targetHitVoice = FALSE;
extern bool stopHitVoice = FALSE;
extern bool drawTrendlinesAndArrows = TRUE;
extern int barsBack = 300;
string gs_176 = "mbfx_";
bool gi_200 = FALSE;
bool gi_204 = FALSE;
int gi_208 = 0;
int gi_212 = 0;
double gd_216 = 0.0;
double gd_224 = 0.0;
double gd_232 = 0.0;
double gd_240 = 0.0;
double gd_248;
double gd_256;
double gd_264;
double gd_272;
double gd_280;
int gi_288 = 0;
double gd_292;
int gi_300 = 3;
int gi_308 = 0;
double gibuf_312[];
double gibuf_316[];
double gibuf_320[];
double gibuf_324[];
double gibuf_328[];
double gibuf_332[];
double gibuf_336[];
string gs_340 = "stoploss_hit.wav";
string gs_348 = "target_hit.wav";
bool gi_356 = FALSE;
bool gi_360 = FALSE;

// E37F0136AA3FFAF149B351F6A4C948E9
int init() {
   gd_292 = Point;
   if (Digits == 1 || Digits == 3 || Digits == 5)
     {
       firstStop *= 10;
       secondStop *= 10;
       gd_292 *= 10.0;
     }
      if (ext < 0) ext = MathAbs(ext);
      if (ext == 0) ext = 1.0;
      if (minRewardRisk < 0) minRewardRisk = MathAbs(minRewardRisk);
      if (stopMethod < 1 || stopMethod > 3) {
         Comment("Invalid stopMethod value. Choose a option between 1 and 3. Indicator is now disabled.");
         gi_356 = 1;
      }
      SetIndexBuffer(0, gibuf_312);
      SetIndexBuffer(1, gibuf_316);
      SetIndexBuffer(2, gibuf_320);
      SetIndexBuffer(3, gibuf_328);
      SetIndexBuffer(4, gibuf_324);
      SetIndexBuffer(5, gibuf_336);
      SetIndexBuffer(6, gibuf_332);
      return (0);
}

// 52D46093050F38C27267BCE42543EF60
void deinit() {
   f0_10(gs_176);
   Comment("");
}

// EA2B2676C28C0DB26D39331A336C6B92
void start() {
   double ld_16;
   double ld_24;
   double ld_32;
   string ls_64;
   string ls_72;
   string ls_80;
   int li_88;
   int li_92;
   
   if (gi_356) {
      return(0);
   }
   int li_0 = 20;
   int li_4 = 20;
   for (int li_8 = MathCeil(MathMin(Bars - IndicatorCounted() - 1, barsBack)); li_8 >= 0; li_8--) {
      gibuf_320[li_8] = f0_9(li_8, smoothing);
      gibuf_316[li_8] = f0_0(li_8, smoothing);
      gibuf_312[li_8] = (gibuf_320[li_8] + gibuf_316[li_8]) / 2.0;
      gibuf_328[li_8] = f0_5(li_8, smoothing);
      gibuf_324[li_8] = f0_21(li_8, smoothing);
      gibuf_336[li_8] = f0_4(li_8, smoothing);
      gibuf_332[li_8] = f0_16(li_8, smoothing);
   }
   f0_23("0", gibuf_312[0], 65535);
   f0_23("+1", gibuf_316[0], 8421504);
   f0_23("+2", gibuf_324[0], 255);
   f0_23("+3", gibuf_332[0], 255);
   f0_23("-1", gibuf_320[0], 8421504);
   f0_23("-2", gibuf_328[0], 32768);
   f0_23("-3", gibuf_336[0], 32768);
   int li_12 = 0;
   if (Time[0] != gi_212) {
      gi_212 = Time[0];
      li_12 = 1;
   }
   if (gi_288 != 0) {
      if (gd_216>0.0 && gd_224>0.0 && gd_232>0.0) {
         ld_16 = 0.0;
         ld_24 = 0.0;
         ld_32 = 0.0;
         if (gi_288>0) {
            switch (stopMethod) {
            case 1:
               ld_32 = gd_232;
               break;
            case 2:
               ld_32 = gd_224;
               break;
            case 3:
               ld_32 = MathMax(gd_224, gd_232);
            }
            li_4 += 20;
            f0_19("liveratio", li_0, li_4, StringConcatenate("Live profit: ", DoubleToStr((Close[0] - gd_240) / gd_292, 1), " pips"), 16777215);
            ld_16 = MathAbs(Close[0] - gd_216) / MathAbs(ld_32 - Close[0]);
            li_4 += 20;
            f0_19("livepl", li_0, li_4, StringConcatenate("Live P/L: ", DoubleToStr(ld_16,1), ":1"), 16777215);
            if (Close[0] >= gd_216) {
               if (drawTrendlinesAndArrows) {
                  f0_15("trend_tp", gd_240, gi_308, gd_216, Time[0], 16711680);
                  f0_7("arrow_tp", 3, gd_216, Time[0], 16711680);
               }
               if (targetHit) Alert("Target hit on ", Symbol());
               if (targetHitVoice) PlaySound(gs_348);
               if (email) {
                  ld_24 = (gd_216 - gd_240) / gd_292;
                  SendMail("MBFX System Alert", StringConcatenate("TP Hit on " + Symbol(), " P/L: ", DoubleToStr(ld_24,1), " pips"));
               }
               f0_12();
            } else {
               if (Close[0] != ld_32) {
                  if (drawTrendlinesAndArrows) {
                     f0_15("trend_sl", gd_240, gi_308, ld_32, Time[0], 16711680);
                     f0_7("arrow_sl", 3, ld_32, Time[0], 16711680);
                  }
                  if (stopHit) Alert("Stop hit on ", Symbol());
                  if (stopHitVoice) PlaySound(gs_340);
                  if (email) {
                     ld_24 = (ld_32 - gd_240) / gd_292;
                     SendMail("MBFX System Alert", StringConcatenate("SL Hit on " + Symbol(), " P/L: ", DoubleToStr(ld_24,1), " pips"));
                  }
                  f0_12();
               }
            }
         } else {
            if (gi_288<0) {
               switch (stopMethod) {
               case 1:
                  ld_32 = gd_232;
                  break;
               case 2:
                  ld_32 = gd_224;
                  break;
               case 3:
                  ld_32 = MathMin(gd_224, gd_232);
               }
               li_4 += 20;
               f0_19("liveratio", li_0, li_4, StringConcatenate("Live profit: ", DoubleToStr((gd_240 - Close[0]) / gd_292,1), " pips"), 16777215);
               ld_16 = MathAbs(Close[0] - gd_216) / MathAbs(ld_32 - Close[0]);
               li_4 += 20;
               f0_19("livepl", li_0, li_4, StringConcatenate("Live P/L: ", DoubleToStr(ld_16,1), ":1"), 16777215);
               if (Close[0] != gd_216) {
                  if (drawTrendlinesAndArrows) {
                     f0_15("trend_tp", gd_240, gi_308, gd_216, Time[0], 255);
                     f0_7("arrow_tp", 3, gd_216, Time[0], 255);
                  }
                  if (targetHit) Alert("Target hit on ", Symbol());
                  if (targetHitVoice) PlaySound(gs_348);
                  if (email) {
                     ld_24 = (gd_240 - gd_216) / gd_292;
                     SendMail("MBFX System Alert", StringConcatenate("TP Hit on " + Symbol(), " P/L: ", DoubleToStr(ld_24,1), " pips"));
                  }
                  f0_12();
               } else {
                  if (Close[0] >= ld_32) {
                     if (drawTrendlinesAndArrows) {
                        f0_15("trend_sl", gd_240, gi_308, ld_32, Time[0], 255);
                        f0_7("arrow_sl", 3, ld_32, Time[0], 255);
                     }
                     if (stopHit) Alert("Stop hit on ", Symbol());
                     if (stopHitVoice) PlaySound(gs_340);
                     if (email) {
                        ld_24 = (gd_240 - ld_32) / gd_292;
                        SendMail("MBFX System Alert", StringConcatenate("SL Hit on " + Symbol(), " P/L: ", DoubleToStr(ld_24,1), " pips"));
                     }
                     f0_12();
                  }
               }
            }
         }
      }
      return(0);
   }
   double ld_48 = gibuf_324[0];
   double ld_56 = gibuf_328[0];
   if ((gi_200==0 && gi_288==0) && (Close[0]>ld_48)) {
      f0_18();
      gi_200 = 1;
      gi_208 = Time[0];
   } else {
      if ((gi_204==0 && gi_288==0) && (Close[0]<ld_56)) {
         f0_18();
         gi_204 = 1;
         gi_208 = Time[0];
      }
   }
   if (li_12==true) {
      li_88 = 0;
      li_92 = 255;
      if (gi_200) {
         li_88 = iBarShift(Symbol(), 0, gi_208, TRUE);
         if ((High[1] <= High[li_88]) && (li_88 > 1)) {
            gd_240 = Close[1];
            gi_308 = Time[1];
            gd_216 = gibuf_312[1];
            gd_224 = High[1] + (firstStop * Point);
            gd_232 = High[2] + (secondStop * Point);
            gd_248 = MathAbs((gd_224 - gd_240) / gd_292);
            gd_256 = MathAbs((gd_232 - gd_240) / gd_292);
            if ((gd_216 < gd_240) && (gd_248>0 && gd_256>0)) {
               f0_13(65280, High[1], Time[1], 180, "top");
               if (drawTrendlinesAndArrows) f0_7("entry", 1, gd_240, gi_308, 255);
               gi_288 = -1;
               gd_264 = MathAbs((gd_216 - gd_240) / gd_292);
               gd_272 = gd_264 / gd_248;
               gd_280 = gd_264 / gd_256;
               if (stopMethod==2 || stopMethod==3) f0_17("firstStop", gd_224, Time[1], Time[1] + 60 * (gi_300 * Period()), 255);
               if (stopMethod==1 || stopMethod==3) f0_17("secondStop", gd_232, Time[2], Time[2] + 60 * (gi_300 * Period()), 255);
               f0_17("target", gd_216, Time[1], Time[1] + 60 * (gi_300 * Period()), 65280);
               ls_64 = StringConcatenate("SL1: ", DoubleToStr(gd_248,1), " pips P/L: ", DoubleToStr(gd_272,1), ":1");
               ls_80 = StringConcatenate("TP: ", DoubleToStr(gd_264,1), " pips");
               ls_72 = StringConcatenate("SL2: ", DoubleToStr(gd_256,1), " pips P/L: ", DoubleToStr(gd_280,1), ":1");
               li_4 += 60;
               if (NormalizeDouble(gd_272,1) >= NormalizeDouble(minRewardRisk,1)) li_92 = 65280;
               else li_92 = 255;
               if (stopMethod!=1) {
                  f0_22("firstStop", li_0, li_4, ls_64, li_92);
                  li_4 += 20;
               }
               if (NormalizeDouble(gd_280,1) >= NormalizeDouble(minRewardRisk,1)) li_92 = 65280;
               else li_92 = 255;
               if (stopMethod!=2) {
                  f0_22("secondStop", li_0, li_4, ls_72, li_92);
                  li_4 += 20;
               }
               f0_22("target", li_0, li_4, ls_80, 65280);
               li_4 += 40;
               f0_8("entryLevel", li_0, li_4, StringConcatenate("entry: ", DoubleToStr(gd_240, Digits)), 16777215);
               li_4 += 20;
               f0_8("targetLevel", li_0, li_4, StringConcatenate("target: ", DoubleToStr(gd_216, Digits)), 65280);
               li_4 += 20;
               if (stopMethod!=1) {
                  f0_8("firstStopLevel", li_0, li_4, StringConcatenate("1st stop: ", DoubleToStr(gd_224, Digits)), 255);
                  li_4 += 20;
               }
               if (stopMethod!=2) {
                  f0_8("secondStopLevel", li_0, li_4, StringConcatenate("2nd stop: ", DoubleToStr(gd_232, Digits)), 255);
                  li_4 += 20;
               }
               if (gi_360==0) gi_360 = 1;
               if (li_12!=0 && Entry!=0) {
                  Alert("Setup at ", Symbol());
                  if (email) {
                     SendMail("MBFX System Alert", StringConcatenate("Entry on ", Symbol(), " Sell at ", DoubleToStr(gd_240, Digits), " SL1: ", DoubleToStr(gd_224, Digits), " SL2:", DoubleToStr(gd_232, Digits),
                        " TP: ", DoubleToStr(gd_216, Digits)));
                  }
               }
            }
         } else {
            f0_13(65535, High[1], Time[1], 180, "top");
            gi_208 = Time[1];
         }
      } else {
         if (gi_204) {
            li_88 = iBarShift(Symbol(), 0, gi_208, TRUE);
            if ((Low[1] > Low[li_88]) && (li_88 > 1)) {
               gd_240 = Close[1];
               gi_308 = Time[1];
               gd_216 = gibuf_312[1];
               gd_224 = Low[1] - (firstStop * Point);
               gd_232 = Low[2] - (secondStop * Point);
               gd_248 = MathAbs((gd_224 - gd_240) / gd_292);
               gd_256 = MathAbs((gd_232 - gd_240) / gd_292);
               if ((gd_216 > gd_240) && (gd_248>0.0 && gd_256>0.0)) {
                  f0_13(65280, Low[1], Time[1], 0, "top");
                  if (drawTrendlinesAndArrows) f0_7("entry", 1, gd_240, gi_308, 16711680);
                  gi_288 = 1;
                  gd_264 = MathAbs((gd_216 - gd_240) / gd_292);
                  gd_272 = gd_264 / gd_248;
                  gd_280 = gd_264 / gd_256;
                  if (stopMethod!=1) f0_17("firstStop", gd_224, Time[1], Time[1] + 60 * (gi_300 * Period()), 255);
                  if (stopMethod!=2) f0_17("secondStop", gd_232, Time[2], Time[2] + 60 * (gi_300 * Period()), 255);
                  f0_17("target", gd_216, Time[1], Time[1] + 60 * (gi_300 * Period()), 65280);
                  ls_80 = StringConcatenate("TP: ", DoubleToStr(gd_264,1), " pips");
                  ls_72 = StringConcatenate("SL2: ", DoubleToStr(gd_256,1), " pips P/L: ", DoubleToStr(gd_280,1), ":1");
                  ls_64 = StringConcatenate("SL1: ", DoubleToStr(gd_248,1), " pips P/L: ", DoubleToStr(gd_272,1), ":1");
                  li_4 += 60;
                  if (NormalizeDouble(gd_272,1) >= NormalizeDouble(minRewardRisk,1)) li_92 = 65280;
                  else li_92 = 255;
                  if (stopMethod!=1) {
                     f0_22("firstStop", li_0, li_4, ls_64, li_92);
                     li_4 += 20;
                  }
                  if (NormalizeDouble(gd_280,1) >= NormalizeDouble(minRewardRisk,1)) li_92 = 65280;
                  else li_92 = 255;
                  if (stopMethod!=2) {
                     f0_22("secondStop", li_0, li_4, ls_72, li_92);
                     li_4 += 20;
                  }
                  f0_22("target", li_0, li_4, ls_80, 65280);
                  li_4 += 40;
                  f0_8("entryLevel", li_0, li_4, StringConcatenate("entry: ", DoubleToStr(gd_240, Digits)), 16777215);
                  li_4 += 20;
                  f0_8("targetLevel", li_0, li_4, StringConcatenate("target: ", DoubleToStr(gd_216, Digits)), 65280);
                  li_4 += 20;
                  if (stopMethod!=1) {
                     f0_8("firstStopLevel", li_0, li_4, StringConcatenate("1st stop: ", DoubleToStr(gd_224, Digits)), 255);
                     li_4 += 20;
                  }
                  if (stopMethod!=2) {
                     f0_8("secondStopLevel", li_0, li_4, StringConcatenate("2nd stop: ", DoubleToStr(gd_232, Digits)), 255);
                     li_4 += 20;
                  }
                  if (gi_360==0) gi_360 = 1;
                  if ((li_12!=0) && (Entry>1)) {
                     Alert("Setup at ", Symbol());
                     if (email) {
                        SendMail("MBFX System Alert", StringConcatenate("Entry on ", Symbol(), " Buy at ", DoubleToStr(gd_240, Digits), " SL1: ", DoubleToStr(gd_224, Digits), " SL2:", DoubleToStr(gd_232, Digits),
                           " TP: ", DoubleToStr(gd_216, Digits)));
                     }
                  }
               }
            } else {
               f0_13(65535, Low[1], Time[1], 0, "bot");
               gi_208 = Time[1];
            }
         }
      }
   }
   if (gi_360) f0_8("objectives", 20, 5, "Last Signal Objectives", 16777215);
   else f0_8("objectives", 20, 5, "Waiting for Trade Entry", 16777215);
}

// D6538BCF947DB7B0FB48E34EA8F726C5
void f0_19(string a_name_0, int ai_8, int ai_12, string a_text_16, int ai_24, int a_fontsize_28 = 12) {
   a_name_0 = StringConcatenate(gs_176, a_name_0, "_live");
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 23, 0, 0, 0);
   ObjectSetText(a_name_0, a_text_16, a_fontsize_28);
   ObjectSet(a_name_0, 6, ai_24);
   ObjectSet(a_name_0, 101, 1);
   ObjectSet(a_name_0, 102, ai_8);
   ObjectSet(a_name_0, 103, ai_12);
}

// ACC9AFBFC2C814653A0E1FD1F0AA9BEE
void f0_15(string a_name_0, double ad_8, int ai_16, double ad_20, int ai_28, int ai_32 = 255) {
   if (removeObjectivesWhenHit==0) a_name_0 = StringConcatenate(Time[0], "_", a_name_0);
   a_name_0 = StringConcatenate(gs_176, a_name_0);
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 2, 0, 0, 0);
   ObjectSet(a_name_0, 1, ad_8);
   ObjectSet(a_name_0, 3, ad_20);
   ObjectSet(a_name_0, 0, ai_16);
   ObjectSet(a_name_0, 2, ai_28);
   ObjectSet(a_name_0, 10, 0);
   ObjectSet(a_name_0, 6, ai_32);
   ObjectSet(a_name_0, 7, 2);
}

// 793092939A660C4F0DF8D9127D8A9540
void f0_7(string a_name_0, int ai_8, double ad_12, double ad_20, int ai_28 = 55295) {
   if (removeObjectivesWhenHit==0) a_name_0 = StringConcatenate(Time[0], "_", a_name_0);
   a_name_0 = StringConcatenate(gs_176, a_name_0);
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 22, 0, 0, 0);
   ObjectSet(a_name_0, 14, ai_8);
   ObjectSet(a_name_0, 6, ai_28);
   ObjectSet(a_name_0, 1, ad_12);
   ObjectSet(a_name_0, 0, ad_20);
}

// 7CE58342490F2719632C99A1A5E38D1B
void f0_8(string a_name_0, int ai_8, int ai_12, string a_text_16, int ai_24, int a_fontsize_28 = 10) {
   a_name_0 = StringConcatenate(gs_176, a_name_0, "_header");
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 23, 0, 0, 0);
   ObjectSetText(a_name_0, a_text_16, a_fontsize_28);
   ObjectSet(a_name_0, 6, ai_24);
   ObjectSet(a_name_0, 101, 1);
   ObjectSet(a_name_0, 102, ai_8);
   ObjectSet(a_name_0, 103, ai_12);
}

// B4BC7C6E26502B63C5810C733F98777F
void f0_17(string a_name_0, double ad_8, int ai_16, int ai_20, int ai_24) {
   if (removeObjectivesWhenHit==0) a_name_0 = StringConcatenate(Time[0], "_", a_name_0);
   a_name_0 = StringConcatenate(gs_176, a_name_0);
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 2, 0, 0, 0);
   ObjectSet(a_name_0, 1, ad_8);
   ObjectSet(a_name_0, 3, ad_8);
   ObjectSet(a_name_0, 0, ai_16);
   ObjectSet(a_name_0, 2, ai_20);
   ObjectSet(a_name_0, 10, 0);
   ObjectSet(a_name_0, 6, ai_24);
   ObjectSet(a_name_0, 7, 0);
   ObjectSet(a_name_0, 8, 3);
}

// EE853665D288809CDE51F5C66DDF38BD
void f0_22(string a_name_0, int ai_8, int ai_12, string a_text_16, int ai_24, int a_fontsize_28 = 12) {
   a_name_0 = StringConcatenate(gs_176, a_name_0, "_label");
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 23, 0, 0, 0);
   ObjectSetText(a_name_0, a_text_16, a_fontsize_28);
   ObjectSet(a_name_0, 6, ai_24);
   ObjectSet(a_name_0, 101, 1);
   ObjectSet(a_name_0, 102, ai_8);
   ObjectSet(a_name_0, 103, ai_12);
}

// 9412A6A45DD5449E364277CDC2369903
void f0_12() {
   if (removeObjectivesWhenHit) f0_10(gs_176);
   gi_288 = 0;
   gd_216 = 0.0;
   gd_224 = 0.0;
   gd_232 = 0.0;
   gi_200 = 0;
   gi_204 = 0;
}

// BE07BCCD7E0E22912F38A97F676E753A
// Reinitialize
void f0_18() {
   gi_204 = 0;
   gi_200 = 0;
   f0_10(StringConcatenate(gs_176, "_circle_"));
}

// 952BE0DF37E79F7A3F0E725173C3E328
void f0_13(color a_color_0, double ad_4, int ai_12, int ai_16, string as_20 = "") {
   string name_28 = "_circle_prewarning";
   if (removeObjectivesWhenHit==0) name_28 = StringConcatenate(Time[0], "_", name_28);
   name_28 = StringConcatenate(gs_176, name_28, as_20);
   if (ObjectFind(name_28)<=0) ObjectCreate(name_28, 21, 0, 0, 0);
   ObjectSet(name_28, 1, ad_4);
   ObjectSet(name_28, 0, ai_12);
   ObjectSet(name_28, 13, ai_16);
   int li_36 = ObjectGet(name_28, 6);
   if (li_36 == a_color_0) a_color_0 = (li_36 / 1.4);
   ObjectSetText(name_28, CharToStr(152), 16, "Wingdings 2", a_color_0);
}

// 8A63CB50C3C72A8C7FC25DD76BB2E2B6
void f0_10(string as_0) {
   for (int li_8 = (ObjectsTotal()-1); li_8 >= 0; li_8--)
      if (StringFind(ObjectName(li_8), as_0) == 0) ObjectDelete(ObjectName(li_8));
}

// F5D4D62C62CBCA959F663B5C73167A5F
void f0_23(string a_name_0, double a_price_8, int ai_16) {
   a_name_0 = StringConcatenate(gs_176, a_name_0);
   if (ObjectFind(a_name_0)<=0) ObjectCreate(a_name_0, 22, 0, Time[0], a_price_8);
   ObjectSet(a_name_0, 14, 6);
   ObjectSet(a_name_0, 6, ai_16);
   ObjectSet(a_name_0, 0, Time[0]);
   ObjectSet(a_name_0, 1, a_price_8);
}

// 80DEFD324D6F92DD84E7C37E17350EC0
double f0_9(int ai_0, int ai_4) {
   double ld_8 = 0.0;
   for (int li_16 = (ai_0); li_16 < ai_0 + ai_4; li_16++) ld_8 += f0_20(li_16);
   return (ld_8 / ai_4);
}

// 061986351A858206FD0821B373F3A9DA
double f0_0(int ai_0, int ai_4) {
   double ld_8 = 0.0;
   for (int li_16 = (ai_0); li_16 < ai_0 + ai_4; li_16++) ld_8 += f0_14(li_16);
   return (ld_8 / ai_4);
}

// 5CA7E224A3BE437B7857D138723B71D3
double f0_5(int ai_0, int ai_4) {
   double ld_8 = 0.0;
   for (int li_16 = (ai_0); li_16 < ai_0 + ai_4; li_16++) ld_8 += f0_6(li_16);
   return (ld_8 / ai_4);
}

// DF4A36226E59263FF017C5AB0E613DAC
double f0_21(int ai_0, int ai_4) {
   double ld_8 = 0.0;
   for (int li_16 = (ai_0); li_16 < ai_0 + ai_4; li_16++) ld_8 += f0_2(li_16);
   return (ld_8 / ai_4);
}

// 439D35787DB10C724538112D7916E636
double f0_4(int ai_0, int ai_4) {
   double ld_8 = 0.0;
   for (int li_16 = (ai_0); li_16 < ai_0 + ai_4; li_16++) ld_8 += f0_1(li_16);
   return (ld_8 / ai_4);
}

// B0C42B8DCC4392BD4145C3519082B911
double f0_16(int ai_0, int ai_4) {
   double ld_8 = 0.0;
   for (int li_16 = (ai_0); li_16 < ai_0 + ai_4; li_16++) ld_8 += f0_3(li_16);
   return (ld_8 / ai_4);
}

// 8BFD3E3F510FE631B25FDC865CD9C26B
double f0_11(int ai_0) {
   double ld_4 = (High[ai_0 + 1] + Low[ai_0 + 1] + Close[ai_0 + 1]) / 3;
   return (ld_4);
}

// Support
double f0_20(int ai_0) {
   double ld_4 = (((ext / 100.0) + 2.0) * Low[ai_0]) - (((ext / 100.0) + 1.0) * f0_11(ai_0));
   return (ld_4);
}

// Resistance
double f0_14(int ai_0) {
   double ld_4 = (((ext / 100.0) + 2.0) * High[ai_0]) - (((ext / 100.0) + 1.0) * f0_11(ai_0));
   return (ld_4);
}

// 6128D493321AC906E620201D5DCB03D0
double f0_6(int ai_0) {
   double ld_4 = (((ext / 100.0) + 2.0) * Low[ai_0]) - (((ext / 100.0) + 1.0) * f0_14(ai_0));
   return (ld_4);
}

// 18AFABAF5C4F894A86E8E611B492F383
double f0_2(int ai_0) {
   double ld_4 = (((ext / 100.0) + 2.0) * High[ai_0]) - (((ext / 100.0) + 1.0) * f0_20(ai_0));
   return (ld_4);
}

// 12DAF24B2E6961F867F31AB6290B9BCE
double f0_1(int ai_0) {
   double ld_4 = (((ext / 100.0) + 2.0) * Low[ai_0]) - (((ext / 100.0) + 1.0) * f0_2(ai_0));
   return (ld_4);
}

// 234E7709E8498873BF0E6AE4DA2DBE15
double f0_3(int ai_0) {
   double ld_4 = (((ext / 100.0) + 2.0) * High[ai_0]) - (((ext / 100.0) + 1.0) * f0_6(ai_0));
   return (ld_4);
}