
/*

// IMPORT LIBRARY OF COMMON FUNCTIONS AND UTILITIES============================================================================================================

#import "ObjectLibrary.ex4"

	// GENRERAL UTILITIES-------------------------------------------------------------------------------------------------------------------------------------------------
	string	SNSLibrary.Version();
	void 		SNSTAG();
	void 		DeleteObjectsByPrefix(string Prefix);
	bool   	IsMini();
	bool   	IsDoubleDotted();
	bool   	IsDotted();	

	// GRAPHIC OBJECT UTILITIES-------------------------------------------------------------------------------------------------------------------------------------------
   void 		Draw_HLine(string prefix, string name, int style, int width, color clr, datetime x, double y, bool back, int window=0);
   void 		Draw_VLine(string prefix, string name, int style, int width, color clr, datetime x,  bool back, int window=0);
   void 		Draw_TLine(string prefix, string name, int style, int width, color clr, datetime x1, double y1, datetime x2, double y2, bool ray, bool back, int window=0);
	void 		Draw_LabeledLine(string prefix, string name, int style, int width, color clr, datetime x1, double y1, datetime x2, double y2, bool ray, string label, string font, int fontsize, color fontcolor,datetime labelx, double labely, int window=0);
	void 		Draw_Box(string prefix, string name, color boxcolor, datetime x1, double y1, datetime x2, double y2, bool back, int linewidth, int linestyle, int window=0);
   void 		Draw_Fibo(string prefix, string name, int style, int width, color fibcolor, int levelstyle, int levelwidth, color levelcolor,  datetime x1, double y1, datetime x2, double y2, bool ray, bool back, int window=0);
	void 		Draw_FiboChannel(string prefix, string name, int style, int width, color fibcolor, int levelstyle, int levelwidth, color levelcolor,  datetime x1, double y1, datetime x2, double y2, datetime x3, double y3, bool ray, bool back, int window=0);
   void 		Draw_Text(string prefix, string name, string text, datetime x, double y, string font, int fontsize, color fontcolor, bool back, int window=0);
   void 		Draw_VText(string prefix, string name, string text, datetime x, double y, string font, int fontsize, color fontcolor, bool back, int window=0);
   void 		Draw_Label(string prefix, string name, string text, int corner, int x, int y, string font, int fontsize, color fontcolor, bool back, int window=0);
   void 		Draw_Symbol(string prefix, string name, int code, color colour, datetime x, double y, int size, bool back, int window=0);
   void 		Draw_Arrow(string prefix, string name, string dir, color colour, datetime x, double y, int size, bool back, int window=0);
   void 		Draw_PriceBox(string prefix, string name, bool left, int width, color colour, datetime x, double y, bool back, int window=0);
   
   // TIME UTILITIES----------------------------------------------------------------------------------------------------------------------------------------------------
	datetime Time.AddPeriod(datetime dt, int period, int inc);
	datetime Time.AddMinutes(datetime dt, int minutes);
	datetime Time.AddHours(datetime dt, int hours);
	datetime Time.AddDays(datetime dt, int days);
	datetime Time.Add(datetime dt, int inc);

	string 	MDYHMSToStr(int nYear,int nMonth,int nDay,int nHour,int nMin,int nSec);
	string 	DateTimeToStr(datetime dt); 
	string	DateTimeToFormatStr(datetime dt, string format);	
	string 	TimeFrameToString(int tf);
	string 	TimeFrameUnit(int tf);
	int 		StringToTimeFrame(string tf);	
	int 		Time.Encompassing(string tf);
	string	Time.DOW(int d);
	
	// STRING UTILITIES-------------------------------------------------------------------------------------------------------------------------------------------------
	string 	StringRepeat(string str, int n);
	string 	StringUpperCase(string str);
	string 	StringLeftPad(string str, int n, string str2);
	string 	StringRightPad(string str, int n, string str2);
	string 	StringLeft(string str, int n);
	string 	StringRight(string str, int n);
	int 		SplitStringToArray(string& array[], string source);
	string 	StringFill(string filled, int f );	
	string 	StringRightAlign( string rString, int ra );
	string 	MakeUniqueName(string prefix, string rest);

	// REVERSAL UTILITIES-----------------------------------------------------------------------------------------------------------------------------------------------
	color		Rev.GetColor(color defaultColor, bool SetIfMissing);
	color		Rev.SetColor(color RatColor);
	bool 		Rev.ColorChanged(color PreviousColor);
	int 		Rev.Status(string myPair, int TimeFrame, double Threshold, bool ShortTrader, bool LongTrader );
	
#import
///\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\


*/

#define version "Will VERSION -2"


#property copyright "Will Black"
#property link      "email"
#property library

//=====================================================================================================================================================================
//=====================================================================================================================================================================
//=====================================================================================================================================================================
// GENERAL UTILITIES

	string	SNSLibrary.Version(){ return(version); }


	void SNSTAG(){
	
		Draw_Label("SNS", "TAG", "sns", 2, 1, 1, "Tahoma", 12, MediumOrchid, false, 0);
	
	}

	void DeleteObjectsByPrefix(string Prefix) {

   	int L = StringLen(Prefix);
   	int i = 0; 
   	while(i < ObjectsTotal()) {
   
       	string ObjName = ObjectName(i);
       	if(StringSubstr(ObjName, 0, L) != Prefix) { 	i++; 	continue;  }
         
       	ObjectDelete(ObjName);
       
     	}
     
	}

	bool   IsMini()         { return(StringFind(Symbol(),"m")  > -1); }

	bool   IsDoubleDotted() { return(StringFind(Symbol(),"..") > -1); }

	bool   IsDotted()       { return(StringFind(Symbol(),".")  > -1); }
	

//=====================================================================================================================================================================
//=====================================================================================================================================================================
//=====================================================================================================================================================================

// GRAPHIC OBJECT UTILITIES

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Draw a HORIZONTAL LINE at the provided DATETIME COLUMN
	
	void Draw_HLine(string prefix, string name, int style, int width, color clr, datetime x, double y, bool back, int window=0){

  		name = prefix+name;	
  		if (ObjectFind(name)<0) ObjectCreate (name,OBJ_HLINE, window, x, y); else if (x!=0) ObjectMove(name,window, x,y );
  		ObjectSet(name, OBJPROP_STYLE, style);
  		ObjectSet(name, OBJPROP_BACK, back);
  		ObjectSet(name, OBJPROP_WIDTH, width);
  		ObjectSet(name, OBJPROP_COLOR,clr );

  
	}

	void Draw_VLine(string prefix, string name, int style, int width, color clr, datetime x, bool back, int window=0){

  		name = prefix+name;	
  		if (ObjectFind(name)<0) ObjectCreate (name,OBJ_VLINE, window, x, 0); else if (x!=0) ObjectMove(name,window, x,0 );
  		ObjectSet(name, OBJPROP_STYLE, style);
  		ObjectSet(name, OBJPROP_BACK, back);
  		ObjectSet(name, OBJPROP_WIDTH, width);
  		ObjectSet(name, OBJPROP_COLOR, clr );

	}

	void Draw_TLine(string prefix, string name, int style, int width, color clr, datetime x1, double y1, datetime x2, double y2, bool ray, bool back, int window=0){

  		name = prefix+name;	
  		if (ObjectFind(name)<0) ObjectCreate (name,OBJ_TREND, window, x1, y1, x2, y2); else {
   
   			if (x1!=0 && x2!=0) {
   			
      			ObjectMove(name,0,x1,y1);
      			ObjectMove(name,1,x2,y2);
      			
      		}
      
  		}
  		
  		ObjectSet(name, OBJPROP_STYLE, style);
  		ObjectSet(name, OBJPROP_BACK, back);
  		ObjectSet(name, OBJPROP_WIDTH, width);
  		ObjectSet(name, OBJPROP_COLOR, clr );
  		ObjectSet(name, OBJPROP_RAY, ray);
  
	}
	
	

	void Draw_LabeledLine(string prefix, string name, int style, int width, color clr, datetime x1, double y1, datetime x2, double y2, bool ray, 
								 string label, string font, int fontsize, color fontcolor, datetime labelx, double labely, int window=0){

		Draw_TLine(prefix, name, style, width, clr, x1, y1, x2, y2, ray, true, window);
	   Draw_Text(prefix, name+".label", label, labelx, y1+labely, font, fontsize, fontcolor, false, window);
  
	}
	

	void Draw_Box(string prefix, string name, color boxcolor, datetime x1, double y1, datetime x2, double y2, bool back,int linewidth,int linestyle, int window=0){

   	name = prefix+name;	
   	if (ObjectFind(name)<0) ObjectCreate(name, OBJ_RECTANGLE,window, x1,y1, x2,y2); else {
   
   			if (x1!=0 && x2!=0) {
   			
      			ObjectMove(name,0,x1,y1);
      			ObjectMove(name,1,x2,y2);
      			
      		}
            
   	}
   
   	ObjectSet(name, OBJPROP_COLOR, boxcolor);
   	ObjectSet(name,OBJPROP_BACK,back);
   	ObjectSet(name,OBJPROP_WIDTH,linewidth);
   	ObjectSet(name,OBJPROP_STYLE,linestyle);

	}

	void Draw_Fibo(string prefix, string name, int style, int width, color fibcolor, int levelstyle, int levelwidth, color levelcolor,  datetime x1, double y1, datetime x2, double y2, bool ray, bool back, int window=0){

		name = prefix+name;	
   	if (ObjectFind(name)<0) ObjectCreate(name, OBJ_FIBO,window, x1,y1, x2,y2); else {
   
   			if (x1!=0 && x2!=0) {
   			
      			ObjectMove(name,0,x1,y1);
      			ObjectMove(name,1,x2,y2);
      			
      		}
            
   	}
   

   	ObjectSet(name, OBJPROP_LEVELWIDTH, width);
   	ObjectSet(name, OBJPROP_STYLE, style);
   	ObjectSet(name, OBJPROP_WIDTH, width);
   	ObjectSet(name, OBJPROP_COLOR, fibcolor);
   	ObjectSet(name, OBJPROP_LEVELSTYLE, levelstyle);
   	ObjectSet(name, OBJPROP_LEVELWIDTH, levelwidth);
   	ObjectSet(name, OBJPROP_LEVELCOLOR, levelcolor);
   	
   	ObjectSet(name, OBJPROP_RAY, ray);
	  	ObjectSet(name, OBJPROP_BACK,back);
   	
   	ObjectSet(name, OBJPROP_FIBOLEVELS, 6);
      //0.236, 0.382, 0.500, 0.618, 0.764
      ObjectSet(name,OBJPROP_FIRSTLEVEL+0,0.236);
      ObjectSetFiboDescription(name,0,"");
      ObjectSet(name,OBJPROP_FIRSTLEVEL+1,0.382);
      ObjectSetFiboDescription(name,1,"");
      ObjectSet(name,OBJPROP_FIRSTLEVEL+2,0.500);
      ObjectSetFiboDescription(name,2,"50%");
      ObjectSet(name,OBJPROP_FIRSTLEVEL+3,0.618);
      ObjectSetFiboDescription(name,3,"");
      ObjectSet(name,OBJPROP_FIRSTLEVEL+4,0.764);
      ObjectSetFiboDescription(name,4,"");
      ObjectSet(name,OBJPROP_FIRSTLEVEL+5,1.0);
      ObjectSetFiboDescription(name,5,"100%");
      
   	ObjectSet(name,OBJPROP_BACK,back);

	}


	void Draw_FiboChannel(string prefix, string name, int style, int width, color fibcolor, int levelstyle, int levelwidth, color levelcolor,  datetime x1, double y1, datetime x2, double y2, datetime x3, double y3, bool ray, bool back, int window=0){

		int x,i;
		name = prefix+name;	
   	if (ObjectFind(name)<0) ObjectCreate(name, OBJ_FIBOCHANNEL, window, x1,y1, x2,y2, x3,y3); else {
   
   			if (x1!=0 && x2!=0 && x3!=0) {
   			
      			ObjectMove(name,0,x1,y1);
      			ObjectMove(name,1,x2,y2);
      			ObjectMove(name,2,x3,y3);
      			
      		}
            
   	}
   
   	ObjectSet(name, OBJPROP_LEVELWIDTH, width);
   	ObjectSet(name, OBJPROP_STYLE, style);
   	ObjectSet(name, OBJPROP_WIDTH, width);
   	ObjectSet(name, OBJPROP_COLOR, fibcolor);
   	ObjectSet(name, OBJPROP_LEVELSTYLE, levelstyle);
   	ObjectSet(name, OBJPROP_LEVELWIDTH, levelwidth);
   	ObjectSet(name, OBJPROP_LEVELCOLOR, levelcolor);
   	
   	
   	
   	ObjectSet(name, OBJPROP_RAY, ray);
	  	ObjectSet(name, OBJPROP_BACK,back);
   	
   	ObjectSet(name, OBJPROP_FIBOLEVELS, 23);
      
      x=OBJPROP_FIRSTLEVEL; i=0;
      ObjectSet(name,x,0.236);	ObjectSetFiboDescription(name,i,"23.6%");  i++; x=OBJPROP_FIRSTLEVEL+i;   
      ObjectSet(name,x,0.382);	ObjectSetFiboDescription(name,i,"38.2%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,0.500);	ObjectSetFiboDescription(name,i,"50%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,0.618);	ObjectSetFiboDescription(name,i,"61.8%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,0.764);	ObjectSetFiboDescription(name,i,"76.4%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,1.0);		ObjectSetFiboDescription(name,i,"100%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,1.236);	ObjectSetFiboDescription(name,i,"123.6%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,1.382);	ObjectSetFiboDescription(name,i,"138.2%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,1.618);	ObjectSetFiboDescription(name,i,"150.0%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,1.618);	ObjectSetFiboDescription(name,i,"161.8%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,1.764);	ObjectSetFiboDescription(name,i,"176.4%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	

      ObjectSet(name,x,0);			ObjectSetFiboDescription(name,i,"0"); 		 i++; x=OBJPROP_FIRSTLEVEL+i; 	
      
      ObjectSet(name,x,-0.236); 	ObjectSetFiboDescription(name,i,"-23.6%"); i++; x=OBJPROP_FIRSTLEVEL+i;  
      ObjectSet(name,x,-0.382);	ObjectSetFiboDescription(name,i,"-38.2%"); i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-0.500);	ObjectSetFiboDescription(name,i,"-50%"); i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-0.618);	ObjectSetFiboDescription(name,i,"-61.8%"); i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-0.764);	ObjectSetFiboDescription(name,i,"-76.4%"); i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-1.0);		ObjectSetFiboDescription(name,i,"-100%"); i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-1.236);	ObjectSetFiboDescription(name,i,"-123.6%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-1.382);	ObjectSetFiboDescription(name,i,"-138.2%"); i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-1.500);	ObjectSetFiboDescription(name,i,"-150.0%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-1.618);	ObjectSetFiboDescription(name,i,"-161.8%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
      ObjectSet(name,x,-1.764);	ObjectSetFiboDescription(name,i,"-176.4%");  i++; x=OBJPROP_FIRSTLEVEL+i; 	
               


	}


	void Draw_Text(string prefix, string name, string text, datetime x, double y, string font, int fontsize, color fontcolor, bool back, int window=0){

  		name = prefix+name;	
  		if (ObjectFind(name)<0) ObjectCreate(name, OBJ_TEXT, window, x,y); else if (x!=0) ObjectMove(name,0, x,y );
  		ObjectSet(name,OBJPROP_BACK, back); 
  		ObjectSetText(name, text , fontsize, font, fontcolor);

	}

	void Draw_VText(string prefix, string name, string text, datetime x, double y, string font, int fontsize, color fontcolor, bool back, int window=0){

  		name = prefix+name;	
  		if (ObjectFind(name)<0) ObjectCreate(name, OBJ_TEXT, window, x,y); else if (x!=0) ObjectMove(name,0, x,y );
  		ObjectSet(name,OBJPROP_BACK, back); 
  		ObjectSet(name,OBJPROP_ANGLE,90);
  		ObjectSetText(name, text , fontsize, font, fontcolor);

	}

	void Draw_HighLightedText(string prefix, string name, string text, datetime x, double y, string font, int fontsize, color fontcolor, color highcolor, int w, double h, int window=0){

		Draw_Box(prefix, name+"hl", highcolor, x, y, Time.Add(y,w), y+h, true,1, 0);
		Draw_Text(prefix, name, text, x, y, font, fontsize, fontcolor, false, window);

	}



	void Draw_Label(string prefix, string name, string text, int corner, int x, int y, string font, int fontsize, color fontcolor, bool back, int window=0){

  		name = prefix+name;	
  		if (ObjectFind(name)<0) ObjectCreate(name, OBJ_LABEL, window, 0, 0); 
  		ObjectSetText(name, text, fontsize, font, fontcolor );
  		ObjectSet(name, OBJPROP_CORNER, corner);
  		ObjectSet(name, OBJPROP_BACK, back);
  		ObjectSet(name, OBJPROP_XDISTANCE, x);
  		ObjectSet(name, OBJPROP_YDISTANCE, y);
  
	}

	void Draw_Symbol(string prefix, string name, int code, color colour, datetime x, double y, int size, bool back, int window=0){

   	name = prefix+name;	
   	if (ObjectFind(name)<0) ObjectCreate(name,OBJ_ARROW,window,x,y); else ObjectMove(name,0, x,y );

   	ObjectSet(name,OBJPROP_ARROWCODE,code);
   	ObjectSet(name,OBJPROP_COLOR,colour);
   	ObjectSet(name,OBJPROP_WIDTH,size);
   
	}

	void Draw_PriceBox(string prefix, string name, bool left, int width, color colour, datetime x, double y, bool back, int window=0){

	 	int side;
	 	if (left) side=SYMBOL_LEFTPRICE; else side=SYMBOL_RIGHTPRICE;
	  
    	name = prefix+name;	
    	if (ObjectFind(name)<0) ObjectCreate(name,OBJ_ARROW,window,x,y); else {
   
      	ObjectMove(name,window,x,y);
      
    	}
    	ObjectSet(name,OBJPROP_ARROWCODE,side);
    	ObjectSet(name,OBJPROP_COLOR,colour);  
    	ObjectSet(name,OBJPROP_WIDTH,width);
   
	}


	int GetArrow(string dir){

   	if(dir== "NEUTRAL")     return(234);
   	if(dir=="UP")           return(233);
   	if(dir=="UPLEFT")       return(0);
   	if(dir=="UPRIGHT")      return(0);

   	if(dir=="DOWN")         return(159);
   	if(dir=="DOWNLEFT")     return(0);
   	if(dir=="DOWNRIGHT")    return(0);

   	if(dir=="RIGHT")        return(0);
   	if(dir=="LEFT")         return(0);

   	return(234);
	}

	void Draw_Arrow(string prefix, string name, string dir, color colour, datetime x, double y, int size, bool back, int window=0){ 

    	Draw_Symbol(prefix, name, GetArrow(dir), colour, window, x, y, size, back );

	}


//=====================================================================================================================================================================
//=====================================================================================================================================================================
//=====================================================================================================================================================================

// DATE AND TIME UTILITIES

	string months[13]={"","JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"};



	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Add a given number of specific periods to a date/time
	
	datetime Time.AddPeriod(datetime dt, int period, int increment) {

		return (dt+(D'1970.01.01 00:01:00'*(increment*period)));
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Add a given number of MINUTES to a date/time
	
	datetime Time.AddMinutes(datetime dt, int minutes) {

		return (Time.AddPeriod(dt, PERIOD_M1, minutes));
	
	}

	//---------------------------------------------------------------------------------------------------------------
	// Add a given number of HOURS to a date/time

	datetime Time.AddHours(datetime dt, int hours) {

		return (Time.AddPeriod(dt, PERIOD_H1, hours));
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Function to add a given number of DAYS to a date/time

	datetime Time.AddDays(datetime dt, int days) {

		return (Time.AddPeriod(dt, PERIOD_H1, days));
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Convenience function to add a given number of [current period]'s to a date/time

	datetime Time.Add(datetime dt, int increment) {

		return (Time.AddPeriod(dt, Period(), increment));
	
	}


	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string MDYHMSToStr(int nYear,int nMonth,int nDay,int nHour,int nMin,int nSec) {

   	string sMonth,sDay,sHour,sMin,sSec;

   	sMonth=100+nMonth;
   	sMonth=StringSubstr(sMonth,1);
   	sDay=100+nDay;
   	sDay=StringSubstr(sDay,1);
   	sHour=100+nHour;
   	sHour=StringSubstr(sHour,1);
   	sMin=100+nMin;
   	sMin=StringSubstr(sMin,1);
   	sSec=100+nSec;
   	sSec=StringSubstr(sSec,1);

   	return(StringConcatenate(nYear,".",sMonth,".",sDay," ",sHour,":",sMin,":",sSec));
   
	}


	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string DateTimeToStr(datetime dt) {

		return( MDYHMSToStr(TimeYear(dt),TimeMonth(dt),TimeDay(dt),TimeHour(dt),TimeMinute(dt),TimeSeconds(dt) ) );

	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// NOTE THIS IS NOT WORKING FULLY CORRECTLY YET
	// example "DOM ;MON ;HHH:;MMM "
	// DOM - DAY OF MONTH (1-31)
	// DOW - DAY OF WEEK (MON-SUN)
	// MON - MONTH (JAN-DEC)
	// HHH  - HOUR (00-23)
	// MMM  - MINUTE (00-59)
	// YYY  - YEAR (last 2 digits)

	string DateTimeToFormatStr(datetime dt, string format) {
	string element[],dstr="unk",e,sep,hr,m;

		int elements = SplitStringToArray(element,format);
		
		for(int i=0; i<elements; i++) {
		
			e=element[i];
			Comment("element[0]='" + element[0] + "'  element[1]='" + element[1]+"'");
			if(StringLen(e)>3) sep=StringSubstr(e,3); else sep="";
			e=StringSubstr(e,0,3);
			hr=""+TimeHour(dt); if(StringLen(hr)<2) hr="0"+hr;
			m=""+TimeMinute(dt); if(StringLen(m)<2) m="0"+m;
			if (e=="DOM") { dstr=dstr+TimeDay(dt)+sep; continue;				}
			if (e=="MON") { dstr=dstr+months[TimeMonth(dt)]+sep; continue;	}
			if (e=="HHH") { dstr=dstr+hr+sep; continue;							}
			if (e=="MMM") { dstr=dstr+m+sep; continue;							}
		
		}
		
		return( dstr );

	}	
	


	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string TimeFrameToString(int tf){

   	string tfs;
   	switch(tf) {
   
      	case PERIOD_M1:  tfs="M1"  ; break;
      	case PERIOD_M5:  tfs="M5"  ; break;
      	case PERIOD_M15: tfs="M15" ; break;
      	case PERIOD_M30: tfs="M30" ; break;
      	case PERIOD_H1:  tfs="H1"  ; break;
      	case PERIOD_H4:  tfs="H4"  ; break;
      	case PERIOD_D1:  tfs="D1"  ; break;
      	case PERIOD_W1:  tfs="W1"  ; break;
      	case PERIOD_MN1: tfs="MN";
      
   	}
   
   	return(tfs);
   
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string TimeFrameUnit(int tf){

   	string tfs;
   	switch(tf) {
   
      	case PERIOD_M1:  tfs="Minute"  ; break;
      	case PERIOD_M5:  tfs="5-Minute"  ; break;
      	case PERIOD_M15: tfs="15-Minute" ; break;
      	case PERIOD_M30: tfs="30-Minute" ; break;
      	case PERIOD_H1:  tfs="Hour"  ; break;
      	case PERIOD_H4:  tfs="4-Hour"  ; break;
      	case PERIOD_D1:  tfs="Day"  ; break;
      	case PERIOD_W1:  tfs="Week"  ; break;
      	case PERIOD_MN1: tfs="Month";
      
   	}
   
   	return(tfs);
   
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	int StringToTimeFrame(string tf){

		tf= StringTrimLeft(StringTrimRight(StringUpperCase(tf)));
		
   	if (tf=="M1"  || tf=="1") 						return(PERIOD_M1); 	else
   	if (tf=="M5"  || tf=="5")						return(PERIOD_M5); 	else
   	if (tf=="M15" || tf=="15")						return(PERIOD_M15);	else
   	if (tf=="M30" || tf=="30")						return(PERIOD_M30);  else
   	if (tf=="H1"  || tf=="H" || tf=="60") 		return(PERIOD_H1);   else
   	if (tf=="H4"  || tf=="4" || tf=="240") 	return(PERIOD_H4);   else
   	if (tf=="D1"  || tf=="D" || tf=="1440") 	return(PERIOD_D1);   else
   	if (tf=="W1"  || tf=="W" || tf=="10080") 	return(PERIOD_W1);   else
   	if (tf=="MN1" || tf=="M" || tf=="43200") 	return(PERIOD_MN1);
	
		return(0);
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Returns a "reasonable" time period that encompasses the given time period
	
	int Time.Encompassing(string tf){

		tf= StringTrimLeft(StringTrimRight(StringUpperCase(tf)));
		
   	if (tf=="M1"  || tf=="1") 						return(PERIOD_M15);	else
   	if (tf=="M5"  || tf=="5")						return(PERIOD_H1);  	else
   	if (tf=="M15" || tf=="15")						return(PERIOD_H1);	else
   	if (tf=="M30" || tf=="30")						return(PERIOD_D1);  	else
   	if (tf=="H1"  || tf=="H" || tf=="60") 		return(PERIOD_D1);   else
   	if (tf=="H4"  || tf=="4" || tf=="240") 	return(PERIOD_D1);   else
   	if (tf=="D1"  || tf=="D" || tf=="1440") 	return(PERIOD_W1);   else
   	if (tf=="W1"  || tf=="W" || tf=="10080") 	return(PERIOD_MN1);  else
	
		return(0);
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string	Time.DOW(int d) {
	
		switch(d) {
		
			case 0 : return("Sunday");
			case 1 : return("Monday");
			case 2 : return("Tuesday");
			case 3 : return("Wednesday");
			case 4 : return("Thursday");
			case 5 : return("Friday");
			case 6 : return("Saturday");
			
	   }
	
		return("Caturday :-)");
	
	}


//=====================================================================================================================================================================
//=====================================================================================================================================================================
//=====================================================================================================================================================================

// STRING UTILITIES

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Repeats the string STR N times
	// Usage:    string x=StringRepeat("-",10)  returns x = "----------"
	
	string StringRepeat(string str, int n){
	
  		string outstr = "";
  		for(int i=0; i<n; i++) outstr = outstr + str;
  		return(outstr);
  	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string StringUpperCase(string str){

   	string   s = str;
   	int      lenght = StringLen(str) - 1;
   	int      char;
   
   	while(lenght >= 0){
   
         	char = StringGetChar(s, lenght);

         	if((char > 96 && char < 123) || (char > 223 && char < 256)) 	s = StringSetChar(s, lenght, char - 32);
         	else 
         	if(char > -33 && char < 0)	s = StringSetChar(s, lenght, char + 224);
         	lenght--;
         
   	}
   
   	return(s);
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Prepends occurrences of the string STR2 to the string STR to make a string N characters long
	// Usage:    string x=StringLeftPad("ABCDEFG",9," ")  returns x = "  ABCDEFG"

	string StringLeftPad(string str, int n, string str2) {
	
  		return(StringRepeat(str2,n-StringLen(str)) + str);
  	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Appends occurrences of the string STR2 to the string STR to make a string N characters long
	// Usage:    string x=StringRightPad("ABCDEFG",9," ")  returns x = "ABCDEFG  "
	
	string StringRightPad(string str, int n, string str2)	{
	
  		return(str + StringRepeat(str2,n-StringLen(str)));
  	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// if N is positive - returns the leftmost N characters of STR 
	// Usage:    string x=StringRepeat("ABCDEFG",2)  returns x = "AB"
	//
	// if N is negative - returns all but the rightmost N characters of STR 
	// Usage:    string x=StringRepeat("ABCDEFG",-2)  returns x = "ABCDE"
	
	string StringLeft(string str, int n){
	
  		if (n > 0)  return(StringSubstr(str,0,n));
  		if (n < 0)  return(StringSubstr(str,0,StringLen(str)+n));
  		return("");
  		
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// if N is positive - eturns the rightmost N characters of STR
	// Usage:    string x=StringRepeat("ABCDEFG",2)  returns x = "FG"
	//
	// if N is negative - returns all but the leftmost N characters of STR
	// Usage:    string x=StringRepeat("ABCDEFG",-2)  returns x = "CDEFG"
	
	string StringRight(string str, int n){
	
  		if (n > 0)  return(StringSubstr(str,StringLen(str)-n,n));
  		if (n < 0)  return(StringSubstr(str,-n,StringLen(str)-n));
  		return("");
  	
	}

	
	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	int SplitStringToArray(string& array[],string source){

   	source = StringUpperCase(StringTrimLeft(StringTrimRight(source)));
   	if (StringSubstr(source,StringLen(source)-1,1) != ";")
                    	source = StringConcatenate(source,";");

   	int  s = 0;
   	int  i = StringFind(source,";",s);
   	string current;
      	while (i > 0)
      	{
         	current = StringSubstr(source,s,i-s);
         	ArrayResize(array,ArraySize(array)+1);
                     	array[ArraySize(array)-1] = current;
                     	s = i + 1;
                     	i = StringFind(source,";",s);
      	}
   	return(ArraySize(array));
	}
 

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string StringFill(string filled, int f ){ return(StringRightPad(filled,f," "));	}


	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	string StringRightAlign( string rString, int ra ){
 
 		string FILLED = StringLeftPad(rString,ra," ");
 		int sl = StringLen(FILLED) ;
		return(StringSubstr(FILLED, sl-ra+1  , ra)) ;
		
	} 


	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Generates a unique name for a chart object - use to make sure object does not already exist
	string MakeUniqueName(string prefix, string rest){
	
	  	string result = prefix+(MathRand()%1001)+rest;
   	while (WindowFind(result)> 0)  	result = prefix+(MathRand()%1001)+rest;
   	return(result);
   	
	}
	
	
//=====================================================================================================================================================================
//=====================================================================================================================================================================
//=====================================================================================================================================================================

// REVERSAL (RAT) UTILITIES	
 
	string revcolor = "REVCOLOR"; // colors:  RED for SHORT-ONLY TRADING, or GREEN for LONG-ONLY TRADING
	
	///-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Get the current GLOBAL "REVCOLOR", or set it to the passed in default color if it does not yet exist AND
	// the SetIfMissing flag is set to true - otherwise, return White as a "WTF?" error-type response
	color	Rev.GetColor(color defaultColor, bool SetIfMissing){
	
		if (GlobalVariableCheck(revcolor)) {
		
			 double rc=GlobalVariableGet(revcolor);
			 if (rc==1) return(Green); else if (rc==2) return(Red); else return(Yellow);
			 
		} else if (SetIfMissing) {
		
			Rev.SetColor(defaultColor);
			return(defaultColor);
			
		} else return(White);
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	//FORCE set the color for the GLOBAL "REVCOLOR"	variable
	color	Rev.SetColor(color RevColor){
	
		if (RevColor==Green) GlobalVariableSet(revcolor,1);
		if (RevColor==Red) GlobalVariableSet(revcolor,2);
	
	} 
	
	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// Check if GLOBAL color is different from whatever is set in this indicator (without modifying the GLOBAL value)
	bool Rev.ColorChanged(color PreviousColor) {
	
		return (Rev.GetColor(PreviousColor,false)==PreviousColor);
	
	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
	// REVERSAL STATUS
	// inputs:
	//				myPair 		= Currency pair being checked
	//				TimeFrame	= Chart Time Frame being checked
	//				Threshold	= How far price must have paced the trigger point to flag it as TRIGGERED
	//				ShortTrader	= Set to TRUE if you want to get back all SHORT signals, or FALSE to have them ignored (RED RAT)
	//				LongTrader	= Set to TRUE if you want to get back all LONG signals, or FALSE to have them ignored (GREEN RAT)
	//								  Setting both to TRUE means you get back ALL signals	
	// returns:
	//				0 = NOTHING TO SEE HERE, MOVE ALONG
	//				1 = SHORT TRADE SIGNAL HAS BEEN TRIGGED
	//				2 = LONG TRADE SIGNAL HAS BEEN TRIGGED
	//				3 = SHORT TRADE SETUP HAS FORMED - WAITING FOR TRIGGER
	//				4 = LONG TRADE SETUP HAS FORMED - WAITING FOR TRIGGER	
	
	int Rev.Status(string myPair, int TimeFrame, double Threshold, bool ShortTrader, bool LongTrader ){
	double C,O,H,L,O1,C1,H1,L1,O2,C2;

	bool PrevBarUp,Bar2Up,ThisBarUp;
		
      // CURRENT Candle OHLC
		C  = iClose(myPair,TimeFrame, 0); 
		O  = iOpen(myPair,TimeFrame, 0);          
		H  = iHigh(myPair,TimeFrame, 0);   
		L  = iLow(myPair,TimeFrame, 0);
		          
		// PREVIOUS Candle OHLC
		O1 = iOpen(myPair,TimeFrame, 1);           
		C1 = iClose(myPair,TimeFrame, 1);           
		H1 = iHigh(myPair,TimeFrame, 1);   
		L1 = iLow(myPair,TimeFrame, 1);
		    
		// TWO CANDLES BACK OPEN / CLOSE 
		O2 = iOpen(myPair,TimeFrame, 2);           
		C2 = iClose(myPair,TimeFrame, 2);

		ThisBarUp = C > O;   // is this a green-up bar or a red-down bar?
		PrevBarUp = C1 > O1; // was the previous candle an up or down bar?
		Bar2Up    = C2 > O2; // was the candle two bars ago an up or down bar? 

	
		if (C <= L1 && C >= L1 + Threshold && Bar2Up && !PrevBarUp  && ShortTrader  ) return(1); // Short Signal Triggered
		if (C >= H1 && C <= H1 + Threshold && LongTrader) 										return(2); // Long Signal Triggered
		if (Bar2Up && !PrevBarUp && ShortTrader ) 												return(3); // Short Setup in place - waiting for trigger
		if (!Bar2Up && PrevBarUp && LongTrader) 													return(4); // Long Setup in place - waiting for trigger    

		return(0);
   
	}
