//+------------------------------------------------------------------+
//|                                                  StdDivBands.mq4 |
//|                 Copyright  2006, Ronald Verwer @ Forex MetaSoft |
//|                                     http://www.forexmetasoft.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Ronald Verwer @ Forex MetaSoft"
#property link      "http://www.forexmetasoft.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Magenta
#property indicator_color2 Magenta
#property indicator_width1 2
#property indicator_width2 2

extern int    StdDivPeriod          =  20;
extern double StdDeviation          = 2.0;
extern int    Shift                 =   0;
extern int    Applied_Price         =   5;

double MiddleBuffer[];
double UpperBand[];
double LowerBand[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
   {
   IndicatorBuffers(3);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,UpperBand);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,LowerBand);
   SetIndexBuffer(2,MiddleBuffer);

   SetIndexDrawBegin(0,StdDivPeriod+Shift);
   SetIndexDrawBegin(1,StdDivPeriod+Shift);
   SetIndexDrawBegin(2,StdDivPeriod+Shift);

   return(0);
   }

//+------------------------------------------------------------------+
//| Standard Deviation Bands                                         |
//+------------------------------------------------------------------+

int start()
   {
   int    i,k,counted_bars=IndicatorCounted();
   double deviation;
   double sum,oldval,newres;

   if(Bars<=StdDivPeriod) return(0);

   if(counted_bars<1)
      for(i=1;i<=StdDivPeriod;i++)
         {
         MiddleBuffer[Bars-i]=EMPTY_VALUE;
         UpperBand[Bars-i]=EMPTY_VALUE;
         LowerBand[Bars-i]=EMPTY_VALUE;
         }

   int limit=Bars-counted_bars;
   if(counted_bars>0) limit++;
   for(i=0; i<limit; i++)
      MiddleBuffer[i]=iMA(NULL,0,StdDivPeriod,Shift,MODE_SMA,Applied_Price,i);

   i=Bars-StdDivPeriod+1;
   if(counted_bars>StdDivPeriod-1) i=Bars-counted_bars-1;
   while(i>=0)
      {
      sum=0.0;
      k=i+StdDivPeriod-1;
      oldval=MiddleBuffer[i];
      while(k>=i)
         {
         newres=Close[k]-oldval;
         sum+=newres*newres;
         k--;
         }
      deviation=StdDeviation*MathSqrt(sum/StdDivPeriod);
      UpperBand[i]=oldval+deviation;
      LowerBand[i]=oldval-deviation;
      i--;
      }

   return(0);
   }

//+------------------------------------------------------------------+