//+------------------------------------------------------------------+
//|                                                 StepChart_v1.mq4 |
//|                                Copyright  2010, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 SkyBlue
#property indicator_color2 OrangeRed
#property indicator_width1 3
#property indicator_width2 3
//---- input parameters
extern int     Price       =     0; //Applied Price: 0-C,1-O,2-H,3-L,4-Median,5-Typical,6-Weighted
extern int     StepSize    =    20; //Size in pips 
//---- indicator buffers
double UpBuffer[];
double DnBuffer[];
double sPrice[];
double trend[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   string short_name;
//---- indicator line
   IndicatorBuffers(4);
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
   SetIndexBuffer(2,sPrice);
   SetIndexBuffer(3,trend);
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   
//---- name for DataWindow and indicator subwindow label
   short_name="StepChart("+Price+","+StepSize+")";
   IndicatorShortName(short_name);
//----
   SetIndexDrawBegin(0,2);
   SetIndexDrawBegin(1,2);
   
//----
   return(0);
}

//+------------------------------------------------------------------+
//| StepChart_v1                                                     |
//+------------------------------------------------------------------+
int start()
{
   
   int shift,limit, counted_bars=IndicatorCounted();
   double _Point = Point * MathPow(10,Digits%2);
   
   if ( counted_bars > 0 )  limit=Bars-counted_bars-1;
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-1; 
     
	
	if (counted_bars < 1)
   { 
      for(int i=0;i<Bars-1;i++)
      { 
      UpBuffer[i]=EMPTY_VALUE;
      DnBuffer[i]=EMPTY_VALUE;
      }
   }   
	
   
	for(shift=limit;shift>=0;shift--) 
   {	
   double Step = StepSize * _Point;
   double price = iMA(NULL,0,1,0,0,Price,shift);
   
      if(shift < Bars-1)
      {
      sPrice[shift] = sPrice[shift+1];   
         if(MathAbs(price - sPrice[shift]) < Step) sPrice[shift] = sPrice[shift+1]; 
         else
         { 
            while(MathAbs(price - sPrice[shift]) > Step) 
            {
    	      if(price > sPrice[shift]) sPrice[shift] = sPrice[shift] + Step;
		      if(price < sPrice[shift]) sPrice[shift] = sPrice[shift] - Step;
		      }
		   }    
	     
         trend[shift] = trend[shift+1];
         if(sPrice[shift] > sPrice[shift+1]) trend[shift] = 1;
         if(sPrice[shift] < sPrice[shift+1]) trend[shift] =-1;   
         
         if(trend[shift] > 0)   
         {
         UpBuffer[shift] = sPrice[shift];
            if(sPrice[shift] == sPrice[shift+1]) DnBuffer[shift] = sPrice[shift] - Point;  
            else DnBuffer[shift] = sPrice[shift+1];
         }
         else
         if(trend[shift] < 0)   
         {
         UpBuffer[shift] = sPrice[shift]; 
            if(sPrice[shift] == sPrice[shift+1]) DnBuffer[shift] = sPrice[shift+1] + Point;  
            else DnBuffer[shift] = sPrice[shift+1];
         }
      }
      else
      { 
      sPrice[shift] = MathRound(price/(StepSize * _Point)) * StepSize * _Point;         
      trend[shift] = 0;
      }
   }      
   
   return(0);	
}



