//+------------------------------------------------------------------+
//|                                        Custom Moving Average.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 Red
#property indicator_color2 Red
#property indicator_color3 Red
#property indicator_color4 Red
#property indicator_color5 Red
#property indicator_color6 Red
#property indicator_color7 Red
#property indicator_color8 Red
//---- indicator parameters
extern int Stoch_D=12;
extern int Stoch_K=8;
extern int Stoch_S=5;
extern double Koef=1.2;
//---- indicator buffers
double Buf0[],Buf1[],Buf2[],Buf3[],Buf4[],Buf5[],Buf6[],Buf7[];
double D10,D11,D12,D13,D14,D15,D16,D17;
double K10,K11,K12,K13,K14,K15,K16,K17;
double S10,S11,S12,S13,S14,S15,S16,S17;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorDigits(0);
   string short_name="Stochastic X8";
//---- indicator short name
   IndicatorShortName(short_name+"*"+DoubleToStr(Koef,1)+" ("+Stoch_D+", "+Stoch_K+", "+Stoch_S+")");

   D10=Stoch_D;D11=D10*Koef;D12=D11*Koef;D13=D12*Koef;D14=D13*Koef;D15=D14*Koef;D16=D15*Koef;D17=D16*Koef;
   K10=Stoch_K;K11=K10*Koef;K12=K11*Koef;K13=K12*Koef;K14=K13*Koef;K15=K14*Koef;K16=K15*Koef;K17=K16*Koef;
   S10=Stoch_S;S11=S10*Koef;S12=S11*Koef;S13=S12*Koef;S14=S13*Koef;S15=S14*Koef;S16=S15*Koef;S17=S16*Koef;
   
   SetIndexBuffer(0,Buf0);
   SetIndexLabel (0,"Stoch ("+Ds_0(D10)+", "+Ds_0(K10)+", "+Ds_0(S10)+")\n");
   SetIndexBuffer(1,Buf1);
   SetIndexLabel (1,"Stoch ("+Ds_0(D11)+", "+Ds_0(K11)+", "+Ds_0(S11)+")\n");
   SetIndexBuffer(2,Buf2);
   SetIndexLabel (2,"Stoch ("+Ds_0(D12)+", "+Ds_0(K12)+", "+Ds_0(S12)+")\n");
   SetIndexBuffer(3,Buf3);
   SetIndexLabel (3,"Stoch ("+Ds_0(D13)+", "+Ds_0(K13)+", "+Ds_0(S13)+")\n");
   SetIndexBuffer(4,Buf4);
   SetIndexLabel (4,"Stoch ("+Ds_0(D14)+", "+Ds_0(K14)+", "+Ds_0(S14)+")\n");
   SetIndexBuffer(5,Buf5);
   SetIndexLabel (5,"Stoch ("+Ds_0(D15)+", "+Ds_0(K15)+", "+Ds_0(S15)+")\n");
   SetIndexBuffer(6,Buf6);
   SetIndexLabel (6,"Stoch ("+Ds_0(D16)+", "+Ds_0(K16)+", "+Ds_0(S16)+")\n");
   SetIndexBuffer(7,Buf7);
   SetIndexLabel (7,"Stoch ("+Ds_0(D17)+", "+Ds_0(K17)+", "+Ds_0(S17)+")\n");
   
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   if(Bars<=Stoch_D) return(0);
   int ExtCountedBars=IndicatorCounted();
//---- check for possible errors
   if (ExtCountedBars<0) return(-1);
//---- last counted bar will be recounted
   if (ExtCountedBars>0) ExtCountedBars--;
//----
   for(int i=0;i<Bars-Stoch_D;i++)
      {
       Buf0[i] = iStochastic(NULL,0,D10,K10,S10,3,1,0,i);
       Buf1[i] = iStochastic(NULL,0,D11,K11,S11,3,1,0,i);
       Buf2[i] = iStochastic(NULL,0,D12,K12,S12,3,1,0,i);
       Buf3[i] = iStochastic(NULL,0,D13,K13,S13,3,1,0,i);
       Buf4[i] = iStochastic(NULL,0,D14,K14,S14,3,1,0,i);
       Buf5[i] = iStochastic(NULL,0,D15,K15,S15,3,1,0,i);
       Buf6[i] = iStochastic(NULL,0,D16,K16,S16,3,1,0,i);
       Buf7[i] = iStochastic(NULL,0,D17,K17,S17,3,1,0,i);
      
      }
   return(0);
  }
//+------------------------------------------------------------------+
string Ds_0(double DOUBLE) {return(DoubleToStr(DOUBLE,0));}
//+------------------------------------------------------------------+

