//+------------------------------------------------------------------+
//|                                            MM-TimeFrame 2007.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "Xard777" 
#property link      "http://www.metaquotes.net"
#property link      "Xard777@connectfree.co.uk"

#property indicator_chart_window
extern color MMColor = C'0,6,60';
extern color MM2Color = C'100,5,60';
extern int P = 64;
extern int StepBack = 0;

#define FF1 "FF1"
#define FF2 "FF2"
#define FF3 "FF3"
#define YC "YC"

double  dmml = 0,
        dvtl = 0,
        sum  = 0,
        v1 = 0,
        v2 = 0,
        mn = 0,
        mx = 0,
        x1 = 0,
        x2 = 0,
        x3 = 0,
        x4 = 0,
        x5 = 0,
        x6 = 0,
        y1 = 0,
        y2 = 0,
        y3 = 0,
        y4 = 0,
        y5 = 0,
        y6 = 0,
        octave = 0,
        fractal = 0,
        range   = 0,
        finalH  = 0,
        finalL  = 0,
        mml[13];
        
string  ln_txt[13],        
        buff_str = "";
        
int     
        bn_v1   = 0,
        bn_v2   = 0,
        OctLinesCnt = 13,
        mml_thk = 8,
        mml_clr[13],
        mml_shft = 3,
        nTime = 0,
        CurPeriod = 0,
        nDigits = 0,
        i = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
IndicatorShortName("MM");
//---- indicators
   ln_txt[0]  = "[-2/8]                                           ";
   ln_txt[1]  = "[-1/8]                                           ";
   ln_txt[2]  = "[0/8]                                           ";
   ln_txt[3]  = "[1/8]                                           ";
   ln_txt[4]  = "[2/8]                                           ";
   ln_txt[5]  = "[3/8]                                           ";
   ln_txt[6]  = "[4/8]                                           ";
   ln_txt[7]  = "[5/8]                                           ";
   ln_txt[8]  = "[6/8]                                           ";
   ln_txt[9]  = "[7/8]                                           ";
   ln_txt[10] = "[8/8]                                           ";
   ln_txt[11] = "[+1/8]                                           ";
   ln_txt[12] = "[+2/8]                                           ";

   mml_shft = 3;//original was 3
   mml_thk  = 3;
   
   mml_clr[0]  = Red;
   mml_clr[1]  = OrangeRed;
   mml_clr[2]  = DeepSkyBlue;
   mml_clr[3]  = Yellow;
   mml_clr[4]  = HotPink;
   mml_clr[5]  = Lime;
   mml_clr[6]  = DeepSkyBlue;
   mml_clr[7]  = Lime;
   mml_clr[8]  = HotPink;
   mml_clr[9]  = Yellow;
   mml_clr[10] = DeepSkyBlue;
   mml_clr[11] = OrangeRed;
   mml_clr[12] = Red;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit() {
//---- TODO: add your code here
Comment("\n","  ");   
for(i=0;i<OctLinesCnt;i++) {
    buff_str = "mml"+i;
    ObjectDelete(buff_str);
    buff_str = "mml_txt"+i;
    ObjectDelete(buff_str);
    }
//----
 ObjectsDeleteAll(0,OBJ_TRENDBYANGLE);
  ObjectsDeleteAll(0,OBJ_RECTANGLE);
  ObjectsDeleteAll(0,OBJ_TEXT); 
  ObjectsDeleteAll(0,OBJ_LABEL); 

//ObjectsDeleteAll();
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() 
{

//Outer Wine coloured Boxes   
CreateMM3();
}
void CreateObj3(string objName3, double start, double end, color clr)
  {
   ObjectCreate(objName3, OBJ_RECTANGLE, 0, iTime(NULL,CurPeriod,P), start, Time[0], end);
   ObjectSet(objName3, OBJPROP_COLOR, clr);
   }
   //ObjectsDeleteAll();
    
   ObjectDelete(FF1);
   ObjectDelete(FF2);
   ObjectDelete(FF3);
      
   void CreateMM3()
   {
   //DeleteObjects();
    ObjectsDeleteAll(0,OBJ_RECTANGLE);
   
   ObjectsRedraw();
//---- TODO: add your code here
    
// Start Data window code
double Value = finalH; //8/8th 
double Value1 = finalL; //0/8th
      
{
if( (nTime != Time[0]) || (CurPeriod != Period()) ) {
   
   v1=(Close[Lowest(NULL,0,MODE_CLOSE,P+StepBack,0)]);
   v2=(Close[Highest(NULL,0,MODE_CLOSE,P+StepBack,0)]);
}
//determine fractal.....
   if( v2<=250000 && v2>25000 )
   fractal=100000;
   else
     if( v2<=25000 && v2>2500 )
     fractal=10000;
     else
       if( v2<=2500 && v2>250 )
       fractal=1000;
       else
         if( v2<=250 && v2>25 )
         fractal=100;
         else
           if( v2<=25 && v2>2.5 )
           fractal=10;
           else
             if( v2<=2.5 && v2> 0.25 )
             fractal=1;  
             else
               if( v2<=0.25 && v2> 0.025 )
               fractal=0.1; 
              
   //---- input parameters ----
double m0,m8,m7,m6,m5,m4,m3,m2,m1;
double mm0,mm8,mm7,mm6,mm5,mm4,mm3,mm2,mm1,mm11,mm12,mm13,mm14;
double mm15,mm16,mm17,mm18;
double mm30,mm31,mm32,mm33,mm34,mm35,mm36,mm37,mm38,mm3P1,mm3P2,mm3M1,mm3M2;
double mm313, mm314, mm315, mm316;
double xard = iMA(Symbol(),0,1,0,MODE_EMA,PRICE_CLOSE,0);
double column1=8,octave1=64;//1st column
double column2=64,octave2=512;//2nd column
double column3=512,octave3=4096;//3rd column

//1st Octave column plus Algorithm
m0 = (MathFloor(xard/(fractal/column1))*(fractal/column1));
m8 = m0+((fractal/octave1)*8);
m7 = m0+((fractal/octave1)*7);
m6 = m0+((fractal/octave1)*6);
m5 = m0+((fractal/octave1)*5);
m4 = m0+((fractal/octave1)*4);
m3 = m0+((fractal/octave1)*3);
m2 = m0+((fractal/octave1)*2);
m1 = m0+((fractal/octave1)*1);

//2nd Octave column plus Algorithm
mm0 = (MathFloor(xard/(fractal/column2))*(fractal/column2));
mm8 = mm0+((fractal/octave2)*8);
mm7 = mm0+((fractal/octave2)*7);
mm6 = mm0+((fractal/octave2)*6);
mm5 = mm0+((fractal/octave2)*5);
mm4 = mm0+((fractal/octave2)*4);
mm3 = mm0+((fractal/octave2)*3);
mm2 = mm0+((fractal/octave2)*2);
mm1 = mm0+((fractal/octave2)*1);
mm11 =mm0-((fractal/octave2)*1);
mm12 =mm0-((fractal/octave2)*2);
mm13 =mm0+((fractal/octave2)*9);
mm14 =mm0+((fractal/octave2)*10);
mm15 =mm0+((fractal/octave2)*11);
mm16 =mm0+((fractal/octave2)*12);
mm17 =mm0-((fractal/octave2)*3);
mm18 =mm0-((fractal/octave2)*4);

//3rd Octave Column plus Algorithm
mm30 = (MathFloor(xard/(fractal/column3))*(fractal/column3));
mm31 = mm30+((fractal/octave3)*1);
mm32 = mm30+((fractal/octave3)*2);
mm33 = mm30+((fractal/octave3)*3);
mm34 = mm30+((fractal/octave3)*4);
mm35 = mm30+((fractal/octave3)*5);
mm36 = mm30+((fractal/octave3)*6);
mm37 = mm30+((fractal/octave3)*7);
mm38 = mm30+((fractal/octave3)*8);
mm3P1 = mm30+((fractal/octave3)*9);
mm3P2 = mm30+((fractal/octave3)*10);
mm3M1 = mm30-((fractal/octave3)*1);
mm3M2 = mm30-((fractal/octave3)*2);
mm313 = mm30+((fractal/octave3)*11);
mm314 = mm30+((fractal/octave3)*12);
mm315 = mm30-((fractal/octave3)*3);
mm316 = mm30-((fractal/octave3)*4);
    
// Calculating Our TimeFrame    
   range=(v2-v1);
   sum=MathFloor(MathLog(fractal/range)/MathLog(2));
   octave=fractal*(MathPow(0.5,sum));
   mn=MathFloor(v1/octave)*octave;
   if( (mn+octave)>v2 )
   mx=mn+octave; 
   else
     mx=mn+(2*octave);

// calculating xx
//x2
    if( (v1>=(3*(mx-mn)/16+mn)) && (v2<=(9*(mx-mn)/16+mn)) )
    x2=mn+(mx-mn)/2; 
    else x2=0;
//x1
    if( (v1>=(mn-(mx-mn)/8))&& (v2<=(5*(mx-mn)/8+mn)) && (x2==0) )
    x1=mn+(mx-mn)/2; 
    else x1=0;

//x4
    if( (v1>=(mn+7*(mx-mn)/16))&& (v2<=(13*(mx-mn)/16+mn)) )
    x4=mn+3*(mx-mn)/4; 
    else x4=0;

//x5
    if( (v1>=(mn+3*(mx-mn)/8))&& (v2<=(9*(mx-mn)/8+mn))&& (x4==0) )
    x5=mx; 
    else  x5=0;

//x3
    if( (v1>=(mn+(mx-mn)/8))&& (v2<=(7*(mx-mn)/8+mn))&& (x1==0) && (x2==0) && (x4==0) && (x5==0) )
    x3=mn+3*(mx-mn)/4; 
    else x3=0;

//x6
    if( (x1+x2+x3+x4+x5) ==0 )
    x6=mx; 
    else x6=0;

     finalH = x1+x2+x3+x4+x5+x6;
// calculating yy
//y1
    if( x1>0 )
    y1=mn; 
    else y1=0;

//y2
    if( x2>0 )
    y2=mn+(mx-mn)/4; 
    else y2=0;

//y3
    if( x3>0 )
    y3=mn+(mx-mn)/4; 
    else y3=0;

//y4
    if( x4>0 )
    y4=mn+(mx-mn)/2; 
    else y4=0;

//y5
    if( x5>0 )
    y5=mn+(mx-mn)/2; 
    else y5=0;

//y6
    if( (finalH>0) && ((y1+y2+y3+y4+y5)==0) )
    y6=mn; 
    else y6=0;

    finalL = y1+y2+y3+y4+y5+y6;

    for( i=0; i<OctLinesCnt; i++) {
         mml[i] = 0;
         }
         
   dmml = (finalH-finalL)/8;

   mml[0] =(finalL-dmml*2); //-2/8
   for( i=1; i<OctLinesCnt; i++) {
        mml[i] = mml[i-1] + dmml;
        }
   for( i=0; i<OctLinesCnt; i++ ){
        buff_str = "mml"+i;
        if(ObjectFind(buff_str) == -1) {
           ObjectCreate(buff_str, OBJ_TRENDBYANGLE, 0, Time[0], mml[i]);
           ObjectSet(buff_str, OBJPROP_STYLE, STYLE_SOLID);
           ObjectSet(buff_str, OBJPROP_COLOR, mml_clr[i]);
           ObjectSet(buff_str, OBJPROP_RAY, false);
           ObjectSet(buff_str, OBJPROP_WIDTH,2);
           ObjectMove(buff_str, 0, Time[0],  mml[i]);
           }
        else {
           ObjectMove(buff_str, 0, Time[0],  mml[i]);
           } 
        buff_str = "mml_txt"+i;
        if(ObjectFind(buff_str) == -1) {
           ObjectCreate(buff_str, OBJ_TEXT, 0, Time[mml_shft], mml_shft);
           ObjectSetText(buff_str, ln_txt[i], 9, "Verdana", mml_clr[i]);
           //ObjectSetText(buff_str, DoubleToStr(mml[i],Digits), 9, "Verdana", mml_clr[i]);
           ObjectMove(buff_str, 0, Time[mml_shft],  mml[i]);
           }
        else {
           ObjectMove(buff_str, 0, Time[mml_shft],  mml[i]);
           }
           buff_str = "mml2_txt"+i;
        if(ObjectFind(buff_str) == -1) {
           ObjectCreate(buff_str, OBJ_TEXT, 0, Time[mml_shft], mml_shft);
           //ObjectSetText(buff_str, ln_txt[i], 9, "Verdana", mml_clr[i]);
           ObjectSetText(buff_str, DoubleToStr(mml[i],Digits), 9, "Verdana", mml_clr[i]);
           ObjectMove(buff_str, 0, Time[mml_shft],  mml[i]);
           }
        else {
           ObjectMove(buff_str, 0, Time[mml_shft],  mml[i]);
           }
        } // for( i=1; i<=OctLinesCnt; i++ ){
//Comment("\n"," ");
   nTime    = Time[0];
   CurPeriod= Period();

//Baby Lines
double bm222,bm224,bm226;
double bm112,bm114,bm116;
double bm02,bm04,bm06;
double bm12,bm14,bm16;
double bm22,bm24,bm26;
double bm32,bm34,bm36;
double bm42,bm44,bm46;
double bm52,bm54,bm56;
double bm62,bm64,bm66;
double bm72,bm74,bm76;
double bm82,bm84,bm86;
double bm92,bm94,bm96;

bm222 = ((mml[1]-mml[0])/4)+mml[0];
bm224 = ((mml[1]-mml[0])/2)+mml[0];
bm226 = ((mml[1]-mml[0])/4)*3+mml[0];

bm112 = ((mml[2]-mml[1])/4)+mml[1];
bm114 = ((mml[2]-mml[1])/2)+mml[1];
bm116 = ((mml[2]-mml[1])/4)*3+mml[1];

bm02 = ((mml[3]-mml[2])/4)+mml[2];
bm04 = ((mml[3]-mml[2])/2)+mml[2];
bm06 = ((mml[3]-mml[2])/4)*3+mml[2];

bm12 = ((mml[4]-mml[3])/4)+mml[3];
bm14 = ((mml[4]-mml[3])/2)+mml[3];
bm16 = ((mml[4]-mml[3])/4)*3+mml[3];

bm22 = ((mml[5]-mml[4])/4)+mml[4];
bm24 = ((mml[5]-mml[4])/2)+mml[4];
bm26 = ((mml[5]-mml[4])/4)*3+mml[4];

bm32 = ((mml[6]-mml[5])/4)+mml[5];
bm34 = ((mml[6]-mml[5])/2)+mml[5];
bm36 = ((mml[6]-mml[5])/4)*3+mml[5];

bm42 = ((mml[7]-mml[6])/4)+mml[6];
bm44 = ((mml[7]-mml[6])/2)+mml[6];
bm46 = ((mml[7]-mml[6])/4)*3+mml[6];

bm52 = ((mml[8]-mml[7])/4)+mml[7];
bm54 = ((mml[8]-mml[7])/2)+mml[7];
bm56 = ((mml[8]-mml[7])/4)*3+mml[7];

bm62 = ((mml[9]-mml[8])/4)+mml[8];
bm64 = ((mml[9]-mml[8])/2)+mml[8];
bm66 = ((mml[9]-mml[8])/4)*3+mml[8];

bm72 = ((mml[10]-mml[9])/4)+mml[9];
bm74 = ((mml[10]-mml[9])/2)+mml[9];
bm76 = ((mml[10]-mml[9])/4)*3+mml[9];

bm82 = ((mml[11]-mml[10])/4)+mml[10];
bm84 = ((mml[11]-mml[10])/2)+mml[10];
bm86 = ((mml[11]-mml[10])/4)*3+mml[10];

bm92 = ((mml[12]-mml[11])/4)+mml[11];
bm94 = ((mml[12]-mml[11])/2)+mml[11];
bm96 = ((mml[12]-mml[11])/4)*3+mml[11];

//Calculating Pivots
double rates[1][6],yesterday_close,yesterday_high,yesterday_low;
ArrayCopyRates(rates, Symbol(), PERIOD_D1);

if(DayOfWeek() == 1)
{
   if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,1)) == 5)
   {
       yesterday_close = rates[1][4];
       yesterday_high = rates[1][3];
       yesterday_low = rates[1][2];
   }
   else
   {
      for(int d = 5;d>=0;d--)
      {
         if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,d)) == 5)
         {
             yesterday_close = rates[d][4];
             yesterday_high = rates[d][3];
             yesterday_low = rates[d][2];
         }
         
      }  
      
   }
}
else
{
    yesterday_close = rates[1][4];
    yesterday_high = rates[1][3];
    yesterday_low = rates[1][2];
}


//---- Calculate Pivots

double R = yesterday_high - yesterday_low;//range
double p = (yesterday_high + yesterday_low + yesterday_close)/3;// Standard Pivot
double r3 = (2*p)+(yesterday_high-(2*yesterday_low));
double r2 = p+(yesterday_high - yesterday_low);
double r1 = (2*p)-yesterday_low;
double s1 = (2*p)-yesterday_high;
double s2 = p-(yesterday_high - yesterday_low);
double s3 = (2*p)-((2* yesterday_high)-yesterday_low);
double yc = yesterday_close;

CreateObj3(FF1, mml[2], mml[10], C'0,6,60');
CreateObj3(FF2, mml[0], mml[2], C'100,5,60');
CreateObj3(FF3, mml[12], mml[10], C'100,5,60');
CreateObj3(YC, yc, yc, Silver);
  
ObjectsRedraw(); 

// --- Typing Labels
//yc label
if(ObjectFind("yc label") != 0)
{
ObjectCreate("yc label", OBJ_TEXT, 0, Time[15], yc);
ObjectSetText("yc label", " Yesterday Close "+DoubleToStr(yc,Digits), 8, "Arial", Silver);
}
else
{
ObjectMove("yc label", 0, Time[15], yc);
}

//Baby 2 Column
ObjectDelete("yc_Line");
ObjectCreate("yc_Line", OBJ_TRENDBYANGLE,0, CurTime(),yc);
ObjectSet("yc_Line",OBJPROP_COLOR,Silver);
ObjectSet("yc_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("yc_Line",OBJPROP_RAY, false);
ObjectSet("yc_Line",OBJPROP_WIDTH,2);  

ObjectDelete("bm222_Line");
ObjectCreate("bm222_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm222);
ObjectSet("bm222_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm222_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm222_Line",OBJPROP_RAY, false);
ObjectSet("bm222_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm224_Line");
ObjectCreate("bm224_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm224);
ObjectSet("bm224_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm224_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm224_Line",OBJPROP_RAY,false);
ObjectSet("bm224_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm226_Line");
ObjectCreate("bm226_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm226);
ObjectSet("bm226_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm226_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm226_Line",OBJPROP_RAY,false);
ObjectSet("bm226_Line",OBJPROP_WIDTH,0); 

ObjectDelete("bm112_Line");
ObjectCreate("bm112_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm112);
ObjectSet("bm112_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm112_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm112_Line",OBJPROP_RAY,false);
ObjectSet("bm112_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm114_Line");
ObjectCreate("bm114_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm114);
ObjectSet("bm114_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm114_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm114_Line",OBJPROP_RAY,false);
ObjectSet("bm114_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm116_Line");
ObjectCreate("bm116_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm116);
ObjectSet("bm116_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm116_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm116_Line",OBJPROP_RAY,false);
ObjectSet("bm116_Line",OBJPROP_WIDTH,0); 

ObjectDelete("bm02_Line");
ObjectCreate("bm02_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm02);
ObjectSet("bm02_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm02_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm02_Line",OBJPROP_RAY,false);
ObjectSet("bm02_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm04_Line");
ObjectCreate("bm04_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm04);
ObjectSet("bm04_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm04_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm04_Line",OBJPROP_RAY,false);
ObjectSet("bm04_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm06_Line");
ObjectCreate("bm06_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm06);
ObjectSet("bm06_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm06_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm06_Line",OBJPROP_RAY,false);
ObjectSet("bm06_Line",OBJPROP_WIDTH,0); 

ObjectDelete("bm12_Line");
ObjectCreate("bm12_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm12);
ObjectSet("bm12_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm12_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm12_Line",OBJPROP_RAY,false);
ObjectSet("bm12_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm14_Line");
ObjectCreate("bm14_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm14);
ObjectSet("bm14_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm14_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm14_Line",OBJPROP_RAY,false);
ObjectSet("bm14_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm16_Line");
ObjectCreate("bm16_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm16);
ObjectSet("bm16_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm16_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm16_Line",OBJPROP_RAY,false);
ObjectSet("bm16_Line",OBJPROP_WIDTH,0); 

ObjectDelete("bm22_Line");
ObjectCreate("bm22_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm22);
ObjectSet("bm22_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm22_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm22_Line",OBJPROP_RAY,false);
ObjectSet("bm22_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm24_Line");
ObjectCreate("bm24_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm24);
ObjectSet("bm24_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm24_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm24_Line",OBJPROP_RAY,false);
ObjectSet("bm24_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm26_Line");
ObjectCreate("bm26_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm26);
ObjectSet("bm26_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm26_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm26_Line",OBJPROP_RAY,false);
ObjectSet("bm26_Line",OBJPROP_WIDTH,0);  

ObjectDelete("bm32_Line");
ObjectCreate("bm32_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm32);
ObjectSet("bm32_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm32_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm32_Line",OBJPROP_RAY,false);
ObjectSet("bm32_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm34_Line");
ObjectCreate("bm34_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm34);
ObjectSet("bm34_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm34_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm34_Line",OBJPROP_RAY,false);
ObjectSet("bm34_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm36_Line");
ObjectCreate("bm36_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm36);
ObjectSet("bm36_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm36_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm36_Line",OBJPROP_RAY,false);
ObjectSet("bm36_Line",OBJPROP_WIDTH,0);  

ObjectDelete("bm42_Line");
ObjectCreate("bm42_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm42);
ObjectSet("bm42_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm42_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm42_Line",OBJPROP_RAY,false);
ObjectSet("bm42_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm44_Line");
ObjectCreate("bm44_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm44);
ObjectSet("bm44_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm44_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm44_Line",OBJPROP_RAY,false);
ObjectSet("bm44_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm46_Line");
ObjectCreate("bm46_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm46);
ObjectSet("bm46_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm46_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm46_Line",OBJPROP_RAY,false);
ObjectSet("bm46_Line",OBJPROP_WIDTH,0);  

ObjectDelete("bm52_Line");
ObjectCreate("bm52_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm52);
ObjectSet("bm52_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm52_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm52_Line",OBJPROP_RAY,false);
ObjectSet("bm52_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm54_Line");
ObjectCreate("bm54_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm54);
ObjectSet("bm54_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm54_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm54_Line",OBJPROP_RAY,false);
ObjectSet("bm54_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm56_Line");
ObjectCreate("bm56_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm56);
ObjectSet("bm56_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm56_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm56_Line",OBJPROP_RAY,false);
ObjectSet("bm56_Line",OBJPROP_WIDTH,0);  

ObjectDelete("bm62_Line");
ObjectCreate("bm62_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm62);
ObjectSet("bm62_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm62_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm62_Line",OBJPROP_RAY,false);
ObjectSet("bm62_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm64_Line");
ObjectCreate("bm64_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm64);
ObjectSet("bm64_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm64_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm64_Line",OBJPROP_RAY,false);
ObjectSet("bm64_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm66_Line");
ObjectCreate("bm66_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm66);
ObjectSet("bm66_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm66_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm66_Line",OBJPROP_RAY,false);
ObjectSet("bm66_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm72_Line");
ObjectCreate("bm72_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm72);
ObjectSet("bm72_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm72_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm72_Line",OBJPROP_RAY,false);
ObjectSet("bm72_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm74_Line");
ObjectCreate("bm74_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm74);
ObjectSet("bm74_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm74_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm74_Line",OBJPROP_RAY,false);
ObjectSet("bm74_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm76_Line");
ObjectCreate("bm76_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm76);
ObjectSet("bm76_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm76_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm76_Line",OBJPROP_RAY,false);
ObjectSet("bm76_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm82_Line");
ObjectCreate("bm82_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm82);
ObjectSet("bm82_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm82_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm82_Line",OBJPROP_RAY,false);
ObjectSet("bm82_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm84_Line");
ObjectCreate("bm84_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm84);
ObjectSet("bm84_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm84_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm84_Line",OBJPROP_RAY,false);
ObjectSet("bm84_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm86_Line");
ObjectCreate("bm86_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm86);
ObjectSet("bm86_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm86_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm86_Line",OBJPROP_RAY,false);
ObjectSet("bm86_Line",OBJPROP_WIDTH,0);
 
ObjectDelete("bm92_Line");
ObjectCreate("bm92_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm92);
ObjectSet("bm92_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm92_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm92_Line",OBJPROP_RAY,false);
ObjectSet("bm92_Line",OBJPROP_WIDTH,0);  
 
ObjectDelete("bm94_Line");
ObjectCreate("bm94_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm94);
ObjectSet("bm94_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm94_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm94_Line",OBJPROP_RAY,false);
ObjectSet("bm94_Line",OBJPROP_WIDTH,0);

ObjectDelete("bm96_Line");
ObjectCreate("bm96_Line", OBJ_TRENDBYANGLE,0, CurTime(),bm96);
ObjectSet("bm96_Line",OBJPROP_COLOR,DarkSlateGray);
ObjectSet("bm96_Line",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("bm96_Line",OBJPROP_RAY,false);
ObjectSet("bm96_Line",OBJPROP_WIDTH,0);

   drawLabel24("MK24","TimeFrame",9,Silver,5,25,"Arial Bold");
   drawLabel25("MK25","MML",9,Silver,5,25,"Arial Bold");
   drawLabel26("MK26","mML",9,Silver,5,25,"Arial Bold");
   drawLabel27("MK27","bML",9,Silver,5,25,"Arial Bold");
   drawLabel30("MK30","0/8th",8,Silver,5,25,"Arial");
   drawLabel31("MK31","1/8th",8,Silver,5,25,"Arial");
   drawLabel32("MK32","2/8th",8,Silver,5,25,"Arial");
   drawLabel33("MK33","3/8th",8,Silver,5,25,"Arial");
   drawLabel34("MK34","4/8th",8,Silver,5,25,"Arial");
   drawLabel35("MK35","5/8th",8,Silver,5,25,"Arial");
   drawLabel36("MK36","6/8th",8,Silver,5,25,"Arial");
   drawLabel37("MK37","7/8th",8,Silver,5,25,"Arial");
   drawLabel38("MK38","8/8th",8,Silver,5,25,"Arial");
   drawLabel39("MK39","+1/8th",8,Silver,5,25,"Arial");
   drawLabel40("MK40","+2/8th",8,Silver,5,25,"Arial");
   drawLabel41("MK41","-1/8th",8,Silver,5,25,"Arial");
   drawLabel42("MK42","-2/8th",8,Silver,5,25,"Arial");
   
   drawLabel000("MK000",DoubleToStr(m0,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabel001("MK001",DoubleToStr(m1,Digits),9,Yellow,5,25,"Arial");
   drawLabel002("MK002",DoubleToStr(m2,Digits),9,HotPink,5,25,"Arial");
   drawLabel003("MK003",DoubleToStr(m3,Digits),9,Lime,5,25,"Arial");
   drawLabel004("MK004",DoubleToStr(m4,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabel005("MK005",DoubleToStr(m5,Digits),9,Lime,5,25,"Arial");
   drawLabel006("MK006",DoubleToStr(m6,Digits),9,HotPink,5,25,"Arial");
   drawLabel007("MK007",DoubleToStr(m7,Digits),9,Yellow,5,25,"Arial");
   drawLabel008("MK008",DoubleToStr(m8,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabel08("MK08",DoubleToStr(mm11,Digits),9,Yellow,5,25,"Arial");
   drawLabel09("MK09",DoubleToStr(mm12,Digits),9,HotPink,5,25,"Arial");
   
   drawLabel1001("MK0001",DoubleToStr(mm0,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabel1002("MK0002",DoubleToStr(mm1,Digits),9,Yellow,5,25,"Arial");
   drawLabel1003("MK0003",DoubleToStr(mm2,Digits),9,HotPink,5,25,"Arial");
   drawLabel1004("MK0004",DoubleToStr(mm3,Digits),9,Lime,5,25,"Arial");
   drawLabel1005("MK0005",DoubleToStr(mm4,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabel1006("MK0006",DoubleToStr(mm5,Digits),9,Lime,5,25,"Arial");
   drawLabel1007("MK0007",DoubleToStr(mm6,Digits),9,HotPink,5,25,"Arial");
   drawLabel1008("MK0008",DoubleToStr(mm7,Digits),9,Yellow,5,25,"Arial");
   drawLabel1009("MK0009",DoubleToStr(mm8,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabel1009b("MK0009b",DoubleToStr(mm13,Digits),9,Yellow,5,25,"Arial");
   drawLabel1009c("MK0009c",DoubleToStr(mm14,Digits),9,HotPink,5,25,"Arial");

   drawLabela00("MKa00",DoubleToStr(mm30,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabelam1("MKam1",DoubleToStr(mm3M1,Digits),9,Yellow,5,25,"Arial");
   drawLabelam2("MKam2",DoubleToStr(mm3M2,Digits),9,HotPink,5,25,"Arial");
   drawLabela1("MKa1",DoubleToStr(mm31,Digits),9,Yellow,5,25,"Arial");
   drawLabela2("MKa2",DoubleToStr(mm32,Digits),9,HotPink,5,25,"Arial");
   drawLabela3("MKa3",DoubleToStr(mm33,Digits),9,Lime,5,25,"Arial");
   drawLabela4("MKa4",DoubleToStr(mm34,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabela5("MKa5",DoubleToStr(mm35,Digits),9,Lime,5,25,"Arial");
   drawLabela6("MKa6",DoubleToStr(mm36,Digits),9,HotPink,5,25,"Arial");
   drawLabela7("MKa7",DoubleToStr(mm37,Digits),9,Yellow,5,25,"Arial");
   drawLabela8("MKa8",DoubleToStr(mm38,Digits),9,DodgerBlue,5,25,"Arial");
   drawLabela9("MKa9",DoubleToStr(mm3P1,Digits),9,Yellow,5,25,"Arial");
   drawLabela10("MKa10",DoubleToStr(mm3P2,Digits),9,HotPink,5,25,"Arial");
   
   drawLabel301("MK301","0/8th",8,Silver,5,25,"Arial");
   drawLabel311("MK311","1/8th",8,Silver,5,25,"Arial");
   drawLabel321("MK321","2/8th",8,Silver,5,25,"Arial");
   drawLabel331("MK331","3/8th",8,Silver,5,25,"Arial");
   drawLabel341("MK341","4/8th",8,Silver,5,25,"Arial");
   drawLabel351("MK351","5/8th",8,Silver,5,25,"Arial");
   drawLabel361("MK361","6/8th",8,Silver,5,25,"Arial");
   drawLabel371("MK371","7/8th",8,Silver,5,25,"Arial");
   drawLabel381("MK381","8/8th",8,Silver,5,25,"Arial");
   drawLabel391("MK391","+1/8th",8,Silver,5,25,"Arial");
   drawLabel401("MK401","+2/8th",8,Silver,5,25,"Arial");
   drawLabel411("MK411","-1/8th",8,Silver,5,25,"Arial");
   drawLabel421("MK421","-2/8th",8,Silver,5,25,"Arial");
   
   drawLabelz0("z0",DoubleToStr(mml[0],Digits),9,Red,5,25,"Arial");
   drawLabelz1("z1",DoubleToStr(mml[1],Digits),9,OrangeRed,5,25,"Arial");
   drawLabelz2("z2",DoubleToStr(mml[2],Digits),9,DodgerBlue,5,25,"Arial");
   drawLabelz3("z3",DoubleToStr(mml[3],Digits),9,Yellow,5,25,"Arial");
   drawLabelz4("z4",DoubleToStr(mml[4],Digits),9,HotPink,5,25,"Arial");
   drawLabelz5("z5",DoubleToStr(mml[5],Digits),9,Lime,5,25,"Arial");
   drawLabelz6("z6",DoubleToStr(mml[6],Digits),9,DodgerBlue,5,25,"Arial");
   drawLabelz7("z7",DoubleToStr(mml[7],Digits),9,Lime,5,25,"Arial");
   drawLabelz8("z8",DoubleToStr(mml[8],Digits),9,HotPink,5,25,"Arial");
   drawLabelz9("z9",DoubleToStr(mml[9],Digits),9,Yellow,5,25,"Arial");
   drawLabelz10("z10",DoubleToStr(mml[10],Digits),9,DodgerBlue,5,25,"Arial");
   drawLabelz11("z11",DoubleToStr(mml[11],Digits),9,OrangeRed,5,25,"Arial");
   drawLabelz12("z12",DoubleToStr(mml[12],Digits),9,Red,5,25,"Arial");
   
ObjectsRedraw();  
  
   }

Comment("                                                                        :::: DateTime: ",TimeToStr(LocalTime()),"  Price: ",xard," :::: ","MM-TimeFrame-2007 By Xard777 :::: ");
 
//---- End Of Program

  return(0);
  }
//Job Done  
//+------------------------------------------------------------------+

void drawLabel30(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 270);
        }} 
        
void drawLabel31(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 282);
        }}  
  
void drawLabel32(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 294);
        }}   
        
void drawLabel33(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 306);
        }}                      
        
void drawLabel34(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 318);
        }}   
        
void drawLabel35(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 330);
        }} 
        
void drawLabel36(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 342);
        }}   
        
void drawLabel37(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 354);
        }}  
        
void drawLabel38(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 366);
        }}  
        
void drawLabel39(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 838);
        ObjectSet(id, OBJPROP_YDISTANCE, 382);
        }}  
        
void drawLabel40(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 838);
        ObjectSet(id, OBJPROP_YDISTANCE, 394);
        }}   
        
void drawLabel41(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 842);
        ObjectSet(id, OBJPROP_YDISTANCE, 254);
        }}     
        
void drawLabel42(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 842);
        ObjectSet(id, OBJPROP_YDISTANCE, 242);
        }}                                                                               

void drawLabel25(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 825);
        ObjectSet(id, OBJPROP_YDISTANCE, 408);
        }} 
        
void drawLabel26(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 878);
        ObjectSet(id, OBJPROP_YDISTANCE, 408);
        }}  
        
void drawLabel27(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 935);
        ObjectSet(id, OBJPROP_YDISTANCE, 408);
        }}                


void drawLabela00(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 270);
        }} 
        
void drawLabelam1(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 254);
        }}        
        
void drawLabelam2(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 242);
        }}    
        
void drawLabela1(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 282);
        }} 
        
void drawLabela2(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 294);
        }}   
        
void drawLabela3(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 306);
        }} 
        
void drawLabela4(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 318);
        }} 
        
void drawLabela5(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 330);
        }}   
        
void drawLabela6(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 342);
        }}   
        
void drawLabela7(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 354);
        }} 
        
void drawLabela8(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 366);
        }}  
        
void drawLabela9(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 382);
        }}   
        
void drawLabela10(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 925);
        ObjectSet(id, OBJPROP_YDISTANCE, 394);
        }}                                                                                    

void drawLabel000(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 270);
        }}      
  
void drawLabel001(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 282);
        }}    
        
void drawLabel002(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 294);
        }}    
        
void drawLabel003(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 306);
        }}     
        
void drawLabel004(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 318);
        }} 
        
void drawLabel005(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 330);
        }}  
        
void drawLabel006(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 342);
        }} 
        
void drawLabel007(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 354);
        }} 
        
void drawLabel008(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 815);
        ObjectSet(id, OBJPROP_YDISTANCE, 366);
        }}      
        
void drawLabel08(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 254);
        }}  
        
void drawLabel09(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 242);
        }}   
        
void drawLabel1001(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 270);
        }}     
        
void drawLabel1002(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 282);
        }} 
        
void drawLabel1003(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 294);
        }}    
        
void drawLabel1004(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 306);
        }}             
        
void drawLabel1005(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 318);
        }}    
        
void drawLabel1006(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 330);
        }}     
        
void drawLabel1007(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 342);
        }}  
        
void drawLabel1008(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 354);
        }}   
        
void drawLabel1009(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 366);
        }} 
        
void drawLabel1009b(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 382);
        }}  
        
void drawLabel1009c(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 870);
        ObjectSet(id, OBJPROP_YDISTANCE, 394);
        }}           
        
void drawLabel301(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 70);
        }} 
        
void drawLabel311(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 82);
        }}  
  
void drawLabel321(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 94);
        }}   
        
void drawLabel331(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 106);
        }}                      
        
void drawLabel341(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 118);
        }}   
        
void drawLabel351(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 130);
        }} 
        
void drawLabel361(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 142);
        }}   
        
void drawLabel371(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 154);
        }}  
        
void drawLabel381(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 789);
        ObjectSet(id, OBJPROP_YDISTANCE, 166);
        }}  
        
void drawLabel391(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 783);
        ObjectSet(id, OBJPROP_YDISTANCE, 182);
        }}  
        
void drawLabel401(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 783);
        ObjectSet(id, OBJPROP_YDISTANCE, 194);
        }}   
        
void drawLabel411(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 786);
        ObjectSet(id, OBJPROP_YDISTANCE, 54);
        }}     
        
void drawLabel421(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 786);
        ObjectSet(id, OBJPROP_YDISTANCE, 42);
        }}                                                                               

void drawLabelz0(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 42);
        }} 
        
void drawLabelz1(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 54);
        }}         
        
void drawLabelz2(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 70);
        }}         
        
void drawLabelz3(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 82);
        }}    
        
void drawLabelz4(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 94);
        }}              
   
void drawLabelz5(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 106);
        }}         
        
void drawLabelz6(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 118);
        }}                 
        
void drawLabelz7(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 130);
        }}                 
        
void drawLabelz8(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 142);
        }}       
        
void drawLabelz9(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 154);
        }}                           
        
void drawLabelz10(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 166);
        }}              
        
void drawLabelz11(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 182);
        }}                           
        
void drawLabelz12(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 820);
        ObjectSet(id, OBJPROP_YDISTANCE, 194);
        }}       
     
void drawLabel24(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 790);
        ObjectSet(id, OBJPROP_YDISTANCE, 208);
        }}                       