
#property copyright ""
#property link      ""
#property indicator_buffers 8

/*#property indicator_color1 C'0,6,60';
#property indicator_color2 Red
#property indicator_color3 Magenta
#property indicator_color4 Magenta
#property indicator_color5 Magenta
#property indicator_color6 Gold
#property indicator_color7 Aqua
#property indicator_color8 Lime */

extern int       FastEMA=12;  //8  Faster settings
extern int       SlowEMA=26;  //17
extern int       SignalSMA=9; //9 
extern int       FFastEMA=8;  //5
extern int       SSlowEMA=17; //10 //M1 Entry Signal
extern int       SSignalSMA=9;//17
double s1[];
extern bool Comments=false;
extern int TimeFrame = 60,
           Price = 0,
           LongTrendMaType = 1,
           LongTrendMaPrice = 0,
           LongTrendMaLength = 144, 
           MainTrendMaType = 1,
           MainTrendMaPrice = 0,
           MainTrendMaLength = 24,
           MiniTrendMaType = 1,
           MiniTrendMaPrice = 0,
           MiniTrendMaLength = 6,
           VeryLongMaType = 1,
           VeryLongMaPrice = 0,
           VeryLongMaLength = 363,
           Ma5Type = 1,
           Ma5Price = 2,
           Ma5Length = 144,
           Ma6Type = 1,
           Ma6Price = 3,
           Ma6Length = 144,          
           DotMaType = 1,
           DotMaPrice = 0,
           DotMaLength = 12;
double D = 1; //How many days back /0 = curr day/ 1 = yesterday/ 2= 2days ago
double B = 0; //Today = 0/ yesterday = 1 / 2days ago = 2
double price[],longtrend[],trend[],trend2[],mavltf[],ma5[],ma6[],madot[];

#property indicator_chart_window
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
IndicatorShortName("#Xard-Indy-06");
//---- indicators
SetIndexBuffer(0,price);
SetIndexBuffer(1,mavltf);
SetIndexBuffer(2,longtrend);
SetIndexBuffer(3,ma5);
SetIndexBuffer(4,ma6);
SetIndexBuffer(5,trend);
SetIndexBuffer(6,trend2);
SetIndexBuffer(7,madot);
 
/*
SetIndexStyle(0,DRAW_LINE,0,3);
SetIndexStyle(1,DRAW_LINE,0,1);
SetIndexStyle(2,DRAW_LINE,0,2);
SetIndexStyle(3,DRAW_LINE,2,0);
SetIndexStyle(4,DRAW_LINE,2,0);
SetIndexStyle(5,DRAW_LINE,0,2);
SetIndexStyle(6,DRAW_LINE,0,2);
SetIndexStyle(7,DRAW_ARROW,0,2);
SetIndexArrow(7,160); */
    
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
 ObjectsDeleteAll();  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
  //Time to bar expiry
	double g;
   int m,s,k;
   m=Time[0]+Period()*60-CurTime();
   g=m/60.0;
   s=m%60;
   m=(m-m%60)/60;
   //Comment(m + " minutes " + s + " seconds left to bar end");
   g=NormalizeDouble(g,1);
   for (k=1;k<=Bars-1;k++) s1[k]=0.0000001;
   for (k=1;k<=2;k++) s1[k]=g;
//end bar expiry
  
   int    limit, bigshift; 
   int    counted_bars=IndicatorCounted(); 
//---- 
   if (counted_bars<0) return(-1); 
   if (counted_bars>0) counted_bars--; 
   limit=Bars-counted_bars; 
    
   for (int i=limit; i>=0; i--)

   { 
      bigshift = iBarShift(Symbol(),TimeFrame,Time[i]); 
      
       price[i] = getPrice(bigshift);
       mavltf[i] = iMA(Symbol(),TimeFrame,VeryLongMaLength,0,VeryLongMaType,VeryLongMaPrice,bigshift);
       
       longtrend[i] = iMA(Symbol(),TimeFrame,LongTrendMaLength,0,LongTrendMaType,LongTrendMaPrice,bigshift);
       ma5[i] = iMA(Symbol(),TimeFrame,Ma5Length,0,Ma5Type,Ma5Price,bigshift);
       ma6[i] = iMA(Symbol(),TimeFrame,Ma6Length,0,Ma6Type,Ma6Price,bigshift);
               
       trend[i] = iMA(Symbol(),TimeFrame,MainTrendMaLength,0,MainTrendMaType,MainTrendMaPrice,bigshift);
       trend2[i] = iMA(Symbol(),TimeFrame,MiniTrendMaLength,0,MiniTrendMaType,MiniTrendMaPrice,bigshift); 
       madot[i] = iMA(Symbol(),TimeFrame,DotMaLength,0,DotMaType,DotMaPrice,bigshift);
  
   string ENTRY_trend2= "",entry_mavltf= "",ENTRY_mavltf= "",entry_trend2= "",WAIT_price= "",wait_price= "",WAIT_price2= "",wait_price2= "",MINI= "",
          mini= "";
   
   string macd_h1= "", macd_m5= "", Dmacd_h1= "", Dmacd_m5= "", WAIT= "", NEU= "", WEAK= ""
           , WEAK2= "", STRG= "", STRG2= "", signal_m1= "", SIGNAL_m1= "", signal_m5= "",
            SIGNAL_m5= "", signal_h4= "", SIGNAL_h4= "", SIGNAL_h1= "", signal_h1= "", SIGNAL_m15= "",
             signal_m15= "", entry_m5= "", ENTRY_m5= "", signal_m30= "", SIGNAL_m30= "", ENTRY_ema9= "",entry_ema5= "" ;
      
     //Trend UP/DOWN   
     if ((price[i]> mavltf[i])&& (trend[i]> mavltf[i])) {entry_mavltf= "Major-UP"; }
     if ((price[i]< mavltf[i])&& (trend[i]< mavltf[i])) {ENTRY_mavltf= "Major-DN"; }
     
     if ((price[i]< mavltf[i])&& (trend[i]> mavltf[i])) {WAIT_price2= "Major-??"; }
     if ((price[i]> mavltf[i])&& (trend[i]< mavltf[i])) {wait_price2= "Major-??"; }
     
     if ((price[i]> trend[i])&& (trend2[i]> trend[i])) {entry_trend2= "Main-UP"; }
     if ((price[i]< trend[i])&& (trend2[i]< trend[i])) {ENTRY_trend2= "Main-DN"; }
     
     if ((price[i]< trend[i])&& (trend2[i]> trend[i])) {WAIT_price= "Main-??"; }
     if ((price[i]> trend[i])&& (trend2[i]< trend[i])) {wait_price= "Main-??"; }
     
     if (price[i]> trend2[i]) {MINI= "Mini-UP";}
     if (price[i]<= trend2[i]) {mini= "Mini-DN";}
  
   //Time left on Bars       
    ObjectCreate("X601", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X601",DoubleToStr(m,-3),15, "Arial Bold", Lime);
        ObjectSet("X601", OBJPROP_CORNER, 0);
        ObjectSet("X601", OBJPROP_XDISTANCE, 895);
        ObjectSet("X601", OBJPROP_YDISTANCE, 0);
   
    ObjectCreate("X602", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X602",DoubleToStr(s,-3), 15, "Arial Bold", Lime);
        ObjectSet("X602", OBJPROP_CORNER, 0);
        ObjectSet("X602", OBJPROP_XDISTANCE, 950);
        ObjectSet("X602", OBJPROP_YDISTANCE, 0);
        
    ObjectCreate("X603", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X603","MINS ", 8, "Arial Bold", White);
        ObjectSet("X603", OBJPROP_CORNER, 0);
        ObjectSet("X603", OBJPROP_XDISTANCE, 867);
        ObjectSet("X603", OBJPROP_YDISTANCE, 2);     
        
    ObjectCreate("X604", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X604","SECS ", 8, "Arial Bold", White);
        ObjectSet("X604", OBJPROP_CORNER, 0);
        ObjectSet("X604", OBJPROP_XDISTANCE, 920);
        ObjectSet("X604", OBJPROP_YDISTANCE, 2);
 
    //Trend                
    ObjectCreate("X618", OBJ_LABEL, WindowFind("EMA"), 0, 0);//TREND LABEL
        ObjectSetText("X618","TREND ", 8, "Arial Bold", White);
        ObjectSet("X618", OBJPROP_CORNER, 0);
        ObjectSet("X618", OBJPROP_XDISTANCE, 575);
        ObjectSet("X618", OBJPROP_YDISTANCE, 2);    
                        
        //wait label for major trend               
        ObjectCreate("X619", OBJ_LABEL, WindowFind("EMA"), 0, 0);//TREND UP
        ObjectSetText("X619",StringSubstr(entry_mavltf,0),15, "Arial Bold", Lime);
        ObjectSet("X619", OBJPROP_CORNER, 0);
        ObjectSet("X619", OBJPROP_XDISTANCE, 612);//was 250
        ObjectSet("X619", OBJPROP_YDISTANCE, 0);//was 15
        
        ObjectCreate("X620", OBJ_LABEL, WindowFind("EMA"), 0, 0);//TREND DOWN
        ObjectSetText("X620",StringSubstr(ENTRY_mavltf,0),15, "Arial Bold", Red);
        ObjectSet("X620", OBJPROP_CORNER, 0);
        ObjectSet("X620", OBJPROP_XDISTANCE, 612);//was 250
        ObjectSet("X620", OBJPROP_YDISTANCE, 0);//was 15
        
        //wait label for major trend when in caution zone:     
        ObjectCreate("X621", OBJ_LABEL, WindowFind("EMA"), 0, 0);//WAIT
        ObjectSetText("X621",StringSubstr(WAIT_price2,0),10, "Arial Bold", Yellow);
        ObjectSet("X621", OBJPROP_CORNER, 0);
        ObjectSet("X621", OBJPROP_XDISTANCE, 612);//was 263
        ObjectSet("X621", OBJPROP_YDISTANCE, 0);//was 15
        
        ObjectCreate("X622", OBJ_LABEL, WindowFind("EMA"), 0, 0);//WAIT
        ObjectSetText("X622",StringSubstr(wait_price2,0),15, "Arial Bold", Yellow);
        ObjectSet("X622", OBJPROP_CORNER, 0);
        ObjectSet("X622", OBJPROP_XDISTANCE, 612);//was 263
        ObjectSet("X622", OBJPROP_YDISTANCE, 0);//was  15 
        
//wait label for main trend           
        ObjectCreate("X623", OBJ_LABEL, WindowFind("EMA"), 0, 0);//TREND UP
        ObjectSetText("X623",StringSubstr(entry_trend2,0),15, "Arial Bold", Lime);
        ObjectSet("X623", OBJPROP_CORNER, 0);
        ObjectSet("X623", OBJPROP_XDISTANCE, 705);//was 250
        ObjectSet("X623", OBJPROP_YDISTANCE, 0);//was 15
        
        ObjectCreate("X624", OBJ_LABEL, WindowFind("EMA"), 0, 0);//TREND DOWN
        ObjectSetText("X624",StringSubstr(ENTRY_trend2,0),15, "Arial Bold", Red);
        ObjectSet("X624", OBJPROP_CORNER, 0);
        ObjectSet("X624", OBJPROP_XDISTANCE, 705);//was 250
        ObjectSet("X624", OBJPROP_YDISTANCE, 0);//was 15
        
//wait label for main trend when in caution zone:     
        ObjectCreate("X625", OBJ_LABEL, WindowFind("EMA"), 0, 0);//WAIT
        ObjectSetText("X625",StringSubstr(WAIT_price,0),15, "Arial Bold", Yellow);
        ObjectSet("X625", OBJPROP_CORNER, 0);
        ObjectSet("X625", OBJPROP_XDISTANCE, 709);//was 263
        ObjectSet("X625", OBJPROP_YDISTANCE, 0);//was 15
        
        ObjectCreate("X626", OBJ_LABEL, WindowFind("EMA"), 0, 0);//WAIT
        ObjectSetText("X626",StringSubstr(wait_price,0),15, "Arial Bold", Yellow);
        ObjectSet("X626", OBJPROP_CORNER, 0);
        ObjectSet("X626", OBJPROP_XDISTANCE, 709);//was 263
        ObjectSet("X626", OBJPROP_YDISTANCE, 0);//was  15    
        
//wait label for mini trend                
        ObjectCreate("X627", OBJ_LABEL, WindowFind("EMA"), 0, 0);//Mini UP
        ObjectSetText("X627",StringSubstr(MINI,0),15, "Arial Bold", Lime);
        ObjectSet("X627", OBJPROP_CORNER, 0);
        ObjectSet("X627", OBJPROP_XDISTANCE, 790);//was 253
        ObjectSet("X627", OBJPROP_YDISTANCE, 0);//was 45
        
        ObjectCreate("X628", OBJ_LABEL, WindowFind("EMA"), 0, 0);//Mini DOWN
        ObjectSetText("X628",StringSubstr(mini,0),15, "Arial Bold", Red);
        ObjectSet("X628", OBJPROP_CORNER, 0);
        ObjectSet("X628", OBJPROP_XDISTANCE, 790);//was 253
        ObjectSet("X628", OBJPROP_YDISTANCE, 0);//was 45 
        
        // ----insert for showing high low data   
double H2DAILY = iMA(Symbol(),PERIOD_D1,1,0,MODE_HIGH,PRICE_HIGH,B);
double LDAILY = iMA(Symbol(),PERIOD_D1,1,0,MODE_LOW,PRICE_LOW,B); 
double V2 = iMA(Symbol(),0,1,0,MODE_EMA,PRICE_CLOSE,0);  
//  CreateObj(HDAILY, LDAILY);

   ObjectCreate("X629", OBJ_LABEL, WindowFind("EMA"), 0, 0);//HiLow LABEL
        ObjectSetText("X629","HIGH", 8, "Arial Bold", White);
        ObjectSet("X629", OBJPROP_CORNER, 0);
        ObjectSet("X629", OBJPROP_XDISTANCE, 306);
        ObjectSet("X629", OBJPROP_YDISTANCE, 2);
        
   ObjectCreate("X630", OBJ_LABEL, WindowFind("EMA"), 0, 0);//HiLow LABEL
        ObjectSetText("X630","PRICE", 8, "Arial Bold", White);
        ObjectSet("X630", OBJPROP_CORNER, 0);
        ObjectSet("X630", OBJPROP_XDISTANCE, 391);
        ObjectSet("X630", OBJPROP_YDISTANCE, 2);    
        
   ObjectCreate("X631", OBJ_LABEL, WindowFind("EMA"), 0, 0);//HiLow LABEL
        ObjectSetText("X631","LOW", 8, "Arial Bold", White);
        ObjectSet("X631", OBJPROP_CORNER, 0);
        ObjectSet("X631", OBJPROP_XDISTANCE, 495);
        ObjectSet("X631", OBJPROP_YDISTANCE, 2);         
 
  ObjectCreate("X632", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X632",DoubleToStr(H2DAILY,Digits), 13, "Arial Bold", SteelBlue);
        ObjectSet("X632", OBJPROP_CORNER, 0);
        ObjectSet("X632", OBJPROP_XDISTANCE, 332);
        ObjectSet("X632", OBJPROP_YDISTANCE, 3);
        
  ObjectCreate("X633", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X633",DoubleToStr(V2,Digits), 15, "Arial Bold", Yellow);
        ObjectSet("X633", OBJPROP_CORNER, 0);
        ObjectSet("X633", OBJPROP_XDISTANCE, 426);
        ObjectSet("X633", OBJPROP_YDISTANCE, 0);  
               
  ObjectCreate("X634", OBJ_LABEL, WindowFind("EMA"), 0, 0);
        ObjectSetText("X634",DoubleToStr(LDAILY,Digits), 13, "Arial Bold", SteelBlue);
        ObjectSet("X634", OBJPROP_CORNER, 0);
        ObjectSet("X634", OBJPROP_XDISTANCE, 520);
        ObjectSet("X634", OBJPROP_YDISTANCE, 3);                
            
//-----insert end of line.             
   
   } 

//----
 
   return(0);
  }
//+------------------------------------------------------------------+
double getPrice(int shift)
{
   switch(Price)
   {
      case 0 : return ( iClose(Symbol(),TimeFrame,shift) );
      case 1 : return (iOpen(Symbol(),TimeFrame,shift));
      case 2 : return (iHigh(Symbol(),TimeFrame,shift));
      case 3 : return (iLow(Symbol(),TimeFrame,shift));
      case 4 : return ((iLow(Symbol(),TimeFrame,shift)+iHigh(Symbol(),TimeFrame,shift))/2);
      case 5 : return ((iClose(Symbol(),TimeFrame,shift)+iLow(Symbol(),TimeFrame,shift)+iHigh(Symbol(),TimeFrame,shift))/3);
      case 6 : return ((iOpen(Symbol(),TimeFrame,shift)+iClose(Symbol(),TimeFrame,shift)+iLow(Symbol(),TimeFrame,shift)+iHigh(Symbol(),TimeFrame,shift))/4);
   }
      
}

