//+------------------------------------------------------------------+
//|                                                 #PriceToOpen.mq4 |
//+------------------------------------------------------------------+
#property description "Price relative to Open Histogram"
//#property strict

//#include <MovingAverages.mqh>

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_minimum 0
#property indicator_maximum 2
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_width1 4
#property indicator_width2 4
//---- input parameters
input  int    TimeFrame=1440;
//---- buffers
double up[];
double dn[];
//----
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|
void init() {
  SetIndexBuffer(0,up);
  SetIndexBuffer(1,dn);
  SetIndexStyle(0,DRAW_HISTOGRAM);
  SetIndexStyle(1,DRAW_HISTOGRAM);
  SetIndexArrow(0,110);
  SetIndexArrow(1,110);
}
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
void deinit() {
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start(){
  datetime TimeArray[];
  int      i,y,limit,counted_bars;
  double   opn;
  counted_bars=IndicatorCounted();
  if(counted_bars<1)limit=Bars-1;
  else              limit=Bars-counted_bars;
  
  if(Period()>=240)return(0);  
  
  ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame);

  for(i=0,y=0;i<limit;i++){
    
    if(Time[i]<TimeArray[y])y++;
    
    up[i]=EMPTY_VALUE;
    dn[i]=EMPTY_VALUE;

    opn=iOpen( Symbol(),TimeFrame,y);

    if(Close[i+0]>opn)up[i+0]=2;
    else              dn[i+0]=2;
    
  }
  
//----
  
 return(0);
}
//+------------------------------------------------------------------+