#property indicator_chart_window
#define PREFIX "T3S"

#property indicator_buffers 2               
#property indicator_color1 Lime
#property indicator_color2 White

extern int    Snake_HalfCycle = 14;
extern int    T3Period        = 21;
extern int    T3Price         = PRICE_CLOSE;
extern double b               = 0.518;
extern string TimeFrame       = "current time frame";
extern bool   Indi_Lines      = true;
extern bool   Real            = true;
extern int    Arr_otstup      = 0;
extern int    Arr_width       = 2;
extern bool   AlertsMessage      = true;
extern bool   AlertsSound        = false;
extern bool   AlertsEmail        = false;
extern bool   AlertsNotification = false;
extern int    SignalBar          = 0;

int sig_alert=0;

double Sn[],T3[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
    SetIndexBuffer(0,Sn);
    SetIndexLabel (0,"Sn"); 
    
    SetIndexBuffer(1,T3);
    SetIndexLabel (1,"T3"); 
if(Indi_Lines){    
    SetIndexStyle (0,DRAW_LINE);
    SetIndexStyle (1,DRAW_LINE);    
   }else{ 
    SetIndexStyle (0,DRAW_NONE);
    SetIndexStyle (1,DRAW_NONE);}   
   
    IndicatorShortName("T-S");
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   for(int i = ObjectsTotal()-1; i >= 0; i--)   
   if (StringSubstr(ObjectName(i), 0, 
       StringLen(PREFIX)) == PREFIX)
       ObjectDelete(ObjectName(i));
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int i;
   int counted_bars=IndicatorCounted();
   int limit=Bars-counted_bars;
   
   if(Real)int snk=0; else snk=Snake_HalfCycle;
 
   for(i=0; i<limit+snk; i++)
   {
    Sn[i] = iCustom(Symbol(),0,"Snake",Snake_HalfCycle,0,i);
    T3[i] = iCustom(Symbol(),0,"T3_clean",T3Period,T3Price,b,TimeFrame,0,i);
   }
//+------------------------------------------------------------------+
 for(i=0; i<limit+snk; i++)
  {    
  if(Sn[i+1]<T3[i+1] && Sn[i]>T3[i]) 
    arrows_wind(i,"T3+Snake_Up",Arr_otstup ,233,Lime,Arr_width,false);
    else ObjectDelete(PREFIX+"T3+Snake_Up"+TimeToStr(Time[i],TIME_DATE|TIME_SECONDS));
  
  if(Sn[i+1]>T3[i+1] && Sn[i]<T3[i]) 
    arrows_wind(i,"T3+Snake_Dn",Arr_otstup ,234,Red,Arr_width,true);
    else ObjectDelete(PREFIX + "T3+Snake_Dn" + TimeToStr(Time[i],TIME_DATE|TIME_SECONDS));
//-----------------------------------------------------------------------+
 if(AlertsMessage || AlertsEmail || AlertsNotification || AlertsSound)
  { 
   string message1 = ("T3+Snake - "+Symbol()+" TF("+Period()+") - Signal for BUY"); 
   string message2 = ("T3+Snake - "+Symbol()+" TF("+Period()+") - Signal for SELL"); 
       
    if(sig_alert!=1 && Sn[SignalBar+1]<T3[SignalBar+1] && Sn[SignalBar]>T3[SignalBar])
     { 
        if (AlertsMessage) Alert(message1);
        if (AlertsEmail)   SendMail(Symbol()+" T3+Snake ",message1);
        if (AlertsNotification) SendNotification(message1);
        if (AlertsSound)   PlaySound("alert2.wav");
        sig_alert=1;
     }
    if(sig_alert!=2 && Sn[SignalBar+1]>T3[SignalBar+1] && Sn[SignalBar]<T3[SignalBar])
     { 
        if (AlertsMessage) Alert(message2);
        if (AlertsEmail)   SendMail(Symbol()+" T3+Snake ",message2);
        if (AlertsNotification) SendNotification(message2);
        if (AlertsSound)   PlaySound("alert2.wav");
        sig_alert=2;
    }
   }
  }
//+------------------------------------------------------------------+
      return(0);
}
//====================================================================  
void arrows_wind(int k, string N,int ots,int Code,color clr, int ArrowSize,bool up)                 
{           
   string objName = PREFIX+N+TimeToStr(Time[k],TIME_DATE|TIME_SECONDS); 
   double gap  = (3.0*iATR(NULL,0,20,k)/4.0)+ots*Point;
   
   ObjectCreate(objName, OBJ_ARROW,0,Time[k],0);
   ObjectSet   (objName, OBJPROP_COLOR, clr);  
   ObjectSet   (objName, OBJPROP_ARROWCODE,Code);
   ObjectSet   (objName, OBJPROP_WIDTH,ArrowSize);  
  if (up)
      ObjectSet(objName,OBJPROP_PRICE1,High[k]+gap);
     else  
      ObjectSet(objName,OBJPROP_PRICE1,Low[k]-gap);
}
//====================================================================   


