//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""

#property indicator_separate_window
#property indicator_buffers    5
#property indicator_color1     SteelBlue
#property indicator_color2     Gold
#property indicator_color3     SteelBlue
#property indicator_color4     DeepSkyBlue
#property indicator_color5     Red
#property indicator_width2     2
#property indicator_width4     2
#property indicator_levelcolor DimGray

//
//
//
//
//

extern string TimeFrame                = "Current time frame";
extern int    RsiPeriod                = 14;
extern string _rsimethods              = "0=rsi,1=wilder rsi,2=rsx2,3=cuttler rsi ";
extern int    RsiMethod                = 0;
extern int    RsiPrice                 = PRICE_CLOSE;
extern int    Depth                    = 2; 
extern double Speed                    = 0.5;   
extern double RsiPriceLinePeriod       = 2;
extern double RsiPriceLinePhase        = 0;
extern bool   RsiPriceLineDouble       = false;
extern double RsiSignalLinePeriod      = 4;
extern double RsiSignalLinePhase       = 0;
extern bool   RsiSignalLineDouble      = false;
extern int    VolatilityBandPeriod     = 20;
extern int    VolatilityBandMAMode     = MODE_SMA;
extern double VolatilityBandMultiplier = 2.0;
extern double LevelDn                  = 25;
extern double LevelMid                 = 50;
extern double LevelUp                  = 75;
extern bool   Interpolate              = true;
extern bool   alertsOn                 = true;
extern bool   alertsOnCurrent          = true;
extern bool   alertsMessage            = true;
extern bool   alertsSound              = false;
extern bool   alertsEmail              = false;
extern bool   ShowArrows               = false;
extern string arrowsIdentifier         = "TDI arrows";
extern color  arrowsUpColor            = DeepSkyBlue;
extern color  arrowsDnColor            = Red;

//
//
//
//
//

double rsi[];
double rsiPriceLine[];
double rsiSignalLine[];
double bandUp[];
double bandMid[];
double bandDn[];
double trend[];

//
//
//
//
//

string indicatorFileName;
bool   calculateValue;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init() 
{
   IndicatorBuffers(7);
   SetIndexBuffer(0,bandUp);
   SetIndexBuffer(1,bandMid);
   SetIndexBuffer(2,bandDn);
   SetIndexBuffer(3,rsiPriceLine);
   SetIndexBuffer(4,rsiSignalLine);
   SetIndexBuffer(5,rsi);
   SetIndexBuffer(6,trend);
      Speed = MathMax(MathMin(1.5,Speed),0.1);
      Depth = MathMax(MathMin(10 ,Depth),1);

      //
      //
      //
      //
      //

      indicatorFileName = WindowExpertName();
      calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
      returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
      timeFrame         = stringToTimeFrame(TimeFrame);

      //
      //
      //
      //
      //
      
   SetLevelValue(0,LevelUp);
   SetLevelValue(1,LevelMid);
   SetLevelValue(2,LevelDn);
   IndicatorShortName(timeFrameToString(timeFrame)+" TDI smoothed "+getRsiName(RsiMethod)+"");
   return (0);
}
int deinit()
{
   if (!calculateValue && ShowArrows) deleteArrows();
   return(0);
}
  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
   int i,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { bandUp[0] = limit+1; return(0); }

   //
   //
   //
   //
   //

   if (calculateValue || timeFrame == Period())
   {
      for(i=limit; i>=0; i--) rsi[i] = iRsi(getPrice(RsiPrice,i),RsiPeriod,RsiMethod,i); 
      for(i=limit; i>=0; i--)
      {
         rsiPriceLine[i]  = iDSmooth(rsi[i],RsiPriceLinePeriod ,RsiPriceLinePhase ,RsiPriceLineDouble ,i, 0);
         rsiSignalLine[i] = iDSmooth(rsi[i],RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,i,20);
             double deviation = iStdDevOnArray(rsi,0,VolatilityBandPeriod,0,VolatilityBandMAMode,i);
             double average   = iMAOnArray(rsi,0,VolatilityBandPeriod,0,VolatilityBandMAMode,i);
                bandUp[i]     = average+VolatilityBandMultiplier*deviation;
                bandDn[i]     = average-VolatilityBandMultiplier*deviation;
                bandMid[i]    = average;
         trend[i] = trend[i+1];
            if (rsiPriceLine[i]>rsiSignalLine[i] && rsiPriceLine[i]>bandMid[i]) trend[i] =  1;
            if (rsiPriceLine[i]<rsiSignalLine[i] && rsiPriceLine[i]<bandMid[i]) trend[i] = -1;
            if (!calculateValue) manageArrow(i);
      }
      manageAlerts();
      return (0);
   }      

   //
   //
   //
   //
   //

   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for (i=limit;i>=0;i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         bandUp[i]        = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",RsiPeriod,"",RsiMethod,RsiPrice,Depth,Speed,RsiPriceLinePeriod,RsiPriceLinePhase,RsiPriceLineDouble,RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,VolatilityBandPeriod,VolatilityBandMAMode,VolatilityBandMultiplier,0,y);
         bandMid[i]       = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",RsiPeriod,"",RsiMethod,RsiPrice,Depth,Speed,RsiPriceLinePeriod,RsiPriceLinePhase,RsiPriceLineDouble,RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,VolatilityBandPeriod,VolatilityBandMAMode,VolatilityBandMultiplier,1,y);
         bandDn[i]        = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",RsiPeriod,"",RsiMethod,RsiPrice,Depth,Speed,RsiPriceLinePeriod,RsiPriceLinePhase,RsiPriceLineDouble,RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,VolatilityBandPeriod,VolatilityBandMAMode,VolatilityBandMultiplier,2,y);
         rsiPriceLine[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",RsiPeriod,"",RsiMethod,RsiPrice,Depth,Speed,RsiPriceLinePeriod,RsiPriceLinePhase,RsiPriceLineDouble,RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,VolatilityBandPeriod,VolatilityBandMAMode,VolatilityBandMultiplier,3,y);
         rsiSignalLine[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",RsiPeriod,"",RsiMethod,RsiPrice,Depth,Speed,RsiPriceLinePeriod,RsiPriceLinePhase,RsiPriceLineDouble,RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,VolatilityBandPeriod,VolatilityBandMAMode,VolatilityBandMultiplier,4,y);
         trend[i]         = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",RsiPeriod,"",RsiMethod,RsiPrice,Depth,Speed,RsiPriceLinePeriod,RsiPriceLinePhase,RsiPriceLineDouble,RsiSignalLinePeriod,RsiSignalLinePhase,RsiSignalLineDouble,VolatilityBandPeriod,VolatilityBandMAMode,VolatilityBandMultiplier,6,y);
         manageArrow(i);

         //
         //
         //
         //
         //
      
         if (!Interpolate || y==iBarShift(NULL,timeFrame,Time[i-1])) continue;

         //
         //
         //
         //
         //

         datetime time = iTime(NULL,timeFrame,y);
            for(int n = 1; i+n < Bars && Time[i+n] >= time; n++) continue;	
            for(int k = 1; k < n; k++)
            {
               bandUp[i+k]        = bandUp[i]        + (bandUp[i+n]        - bandUp[i]       )*k/n;
               bandMid[i+k]       = bandMid[i]       + (bandMid[i+n]       - bandMid[i]      )*k/n;
               bandDn[i+k]        = bandDn[i]        + (bandDn[i+n]        - bandDn[i]       )*k/n;
               rsiPriceLine[i+k]  = rsiPriceLine[i]  + (rsiPriceLine[i+n]  - rsiPriceLine[i] )*k/n;
               rsiSignalLine[i+k] = rsiSignalLine[i] + (rsiSignalLine[i+n] - rsiSignalLine[i])*k/n;
            }               
   }

   //
   //
   //
   //
   //
   
   manageAlerts();
   return(0);
}

//+------------------------------------------------------------------
//|                                                                  
//+------------------------------------------------------------------
//
//
//
//
//

double getPrice(int type, int i)
{
   switch (type)
   {
      case 7:     return((Open[i]+Close[i])/2.0);
      case 8:     return((Open[i]+High[i]+Low[i]+Close[i])/4.0);
      default :   return(iMA(NULL,0,1,0,MODE_SMA,type,i));
   }      
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//
//

string rsiMethodNames[] = {"rsi","Wilders rsi","rsx2","Cuttler RSI"};
string getRsiName(int& method)
{
   int max = ArraySize(rsiMethodNames)-1;
      method=MathMax(MathMin(method,max),0); return(rsiMethodNames[method]);
}

//
//
//
//
//

double workRsi[][13];
#define _price  0
#define _change 1
#define _changa 2

double iRsi(double price, double period, int rsiMode, int i, int instanceNo=0)
{
   if (ArrayRange(workRsi,0)!=Bars) ArrayResize(workRsi,Bars);
      int z = instanceNo*13; 
      int r = Bars-i-1;
   
   //
   //
   //
   //
   //
   
   workRsi[r][z+_price] = price;
   switch (rsiMode)
   {
      case 0:
         double alpha = 1.0/period; 
         if (r<period)
            {
               int k; double sum = 0; for (k=0; k<period && (r-k-1)>=0; k++) sum += MathAbs(workRsi[r-k][z+_price]-workRsi[r-k-1][z+_price]);
                  workRsi[r][z+_change] = (workRsi[r][z+_price]-workRsi[0][z+_price])/MathMax(k,1);
                  workRsi[r][z+_changa] =                                         sum/MathMax(k,1);
            }
         else
            {
               double change = workRsi[r][z+_price]-workRsi[r-1][z+_price];
                               workRsi[r][z+_change] = workRsi[r-1][z+_change] + alpha*(        change  - workRsi[r-1][z+_change]);
                               workRsi[r][z+_changa] = workRsi[r-1][z+_changa] + alpha*(MathAbs(change) - workRsi[r-1][z+_changa]);
            }
         if (workRsi[r][z+_changa] != 0)
               return(50.0*(workRsi[r][z+_change]/workRsi[r][z+_changa]+1));
         else  return(50.0);
         
      //
      //
      //
      //
      //
      
      case 1 :
         workRsi[r][z+1] = iSmma(0.5*(MathAbs(workRsi[r][z+_price]-workRsi[r-1][z+_price])+(workRsi[r][z+_price]-workRsi[r-1][z+_price])),0.5*(period-1),Bars-i-1,instanceNo*2+0);
         workRsi[r][z+2] = iSmma(0.5*(MathAbs(workRsi[r][z+_price]-workRsi[r-1][z+_price])-(workRsi[r][z+_price]-workRsi[r-1][z+_price])),0.5*(period-1),Bars-i-1,instanceNo*2+1);
         if((workRsi[r][z+1] + workRsi[r][z+2]) != 0) 
               return(100.0 * workRsi[r][z+1]/(workRsi[r][z+1] + workRsi[r][z+2]));
         else  return(50);

      //
      //
      //
      //
      //
     
      case 2 :     
      double Kg = (3.0)/(2.0+period), Hg = 1.0-Kg;
      if (r<period) { for (k=1; k<13; k++) workRsi[r][k+z] = 0; return(50); }  

         //
         //
         //
         //
         //
      
         double mom = workRsi[r][_price+z]-workRsi[r-1][_price+z];
         double moa = MathAbs(mom);
         for (k=0; k<Depth; k++)
      {
         int kk = k*4;
            workRsi[r][kk+1] = Kg*mom                + Hg*workRsi[r-1][kk+1];
            workRsi[r][kk+2] = Kg*workRsi[r][kk+1] + Hg*workRsi[r-1][kk+2]; mom =         1.5*workRsi[r][kk+1] - Speed * workRsi[r][kk+2];
            workRsi[r][kk+3] = Kg*moa                + Hg*workRsi[r-1][kk+3];
            workRsi[r][kk+4] = Kg*workRsi[r][kk+3] + Hg*workRsi[r-1][kk+4]; moa = MathAbs(1.5*workRsi[r][kk+3] - Speed * workRsi[r][kk+4]);
      }
      if (moa != 0)
              return(MathMax(MathMin((mom/moa+1.0)*50.0,100.00),0.00)); 
         else return(50);
            
      //
      //
      //
      //
      //
      
      case 3 :
         double sump = 0;
         double sumn = 0;
         for (k=0; k<period; k++)
         {
            double diff = workRsi[r-k][z+_price]-workRsi[r-k-1][z+_price];
               if (diff > 0) sump += diff;
               if (diff < 0) sumn -= diff;
         }
         if (sumn > 0)
               return(100.0-100.0/(1.0+sump/sumn));
         else  return(50);
      }
}

//
//
//
//
//

double workSmma[][2];
double iSmma(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workSmma,0)!= Bars) ArrayResize(workSmma,Bars);

   //
   //
   //
   //
   //

   if (r<period)
         workSmma[r][instanceNo] = price;
   else  workSmma[r][instanceNo] = workSmma[r-1][instanceNo]+(price-workSmma[r-1][instanceNo])/period;
   return(workSmma[r][instanceNo]);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (!calculateValue && alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar] ==  1) doAlert(whichBar,"up");
         if (trend[whichBar] == -1) doAlert(whichBar,"down");
      }
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," TDI trend changed to ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"TDI"),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

void manageArrow(int i)
{
   if (ShowArrows)
   {
      deleteArrow(Time[i]);
      if (trend[i]!=trend[i+1])
      {
         if (trend[i] == 1) drawArrow(i,arrowsUpColor,241,false);
         if (trend[i] ==-1) drawArrow(i,arrowsDnColor,242,true);
      }
   }
}               

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = 3.0*iATR(NULL,0,20,i)/4.0;   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i]+gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i] -gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}
void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double wrk[][40];

#define bsmax  5
#define bsmin  6
#define volty  7
#define vsum   8
#define avolty 9

//
//
//
//
//

double iDSmooth(double price, double length, double phase, bool isDouble, int i, int s=0)
{
   if (isDouble)
         return (iSmooth(iSmooth(price,MathSqrt(length),phase,i,s),MathSqrt(length),phase,i,s+10));
   else  return (iSmooth(price,length,phase,i,s));
}

//
//
//
//
//

double iSmooth(double price, double length, double phase, int i, int s=0)
{
   if (length <=1) return(price);
   if (ArrayRange(wrk,0) != Bars) ArrayResize(wrk,Bars);
   
   int r = Bars-i-1; 
      if (r==0) { for(int k=0; k<7; k++) wrk[r][k+s]=price; for(; k<10; k++) wrk[r][k+s]=0; return(price); }

   //
   //
   //
   //
   //
   
      double len1   = MathMax(MathLog(MathSqrt(0.5*(length-1)))/MathLog(2.0)+2.0,0);
      double pow1   = MathMax(len1-2.0,0.5);
      double del1   = price - wrk[r-1][bsmax+s];
      double del2   = price - wrk[r-1][bsmin+s];
      double div    = 1.0/(10.0+10.0*(MathMin(MathMax(length-10,0),100))/100);
      int    forBar = MathMin(r,10);
	
         wrk[r][volty+s] = 0;
               if(MathAbs(del1) > MathAbs(del2)) wrk[r][volty+s] = MathAbs(del1); 
               if(MathAbs(del1) < MathAbs(del2)) wrk[r][volty+s] = MathAbs(del2); 
         wrk[r][vsum+s] =	wrk[r-1][vsum+s] + (wrk[r][volty+s]-wrk[r-forBar][volty+s])*div;
         
         //
         //
         //
         //
         //
   
         wrk[r][avolty+s] = wrk[r-1][avolty+s]+(2.0/(MathMax(4.0*length,30)+1.0))*(wrk[r][vsum+s]-wrk[r-1][avolty+s]);
            if (wrk[r][avolty+s] > 0)
               double dVolty = wrk[r][volty+s]/wrk[r][avolty+s]; else dVolty = 0;   
	               if (dVolty > MathPow(len1,1.0/pow1)) dVolty = MathPow(len1,1.0/pow1);
                  if (dVolty < 1)                      dVolty = 1.0;

      //
      //
      //
      //
      //
	        
   	double pow2 = MathPow(dVolty, pow1);
      double len2 = MathSqrt(0.5*(length-1))*len1;
      double Kv   = MathPow(len2/(len2+1), MathSqrt(pow2));

         if (del1 > 0) wrk[r][bsmax+s] = price; else wrk[r][bsmax+s] = price - Kv*del1;
         if (del2 < 0) wrk[r][bsmin+s] = price; else wrk[r][bsmin+s] = price - Kv*del2;
	
   //
   //
   //
   //
   //
      
      double R     = MathMax(MathMin(phase,100),-100)/100.0 + 1.5;
      double beta  = 0.45*(length-1)/(0.45*(length-1)+2);
      double alpha = MathPow(beta,pow2);

         wrk[r][0+s] = price + alpha*(wrk[r-1][0+s]-price);
         wrk[r][1+s] = (price - wrk[r][0+s])*(1-beta) + beta*wrk[r-1][1+s];
         wrk[r][2+s] = (wrk[r][0+s] + R*wrk[r][1+s]);
         wrk[r][3+s] = (wrk[r][2+s] - wrk[r-1][4+s])*MathPow((1-alpha),2) + MathPow(alpha,2)*wrk[r-1][3+s];
         wrk[r][4+s] = (wrk[r-1][4+s] + wrk[r][3+s]); 

   //
   //
   //
   //
   //

   return(wrk[r][4+s]);
}