//+--------------------------------------------------------------------------------------+
//|       :                                                                                   |
//+--------------------------------------------------------------------------------------+
#property copyright "AHP_2012"
#property link      "andreywin@i.ua"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 PaleVioletRed
#property indicator_width1 2
#property indicator_level1 0

#import "ahp_ass.dll"
   void fastSingular(double& sourceArray[],int arraySize, int lag, int numberOfComputationLoops, double& destinationArray[]);
#import

//
//
//
//
//

extern string TimeFrame               = "Current time frame";
extern int    SSAPrice                =  PRICE_CLOSE;
extern int    SSALag                  = 20;
extern int    SSANumberOfComputations =  2;
extern int    SSAPeriodNormalization  = 10;
extern int    SSANumberOfBars         = 500;
extern bool   Interpolate             = true;
extern bool   alertsOn                = false;
extern bool   alertsMessage           = false;
extern bool   alertsSound             = false;
extern bool   alertsEmail             = false;

//
//
//
//
//

double in[];
double no[];
double ssaIn[];
double ssaOut[];

//
//
//
//
//

int    timeFrame;
string indicatorFileName;
bool   returnBars;
bool   calculateValue;

//+--------------------------------------------------------------------------------------+
//|                                                                                      |
//+--------------------------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(2);
      SetIndexBuffer(0,in);
      SetIndexBuffer(1,no);
   
      //
      //
      //
      //
      //
      
         indicatorFileName = WindowExpertName();
         calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
         timeFrame         = stringToTimeFrame(TimeFrame);
      
      //
      //
      //
      //
      //
      
   IndicatorShortName(timeFrameToString(timeFrame)+" SSA normalized");
   return(0);
}
int deinit(){return(0);}

//+--------------------------------------------------------------------------------------+
//|                                                                                      |
//+--------------------------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int i,limit,counted_bars = IndicatorCounted();

      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);

   //
   //
   //
   //
   //
      
   if (calculateValue || timeFrame == Period())
   {
      int ssaBars = MathMin(Bars-1,SSANumberOfBars);
      for(i=limit; i>=0; i--)
      {
         double ma    = iMA(NULL,0,SSAPeriodNormalization,0,MODE_SMA,SSAPrice,i);
         double dev   = iStdDev(NULL,0,SSAPeriodNormalization,0,MODE_SMA,SSAPrice,i)*3.0;
         double price = iMA(NULL,0,1,0,MODE_SMA,SSAPrice,i);
                no[i] = (price-ma)/(MathMax(dev,0.000001));
      }                  
      if (ArraySize(ssaIn) != ssaBars)
      {
         ArrayResize(ssaIn ,ssaBars);
         ArrayResize(ssaOut,ssaBars);
      }
      ArrayCopy(ssaIn,no,0,0,ssaBars);
               fastSingular(ssaIn,ssaBars,SSALag,SSANumberOfComputations,ssaOut);
      ArrayCopy(in,ssaOut);
      manageAlerts();
      return(0); 
   }
   
   //
   //
   //
   //
   //
   
   limit = MathMin(Bars,SSANumberOfBars*timeFrame/Period());
   for (i=limit;i>=0;i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         in[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",SSAPrice,SSALag,SSANumberOfComputations,SSAPeriodNormalization,SSANumberOfBars,0,y);

         //
         //
         //
         //
         //
      
         if (!Interpolate || y==iBarShift(NULL,timeFrame,Time[i-1])) continue;

         //
         //
         //
         //
         //

         datetime time = iTime(NULL,timeFrame,y);
            for(int n = 1; i+n < Bars && Time[i+n] >= time; n++) continue;	
            double factor = 1.0 / n;
            for(int k = 1; k < n; k++) in[i+k] = k*factor*in[i+n] + (1.0-k*factor)*in[i];
   }
   manageAlerts();
   return(0);         
}


//+--------------------------------------------------------------------------------------+
//|                                                                                      |
//+--------------------------------------------------------------------------------------+
//
//
//
//
//

void manageAlerts()
{
   if (!calculateValue && alertsOn)
   {
      int whichBar = 0;
      int state    = 0;
         if (in[0]>0) state =  1;
         if (in[0]<0) state = -1;
         int newState = state;
            for (int i=0; i<SSANumberOfBars*timeFrame/Period(); i++) 
               {
                  if (in[i]>0 && state==-1) { newState =  1; break; }
                  if (in[i]<0 && state== 1) { newState = -1; break; }
               }

         //
         //
         //
         //
         //
         
         datetime atTime   = iTime(NULL,timeFrame,iBarShift(NULL,timeFrame,Time[i-1]));
                  whichBar = iBarShift(NULL,0,atTime);
   
      //
      //
      //
      //
      //

      if (newState != state)               
      {
         if (state ==  1) doAlert(whichBar,"up at "+TimeToStr(atTime,TIME_DATE|TIME_SECONDS));
         if (state == -1) doAlert(whichBar,"down at "+TimeToStr(atTime,TIME_DATE|TIME_SECONDS));
      }         
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," normalized ASS crossed zero line ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," normalized ASS "),message);
             if (alertsSound)   PlaySound("alert2.wav");
      }
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int char = StringGetChar(s, length);
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                     s = StringSetChar(s, length, char - 32);
         else if(char > -33 && char < 0)
                     s = StringSetChar(s, length, char + 224);
   }
   return(s);
}