//+------------------------------------------------------------------+
//|                                    Traders Dynamic Index.mq4     |
//|                                    Copyright  2006, Dean Malone |
//|                                    www.compassfx.com             |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                                                  |
//|                     Traders Dynamic Index                        |
//|                                                                  |
//|  This hybrid indicator is developed to assist traders in their   |
//|  ability to decipher and monitor market conditions related to    |
//|  trend direction, market strength, and market volatility.        |
//|                                                                  | 
//|  Even though comprehensive, the T.D.I. is easy to read and use.  |
//|                                                                  |
//|  Green line = RSI Price line                                     |
//|  Red line = Trade Signal line                                    |
//|  Blue lines = Volatility Band                                    | 
//|  Yellow line = Market Base Line                                  |  
//|                                                                  |
//|  Trend Direction - Immediate and Overall                         |
//|   Immediate = Green over Red...price action is moving up.        |
//|               Red over Green...price action is moving down.      |
//|                                                                  |   
//|   Overall = Yellow line trends up and down generally between the |
//|             lines 32 & 68. Watch for Yellow line to bounces off  |
//|             these lines for market reversal. Trade long when     |
//|             price is above the Yellow line, and trade short when |
//|             price is below.                                      |        
//|                                                                  |
//|  Market Strength & Volatility - Immediate and Overall            |
//|   Immediate = Green Line - Strong = Steep slope up or down.      | 
//|                            Weak = Moderate to Flat slope.        |
//|                                                                  |               
//|   Overall = Blue Lines - When expanding, market is strong and    |
//|             trending. When constricting, market is weak and      |
//|             in a range. When the Blue lines are extremely tight  |                                                       
//|             in a narrow range, expect an economic announcement   | 
//|             or other market condition to spike the market.       |
//|                                                                  |               
//|                                                                  |
//|  Entry conditions                                                |
//|   Scalping  - Long = Green over Red, Short = Red over Green      |
//|   Active - Long = Green over Red & Yellow lines                  |
//|            Short = Red over Green & Yellow lines                 |    
//|   Moderate - Long = Green over Red, Yellow, & 50 lines           |
//|              Short= Red over Green, Green below Yellow & 50 line |
//|                                                                  |
//|  Exit conditions*                                                |   
//|   Long = Green crosses below Red                                 |
//|   Short = Green crosses above Red                                |
//|   * If Green crosses either Blue lines, consider exiting when    |
//|     when the Green line crosses back over the Blue line.         |
//|                                                                  |
//|                                                                  |
//|  IMPORTANT: The default settings are well tested and proven.     |
//|             But, you can change the settings to fit your         |
//|             trading style.                                       |
//|                                                                  |
//|                                                                  |
//|  Price & Line Type settings:                           |                
//|   RSI Price settings                                             |               
//|   0 = Close price     [DEFAULT]                                  |               
//|   1 = Open price.                                                |               
//|   2 = High price.                                                |               
//|   3 = Low price.                                                 |               
//|   4 = Median price, (high+low)/2.                                |               
//|   5 = Typical price, (high+low+close)/3.                         |               
//|   6 = Weighted close price, (high+low+close+close)/4.            |               
//|                                                                  |               
//|   RSI Price Line & Signal Line Type settings                                   |               
//|   0 = Simple moving average       [DEFAULT]                      |               
//|   1 = Exponential moving average                                 |               
//|   2 = Smoothed moving average                                    |               
//|   3 = Linear weighted moving average                             |               
//|                                                                  |
//|   Good trading,                                                  |   
//|                                                                  |
//|   Dean                                                           |                              
//+------------------------------------------------------------------+



#property indicator_buffers 6
#property indicator_color1 Black
#property indicator_color2 MediumBlue
#property indicator_color3 Yellow
#property indicator_color4 MediumBlue
#property indicator_color5 Green
#property indicator_color6 Red
#property indicator_separate_window

//
//
//
//
//

extern int RSI_Period          = 25;         
extern int RSI_Price           = 0;           
extern int Volatility_Band     = 34;    
extern int RSI_Price_Line      = 2;      
extern int RSI_Price_Type      = 0;      
 


extern int SSAPrice                =  PRICE_CLOSE;
extern int SSANumberOfComputations =   3;
extern int SSAPeriodNormalization  = 10;
extern int SSANumberOfBars         = 300;
extern int FirstBar                = 300; 

extern string note             = "turn on Alert = true; turn off = false";
extern bool   alertsOn         = true;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = true;
extern bool   alertsEmail      = false;
extern string soundfile        = "alert2.wav";

extern string  __              = "arrows settings";
extern bool   ShowArrows       = true; 
extern string ArrowsIdentifier = "tdiarrows";
extern color  ArrowUpColor     = Aqua;
extern color  ArrowDownColor   = Red; 
extern int    ArrowUpWidth     = 1; 
extern int    ArrowDownWidth   = 1; 

//
//
//
//
//

double RSIBuf[],UpZone[],MdZone[],DnZone[],MaBuf[],MbBuf[];
double trend[];
double atrend[];

//
//
//
//
//

int init()
  {
   IndicatorShortName("Traders Dynamic Index SSAep sharp Alerts ");
   IndicatorBuffers(8);
   SetIndexBuffer(0,RSIBuf);
   SetIndexBuffer(1,UpZone);
   SetIndexBuffer(2,MdZone);
   SetIndexBuffer(3,DnZone);
   SetIndexBuffer(4,MaBuf);
   SetIndexBuffer(5,MbBuf);
   SetIndexBuffer(6,trend);
   SetIndexBuffer(7,atrend);
   
   SetIndexStyle(0,DRAW_NONE); 
   SetIndexStyle(1,DRAW_LINE); 
   SetIndexStyle(2,DRAW_LINE,0,2);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexStyle(4,DRAW_LINE,0,2);
   SetIndexStyle(5,DRAW_LINE,0,2);
   
   SetIndexLabel(0,NULL); 
   SetIndexLabel(1,"VB High"); 
   SetIndexLabel(2,"Market Base Line"); 
   SetIndexLabel(3,"VB Low"); 
   SetIndexLabel(4,"RSI Price Line");
   SetIndexLabel(5,"Trade Signal Line");
 
   SetLevelValue(0,50);
   SetLevelValue(1,68);
   SetLevelValue(2,32);
   SetLevelStyle(STYLE_DOT,1,DimGray);
   
   return(0);
  }
  
  int deinit()
{
   if (ShowArrows)
   {
      int compareLength = StringLen(ArrowsIdentifier);
      for (int i=ObjectsTotal(); i>= 0; i--)
      {
         string name = ObjectName(i);
            if (StringSubstr(name,0,compareLength) == ArrowsIdentifier)
                ObjectDelete(name);  
      }
   }
   return(0);
}

int start()
  {
   double MA,RSI[];
   ArrayResize(RSI,Volatility_Band);
   int counted_bars=IndicatorCounted();
   int limit = Bars-counted_bars-1;
   for(int i=limit; i>=0; i--)
   {
      RSIBuf[i] = iCustom(Symbol(),Period(),"SSA normalized end-pointed",SSAPrice,RSI_Period,SSANumberOfComputations,SSAPeriodNormalization,SSANumberOfBars,FirstBar,0,i);
      MA = 0;
      for(int x=i; x<i+Volatility_Band; x++) {
         RSI[x-i] = RSIBuf[x];
         MA += RSIBuf[x]/Volatility_Band;
      }
      UpZone[i] = (MA + (1.6185 * StDev(RSI,Volatility_Band)));
      DnZone[i] = (MA - (1.6185 * StDev(RSI,Volatility_Band)));  
      MdZone[i] = ((UpZone[i] + DnZone[i])/2);
      }
   for (i=limit-1;i>=0;i--)  
      {
       MaBuf[i] = (iMAOnArray(RSIBuf,0,RSI_Price_Line,0,RSI_Price_Type,i));
       MbBuf[i] = (iMAOnArray(RSIBuf,0,RSI_Price_Line,0,RSI_Price_Type,i+1)); 
       trend[i] = trend[i+i];
       manageArrow(i);
       
       if (MaBuf[i] > MbBuf[i] && MaBuf[i+1] <= MbBuf[i+1]) trend[i] =  1;
       if (MaBuf[i] < MbBuf[i] && MaBuf[i+1] >= MbBuf[i+1]) trend[i] = -1;  
       }
       
       //
       //
       //
       //
       //
        
       if (alertsOn)
       {
       if (alertsOnCurrent)
            int whichBar = 0;
       else     whichBar = 1;

         //
         //
         //
         //
         //
         
         if (trend[whichBar] != trend[whichBar+1])
         if (trend[whichBar] == 1)
               doAlert("uptrend");
         else  doAlert("downtrend");       
   }
   
   return(0);
}
//+------------------------------------------------------------------+


void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," TDI ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," TDI "),message);
             if (alertsSound)   PlaySound(soundfile);
      }
}

//
//
//
//
//

void manageArrow(int i)
{
   if (ShowArrows)
   {
      double dist = iATR(NULL,0,20,i)/2.0;
      ObjectDelete(ArrowsIdentifier+Time[0]);         
            
      //
      //
      //
      //
      //
           
      atrend[i] = atrend[i+1];
         if (MaBuf[i] > MbBuf[i] && MaBuf[i+1] <= MbBuf[i+1]) atrend[i] =  1;
         if (MaBuf[i] < MbBuf[i] && MaBuf[i+1] >= MbBuf[i+1]) atrend[i] = -1;
         if (atrend[i] !=atrend[i+1])
         {
            string name = ArrowsIdentifier+Time[i];
            if (atrend[i] == 1)
            {
               ObjectCreate(name,OBJ_ARROW,0, Time[i],Low[i]-dist );
                  ObjectSet(name,OBJPROP_ARROWCODE,225);
                  ObjectSet(name,OBJPROP_COLOR,ArrowUpColor);
                  ObjectSet(name,OBJPROP_WIDTH,ArrowUpWidth);
            }
            else
            {
               ObjectCreate(name,OBJ_ARROW,0, Time[i],High[i]+dist );
                  ObjectSet(name,OBJPROP_ARROWCODE,226);
                  ObjectSet(name,OBJPROP_COLOR,ArrowDownColor);
                  ObjectSet(name,OBJPROP_WIDTH,ArrowDownWidth);
            }
         }
   }
}

//
//
//
//
//

double StDev(double& Data[], int Per)
{
return(MathSqrt(Variance(Data,Per)));

}

double Variance(double& Data[], int Per)
{
double sum, ssum;
  for (int i=0; i<Per; i++)
  {
  sum  += Data[i];
  ssum += MathPow(Data[i],2);
  }
  return((ssum*Per - sum*sum)/(Per*(Per-1)));
}
//+------------------------------------------------------------------+