//+------------------------------------------------------------------+
//|                                                    STC_COLOR.mq4 |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1  Silver
#property indicator_color6  Lime
#property indicator_color7  Red
#property indicator_width1 2
#property indicator_width6 2
#property indicator_width7 2
//+------------------------------------------------------------------+
#property indicator_level1 90
#property indicator_level2 10
#property indicator_levelstyle DRAW_LINE
#property indicator_levelcolor MediumBlue
//+------------------------------------------------------------------+
extern int    STCPeriod    = 10;
extern int    FastMAPeriod = 23;
extern int    SlowMAPeriod = 50;
//+------------------------------------------------------------------+
double stcBuffer[];
double macdBuffer[];
double fastKBuffer[];
double fastDBuffer[];
double fastKKBuffer[];
double Upper[];
double Lower[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   IndicatorBuffers(7);
   SetIndexBuffer(0,stcBuffer);
   SetIndexBuffer(1,macdBuffer);
   SetIndexBuffer(2,fastKBuffer);
   SetIndexBuffer(3,fastDBuffer);
   SetIndexBuffer(4,fastKKBuffer);
   SetIndexBuffer(5,Upper);
   SetIndexBuffer(6,Lower);
   
   SetIndexStyle(1,DRAW_NONE);
   SetIndexStyle(2,DRAW_NONE);
   SetIndexStyle(3,DRAW_NONE);
   SetIndexStyle(4,DRAW_NONE);
   SetIndexStyle(5,DRAW_LINE, EMPTY, 2);
   SetIndexStyle(6,DRAW_LINE, EMPTY, 2);
   
   IndicatorShortName("STC_COLOR("+STCPeriod+","+FastMAPeriod+","+SlowMAPeriod+")");
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+

int deinit()
{
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int start()
{
   int counted_bars=IndicatorCounted();
   int limit,i;

   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
//+------------------------------------------------------------------+       
      limit = Bars-counted_bars;
  
      for(i = limit; i >= 0; i--)
      {
         macdBuffer[i] = iMA(NULL,0,FastMAPeriod,0,MODE_EMA,PRICE_CLOSE,i)-
                         iMA(NULL,0,SlowMAPeriod,0,MODE_EMA,PRICE_CLOSE,i);
//+------------------------------------------------------------------+         
         double lowMacd  = minValue(macdBuffer,i);
         double highMacd = maxValue(macdBuffer,i)-lowMacd;
            if (highMacd > 0)
                  fastKBuffer[i] = 100*((macdBuffer[i]-lowMacd)/highMacd);
            else  fastKBuffer[i] = fastKBuffer[i+1];
                  fastDBuffer[i] = fastDBuffer[i+1]+0.5*(fastKBuffer[i]-fastDBuffer[i+1]);
//+------------------------------------------------------------------+                     
         double lowStoch  = minValue(fastDBuffer,i);
         double highStoch = maxValue(fastDBuffer,i)-lowStoch;
            if (highStoch > 0)
                  fastKKBuffer[i] = 100*((fastDBuffer[i]-lowStoch)/highStoch);
            else  fastKKBuffer[i] = fastKKBuffer[i+1];
                  stcBuffer[i]    = stcBuffer[i+1]+0.5*(fastKKBuffer[i]-stcBuffer[i+1]);
      }
//+------------------------------------------------------------------+   
   for(i = limit; i >= 0; i--)
   {
   if (stcBuffer[i] > stcBuffer[i+1]) { Upper[i] = stcBuffer[i]; Upper[i+1] = stcBuffer[i+1]; }
               else                       { Upper[i] = EMPTY_VALUE;
                                            if (Upper[i+2] == EMPTY_VALUE)
                                                Upper[i+1]  = EMPTY_VALUE; }
               if (stcBuffer[i] < stcBuffer[i+1])   { Lower[i] = stcBuffer[i]; Lower[i+1] = stcBuffer[i+1]; }
               else                       { Lower[i] = EMPTY_VALUE;
                                            if (Lower[i+2] == EMPTY_VALUE)
                                                Lower[i+1]  = EMPTY_VALUE; }
    }  
//+------------------------------------------------------------------+
        
      return(0);
}

//+------------------------------------------------------------------+
//| ...                                          |
//+------------------------------------------------------------------+

double minValue(double& array[],int shift)
{
   double minValue = array[shift];
            for (int i=1; i<STCPeriod; i++) minValue = MathMin(minValue,array[shift+i]);
   return(minValue);
}
double maxValue(double& array[],int shift)
{
   double maxValue = array[shift];
            for (int i=1; i<STCPeriod; i++) maxValue = MathMax(maxValue,array[shift+i]);
   return(maxValue);
}