//+------------------------------------------------------------------+
//|                                               VolatilityLine.mq4 |
//|                                                                  |
//|                                                      By KumaKuma |
//+------------------------------------------------------------------+
// V.1.0.0 2010.05.16
//    First release
//
#property copyright ""
#property link      "http://gp7g73hp.seesaa.net/"
#property indicator_chart_window

extern double Percent = 0.1;
//extern color UpperVolatilityLineLineColor4 = Blue;
extern color UpperVolatilityLineLineColor3 = DeepSkyBlue;
extern color UpperVolatilityLineLineColor2 = PaleTurquoise;
extern color UpperVolatilityLineLineColor1 = LightCyan;
extern color LowerVolatilityLineLineColor1 = MistyRose;
extern color LowerVolatilityLineLineColor2 = Pink;
extern color LowerVolatilityLineLineColor3 = HotPink;
//extern color LowerVolatilityLineLineColor4 = Red;
color LabelColor = White;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   double bid   =MarketInfo(Symbol(),MODE_BID);
   
   ObjectCreate("VolatilityLineRect1", OBJ_RECTANGLE, 0, Time[0], bid * (1 - Percent), Time[Bars], bid * (1 + Percent));
   ObjectSet("VolatilityLineRect1",OBJPROP_COLOR,C'60,60,60');

   ObjectCreate("VolatilityLineLineA1", OBJ_HLINE, 0, 0, 0, 0, 0);
   ObjectSet("VolatilityLineLineA1",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineA1",OBJPROP_COLOR,LowerVolatilityLineLineColor1);
   ObjectSet("VolatilityLineLineA1", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineA1", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineA1", OBJPROP_RAY, false);

   ObjectCreate("VolatilityLineLineA2", OBJ_HLINE, 0, 0, 0, 0 ,0);
   ObjectSet("VolatilityLineLineA2",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineA2",OBJPROP_COLOR,UpperVolatilityLineLineColor1);
   ObjectSet("VolatilityLineLineA2", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineA2", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineA2", OBJPROP_RAY, false);

   ObjectCreate("VolatilityLineLineB1", OBJ_HLINE, 0, 0, 0, 0, 0);
   ObjectSet("VolatilityLineLineB1",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineB1",OBJPROP_COLOR,LowerVolatilityLineLineColor2);
   ObjectSet("VolatilityLineLineB1", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineB1", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineB1", OBJPROP_RAY, false);

   ObjectCreate("VolatilityLineLineB2", OBJ_HLINE, 0, 0, 0, 0 ,0);
   ObjectSet("VolatilityLineLineB2",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineB2",OBJPROP_COLOR,UpperVolatilityLineLineColor2);
   ObjectSet("VolatilityLineLineB2", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineB2", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineB2", OBJPROP_RAY, false);


   ObjectCreate("VolatilityLineLineC1", OBJ_HLINE, 0, 0, 0, 0, 0);
   ObjectSet("VolatilityLineLineC1",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineC1",OBJPROP_COLOR,LowerVolatilityLineLineColor3);
   ObjectSet("VolatilityLineLineC1", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineC1", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineC1", OBJPROP_RAY, false);

   ObjectCreate("VolatilityLineLineC2", OBJ_HLINE, 0, 0, 0, 0 ,0);
   ObjectSet("VolatilityLineLineC2",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineC2",OBJPROP_COLOR,UpperVolatilityLineLineColor3);
   ObjectSet("VolatilityLineLineC2", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineC2", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineC2", OBJPROP_RAY, false);
/*
   ObjectCreate("VolatilityLineLineD1", OBJ_HLINE, 0, 0, 0, 0, 0);
   ObjectSet("VolatilityLineLineD1",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineD1",OBJPROP_COLOR,LowerVolatilityLineLineColor4);
   ObjectSet("VolatilityLineLineD1", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineA2", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineA2", OBJPROP_RAY, false);

   ObjectCreate("VolatilityLineLineD2", OBJ_HLINE, 0, 0, 0, 0 ,0);
   ObjectSet("VolatilityLineLineD2",OBJPROP_STYLE,STYLE_DOT);
   ObjectSet("VolatilityLineLineD2",OBJPROP_COLOR,UpperVolatilityLineLineColor4);
   ObjectSet("VolatilityLineLineD2", OBJPROP_BACK, true);
   ObjectSet("VolatilityLineLineD2", OBJPROP_ELLIPSE, false);
   ObjectSet("VolatilityLineLineD2", OBJPROP_RAY, false);
*/
   ObjectSetText("VolatilityLineLineA1", "-" + DoubleToStr(Percent *   1, 2) + "%", 11, "Courier New", LabelColor);
   ObjectSetText("VolatilityLineLineA2", "+" + DoubleToStr(Percent *   1, 2) + "%", 11, "Courier New", LabelColor);
   ObjectSetText("VolatilityLineLineB1", "-" + DoubleToStr(Percent *  10, 2) + "%", 11, "Courier New", LabelColor);
   ObjectSetText("VolatilityLineLineB2", "+" + DoubleToStr(Percent *  10, 2) + "%", 11, "Courier New", LabelColor);
   ObjectSetText("VolatilityLineLineC1", "-" + DoubleToStr(Percent * 100, 2) + "%", 11, "Courier New", LabelColor);
   ObjectSetText("VolatilityLineLineC2", "+" + DoubleToStr(Percent * 100, 2) + "%", 11, "Courier New", LabelColor);
//   ObjectSetText("VolatilityLineLineD1", "-" + DoubleToStr(Percent * 200, 2) + "%", 11, "Courier New", LabelColor);
//   ObjectSetText("VolatilityLineLineD2", "+" + DoubleToStr(Percent * 200, 2) + "%", 11, "Courier New", LabelColor);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {

   ObjectDelete("VolatilityLineRect1");
   ObjectDelete("VolatilityLineLineA1");
   ObjectDelete("VolatilityLineLineA2");
   ObjectDelete("VolatilityLineLineB1");
   ObjectDelete("VolatilityLineLineB2");
   ObjectDelete("VolatilityLineLineC1");
   ObjectDelete("VolatilityLineLineC2");
//   ObjectDelete("VolatilityLineLineD1");
//   ObjectDelete("VolatilityLineLineD2");

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   double bid = MarketInfo(Symbol(),MODE_BID);
   double ask = MarketInfo(Symbol(),MODE_ASK);

   ObjectSet("VolatilityLineRect1", OBJPROP_PRICE1, bid * (1 - Percent /100 *   1) );
   ObjectSet("VolatilityLineRect1", OBJPROP_PRICE2, bid * (1 + Percent /100 *   1) );
   ObjectSet("VolatilityLineRect1", OBJPROP_TIME1, Time[0]);
   ObjectSet("VolatilityLineRect1", OBJPROP_TIME2, Time[Bars-1]);

   ObjectSet("VolatilityLineLineA1", OBJPROP_PRICE1, bid * (1 - Percent / 100 *   1) );
   ObjectSet("VolatilityLineLineA2", OBJPROP_PRICE1, bid * (1 + Percent / 100 *   1) );

   ObjectSet("VolatilityLineLineB1", OBJPROP_PRICE1, bid * (1 - Percent / 100 *  10) );
   ObjectSet("VolatilityLineLineB2", OBJPROP_PRICE1, bid * (1 + Percent / 100 *  10) );
      
   ObjectSet("VolatilityLineLineC1", OBJPROP_PRICE1, bid * (1 - Percent / 100 * 100) );
   ObjectSet("VolatilityLineLineC2", OBJPROP_PRICE1, bid * (1 + Percent / 100 * 100) );
//   ObjectSet("VolatilityLineLineD1", OBJPROP_PRICE1, bid * (1 - Percent / 100 * 200) );
//   ObjectSet("VolatilityLineLineD2", OBJPROP_PRICE1, bid * (1 + Percent / 100 * 200) );

//----
   return(0);
  }
//+------------------------------------------------------------------+