//+------------------------------------------------------------------+
//|                                                    Asymmetry.mq5 |
//|                                  Copyright  2008, Fedor Igumnov |
//|                                           igumnovfedor@yandex.ru |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2008,Fedor Igumnov"
//----    
#property link      "igumnovfedor@yandex.ru"
#property description " "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    1
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1 DRAW_LINE
//----      MediumSlateBlue 
#property indicator_color1 clrMediumSlateBlue
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "Asymmetry"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint AsPeriod=30; //  
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtLineBuffer[];
//----      
int RSI_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    RSI
   RSI_Handle=iRSI(NULL,PERIOD_CURRENT,AsPeriod,PRICE_CLOSE);
   if(RSI_Handle==INVALID_HANDLE)Print("      iRSI");
//----     
   min_rates_total=int(AsPeriod);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----      
   string shortname;
   StringConcatenate(shortname,"Asymmetry(",AsPeriod," ",Shift,")");
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(ExtLineBuffer,true);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(RSI_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar,i;
   double RSI[],M,D,MD,stdDev;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----
   to_copy=int(limit+1+AsPeriod);
//----      
   if(CopyBuffer(RSI_Handle,0,0,to_copy,RSI)<=0) return(RESET);
//----         
   ArraySetAsSeries(RSI,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      M=0.0;
      D=0.0;
      MD=0.0;
      //----
      for(i=0; i<int(AsPeriod); i++) M+=RSI[bar+i];
      M/=AsPeriod;
      for(i=0; i<int(AsPeriod); i++) D+=MathPow(RSI[bar+i]-M,2);
      D/=AsPeriod;
      stdDev=MathSqrt(D);
      for(i=0; i<int(AsPeriod); i++) MD+=MathPow(RSI[bar+i]-D,2);
      MD/=AsPeriod;
      ExtLineBuffer[bar]=MathAbs(MD/(D*stdDev));
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
