//+------------------------------------------------------------------+
//|                                                     AtrRange.mq5 | 
//|                                         Copyright  2011, raxxla | 
//|                                         http://www.cmetrading.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, raxxla"
#property link "http://www.cmetrading.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    3
#property indicator_buffers 3 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_ARROW
//----       Blue 
#property indicator_color1 clrBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "HiRange"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        Red 
#property indicator_color2  clrRed
//----    2  3
#property indicator_width2  3
//----   
#property indicator_label2  "LoRange"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        Goldw 
#property indicator_color3  clrGold
//----    3  2
#property indicator_width3 3 
//----   
#property indicator_label3  "MultiRange"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint  MaxRange=25;
input int   Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double HiRangeBuffer[];
double LoRangeBuffer[];
double MRangeBuffer[];
//----      
int ATR_Handle[5];
//----      
int min_rates_total,Atr_Start,Atr_Step,MA,pt;
double ATR1[],ATR2[],ATR3[],ATR4[],ATR5[];
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   Atr_Start=3;
   Atr_Step=2;
   MA=14;
   pt=1;
   if(_Digits==5 || _Digits==3) pt=10;
   min_rates_total=Atr_Start+Atr_Step*5+3+MA;
//----    ATR1
   ATR_Handle[0]=iATR(NULL,PERIOD_CURRENT,Atr_Start+Atr_Step*1);
   if(ATR_Handle[0]==INVALID_HANDLE)
     {
      Print("      ATR1");
      return(INIT_FAILED);
     }
//----    ATR2
   ATR_Handle[1]=iATR(NULL,PERIOD_CURRENT,Atr_Start+Atr_Step*2);
   if(ATR_Handle[1]==INVALID_HANDLE)
     {
      Print("      ATR2");
      return(INIT_FAILED);
     }
//----    ATR3
   ATR_Handle[2]=iATR(NULL,PERIOD_CURRENT,Atr_Start+Atr_Step*3);
   if(ATR_Handle[2]==INVALID_HANDLE)
     {
      Print("      ATR3");
      return(INIT_FAILED);
     }
//----    ATR4
   ATR_Handle[3]=iATR(NULL,PERIOD_CURRENT,Atr_Start+Atr_Step*4);
   if(ATR_Handle[3]==INVALID_HANDLE)
     {
      Print("      ATR4");
      return(INIT_FAILED);
     }
//----    ATR5
   ATR_Handle[4]=iATR(NULL,PERIOD_CURRENT,Atr_Start+Atr_Step*5);
   if(ATR_Handle[4]==INVALID_HANDLE)
     {
      Print("      ATR5");
      return(INIT_FAILED);
     }

//----        
   ArraySetAsSeries(ATR1,true);
   ArraySetAsSeries(ATR2,true);
   ArraySetAsSeries(ATR3,true);
   ArraySetAsSeries(ATR4,true);
   ArraySetAsSeries(ATR5,true);

//----      
   SetIndexBuffer(0,HiRangeBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(HiRangeBuffer,true);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,159);

//----      
   SetIndexBuffer(1,LoRangeBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(LoRangeBuffer,true);
//----    1    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,159);

//----      
   SetIndexBuffer(2,MRangeBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(MRangeBuffer,true);
//----    2    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//----   
   PlotIndexSetInteger(2,PLOT_ARROW,162);

//----      
   string shortname;
   StringConcatenate(shortname,"AtrRange(",MaxRange,", ",Shift,")");
//----          
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----    
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---- 
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle[0])<rates_total
      || BarsCalculated(ATR_Handle[1])<rates_total
      || BarsCalculated(ATR_Handle[2])<rates_total
      || BarsCalculated(ATR_Handle[3])<rates_total
      || BarsCalculated(ATR_Handle[4])<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----    
   int to_copy,limit,bar;
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----         limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//---
   to_copy=limit+1;
//----      
   if(CopyBuffer(ATR_Handle[0],0,0,to_copy+1,ATR1)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle[1],0,0,to_copy,ATR2)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle[2],0,0,to_copy+MA,ATR3)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle[3],0,0,to_copy,ATR4)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle[4],0,0,to_copy,ATR5)<=0) return(RESET);
//----   
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(AtrRange(bar,MaxRange*pt,high,low))
        {
         HiRangeBuffer[bar]=high[bar]+_Point*3;
         LoRangeBuffer[bar]=low[bar]-_Point*3;
        }
      else
        {
         HiRangeBuffer[bar]=0.0;
         LoRangeBuffer[bar]=0.0;
        }
      //---
      if(AtrBreakIn(bar,high,low)) MRangeBuffer[bar]=(high[bar]+low[bar])/2;
      else MRangeBuffer[bar]=0.0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  AtrBreakIn()                                                    |
//+------------------------------------------------------------------+
bool AtrBreakIn(int index,const double &High[],const double &Low[])
  {
   double vlt1 = (High[index]-Low[index])/_Point+_Point;
   double vlt2 = (High[index+1]-Low[index+1])/_Point+_Point;
//----
   if((vlt1/vlt2)>1.5) return false;
//----
   double max = MathMax(ATR2[index], MathMax(ATR3[index], MathMax(ATR4[index], ATR5[index])));
   double min = MathMin(ATR2[index], MathMin(ATR3[index], MathMin(ATR4[index], ATR5[index])));
   double summ=0.0;
   for(int iii=0; iii<MA; iii++) summ+=ATR3[index+iii];
   double atrMa3=summ/MA;
//----
   if(max>atrMa3) return false;
//----
   if((max-min)/_Point>25*pt) return false;
//----
   double atr1=ATR1[index];
//----
   if(atr1<min || atr1>atrMa3) return false;
//----
   if(atr1<ATR1[index+1]) return false;
//----
   if(atr1>=ATR5[index]) return false;
//----
   return true;
  }
//+------------------------------------------------------------------+
//| AtrRange()                                                       |
//+------------------------------------------------------------------+
bool AtrRange(int index,int maxRange,const double &High[],const double &Low[])
  {
//----
   double vlt1 = (High[index]-Low[index])/_Point+_Point;
   double vlt2 = (High[index+1]-Low[index+1])/_Point+_Point;
   double vlt3 = (High[index+2]-Low[index+2])/_Point+_Point;
//---
   if(vlt1>maxRange) return false;
//---
   if((vlt3/vlt2)>1.8) return false;
//---
   if(vlt1>vlt2 || vlt2>vlt3 || vlt1>vlt3) return false;
//---
   if(High[index]-High[index+1]>_Point) return false;
//---
   if(High[index+1]-High[index+2]>_Point) return false;
//---
   if(Low[index+1]-Low[index]>_Point) return false;
//---
   if(Low[index+2]-Low[index+1]>_Point) return false;
//----
   return true;
  }
//+------------------------------------------------------------------+
