//+------------------------------------------------------------------+
//|                                          ATR Value Indicator.mq5 |
//|                                    Copyright 2018, Hossein Nouri |
//|                           https://www.mql5.com/en/users/hsnnouri |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, Hossein Nouri"
#property description "Fully Coded By Hossein Nouri"
#property description "Email : hsn.nouri@gmail.com"
#property description "Skype : hsn.nouri"
#property description "Website : http://www.metatraderprogrammer.ir"
#property description "MQL5 Profile : https://www.mql5.com/en/users/hsnnouri"
#property description " "
#property description "Feel free to contact me for MQL4/MQL5 coding."
#property link      "https://www.mql5.com/en/users/hsnnouri"
#property version   "1.00"
#property indicator_chart_window

#define OBJPATTERN "ATRVI_"
//--- input parameters
enum ENUM_Value_Type
  {
   Points=0,
   Pips=1,
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_CORNER
  {
   LEFT_UPPER,// Left Upper
   LEFT_LOWER,// Left Lower
   RIGHT_UPPER,// Right Upper
   RIGHT_LOWER,// Right Lower
  };
input ENUM_Value_Type   InpDisplay        = 0;                                // Display Mode
input string            Desc1             = "========== ATR ==========";      // Description
input int               InpATRPeriod      = 14;                               // ATR Period
input ENUM_TIMEFRAMES   InpATRTimeframe   = PERIOD_CURRENT;                   // ATR Timeframe
input double            InpMultiplier     = 2.0;                              // Multiplier
input string            Desc2             = "========= Style =========";      // Description
input ENUM_CORNER       InpTextCorner     = RIGHT_UPPER;                      // Text Corner
input int               InpOffsetX        = 30;                               // Offset X
input int               InpOffsetY        = 30;                               // Offset Y
input color             InpTextColor      = clrRed;                           // Text Color
input int               InpTextFontSize   = 10;                               // Text Font Size



//+------------------------------------------------------------------+
//| Global Variables                                                 |
//+------------------------------------------------------------------+
int                  ATRHandle;
double               ATRBuffer[];
ENUM_BASE_CORNER     TextCorner;
ENUM_ANCHOR_POINT    TextAnchor;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   ATRHandle=iATR(_Symbol,InpATRTimeframe,InpATRPeriod);
   ArraySetAsSeries(ATRBuffer,true);
   SetTextPosition();
//---
   return(INIT_SUCCEEDED);
  }
void OnDeinit(const int reason)
  {
   ObjectsDeleteAll(0,OBJPATTERN);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   DisplayATR();
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
void DisplayATR()
  {
   if(CopyBuffer(ATRHandle,0,0,2,ATRBuffer)<=0)
     {
      Print("Getting ATR failed! Error",GetLastError());
      return;
     }
   double ATR=(ATRBuffer[0] *InpMultiplier)*MathPow(10,_Digits-InpDisplay);
   string Text=(string)(InpMultiplier*100)+"% of ATR ("+(string)InpATRPeriod+") : "+DoubleToString(ATR,0)+" "+EnumToString(InpDisplay);
   DrawLabel("ATR",Text);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DrawLabel(string name,string text)
  {
   name = OBJPATTERN+name;
   int chart_ID=0;
   if(!ObjectCreate(chart_ID,name,OBJ_LABEL,0,0,0))
     {
      ObjectSetString(chart_ID,name,OBJPROP_TEXT,text);
      return;
     }
   ObjectSetInteger(chart_ID,name,OBJPROP_XDISTANCE,InpOffsetX);
   ObjectSetInteger(chart_ID,name,OBJPROP_YDISTANCE,InpOffsetY);
   ObjectSetInteger(chart_ID,name,OBJPROP_CORNER,TextCorner);
   ObjectSetString(chart_ID,name,OBJPROP_TEXT,text);
   ObjectSetString(chart_ID,name,OBJPROP_FONT,"Arial");
   ObjectSetInteger(chart_ID,name,OBJPROP_FONTSIZE,InpTextFontSize);
   ObjectSetDouble(chart_ID,name,OBJPROP_ANGLE,0);
   ObjectSetInteger(chart_ID,name,OBJPROP_ANCHOR,TextAnchor);
   ObjectSetInteger(chart_ID,name,OBJPROP_COLOR,InpTextColor);
   ObjectSetInteger(chart_ID,name,OBJPROP_BACK,false);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTABLE,false);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTED,false);
   ObjectSetInteger(chart_ID,name,OBJPROP_HIDDEN,true);
   ObjectSetInteger(chart_ID,name,OBJPROP_ZORDER,0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetTextPosition()
  {
   if(InpTextCorner==LEFT_UPPER)
     {
      TextCorner=CORNER_LEFT_UPPER;
      TextAnchor=ANCHOR_LEFT_UPPER;
     }
   else if(InpTextCorner==LEFT_LOWER)
     {
      TextCorner=CORNER_LEFT_LOWER;
      TextAnchor=ANCHOR_LEFT_LOWER;
     }
   else if(InpTextCorner==RIGHT_UPPER)
     {
      TextCorner=CORNER_RIGHT_UPPER;
      TextAnchor=ANCHOR_RIGHT_UPPER;
     }
   else if(InpTextCorner==RIGHT_LOWER)
     {
      TextCorner=CORNER_RIGHT_LOWER;
      TextAnchor=ANCHOR_RIGHT_LOWER;
     }
  }
//+------------------------------------------------------------------+
