//+------------------------------------------------------------------+
//|                                                  ChandelExit.mq5 |
//|                                                       MQLService |
//|                                           scripts@mqlservice.com |
//+------------------------------------------------------------------+
//----  
#property copyright "MQLService"
#property link      "scripts@mqlservice.com"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrViolet,clrLime
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "UpLoss Line"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int RangePeriod=15;
input int Shift=1;
input int ATRPeriod=14;
input int MultipleATR=4;
//+----------------------------------------------+
//----   ,    
//----      
double UpBuffer[];
double DnBuffer[];
//----      
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=MathMax(ATRPeriod,RangePeriod+Shift);
//----    ATR
   ATR_Handle=iATR(NULL,0,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE) Print("      ATR");
//----      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(UpBuffer,true);
//----      
   SetIndexBuffer(1,DnBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(DnBuffer,true);
//----        min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----      
   string shortname;
   StringConcatenate(shortname,"ChandelExit(",RangePeriod,", ",ATRPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   static int direction;
   int to_copy,limit,bar;
   double ATR[],HH0,LL0;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
      direction=0;
     }
   else limit=rates_total-prev_calculated; //      
//----     
   to_copy=limit+1;
//----       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ATR[bar]*=MultipleATR;
      HH0=high[ArrayMaximum(high,bar+Shift,RangePeriod)]-ATR[bar];
      LL0=low[ArrayMinimum(low,bar+Shift,RangePeriod)]+ATR[bar];
      //---
      if(direction>=0)
        {
         if(close[bar]<HH0)
           {
            if(bar) direction=-1;
            UpBuffer[bar]=LL0;
            DnBuffer[bar]=HH0;
           }
         else
           {
            UpBuffer[bar]=HH0;
            DnBuffer[bar]=LL0;
           }
        }
      else
      if(direction<=0)
        {
         if(close[bar]>LL0)
           {
            if(bar) direction=+1;
            DnBuffer[bar]=LL0;
            UpBuffer[bar]=HH0;
           }
         else
           {
            UpBuffer[bar]=LL0;
            DnBuffer[bar]=HH0;
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
