//+------------------------------------------------------------------+
//|                                                      Entropy.mq5 |
//|                                        Copyright  2008,   Korey | 
//|                                                                  | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Korey"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    1
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1 DRAW_LINE
//----     - 
#property indicator_color1 clrIndianRed
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "Entropy"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_SOLID
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Period_=15; //   
input int Shift=0;    //       
//+----------------------------------------------+
//----   ,    
//----      
double ExtBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    ExtBuffer   
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//----      
   string shortname;
   StringConcatenate(shortname,"Entropy(",Period_,")");
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,Period_);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+4);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//----       
   if(rates_total<Period_+begin) return(0);
//----    
   int first,bar,kkk;
//----                      
   double sumx,sumx2,avgx,rmsx,Price0,Price1,fPrice,P,G;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=Period_+begin; //      
     }
   else
     {
      first=prev_calculated-1; //      
     }
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      sumx=0;
      sumx2=0;
      //---       
      for(int jjj=0; jjj<Period_; jjj++)
        {
         kkk=bar-jjj;
         Price0 = price[kkk];
         Price1 = price[kkk - 1];
         //---
         fPrice=MathLog(Price0/Price1);
         sumx+=fPrice;
         sumx2+=fPrice*fPrice;
        }
      //----       
      avgx = sumx / Period_;
      rmsx = MathSqrt(sumx2/Period_);
      //----      
      P = (1.0 + avgx/rmsx)/2.0;
      G = P * MathLog(1.0 + rmsx) + (1.0 - P) * MathLog(1.0 - rmsx);
      ExtBuffer[bar]=G;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
