//+------------------------------------------------------------------+
//|                                                     ExMassV2.mq5 |
//|                           Copyright  2006, Alex Sidd (Executer) |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Alex Sidd (Executer)"
#property link      "mailto:work_st@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    1
#property indicator_buffers 1 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       MediumPurple 
#property indicator_color1 clrMediumPurple
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "ExMass"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint ExPeriod=8;     // 
input uint Normalize=3;
//+-----------------------------------+
//----   ,    
//      
double ExtBuffer[];
//----      
int  min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(ExPeriod+Normalize);

//----      
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBuffer,true);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"ExMassV2");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----    
   int limit,bar;
   double poss;

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double positive=high[ArrayMaximum(high,bar,ExPeriod)];
      double negative=low[ArrayMinimum(low,bar,ExPeriod)];
      poss=0;
      for(int kkk=1; kkk<int(Normalize); kkk++) poss+=ExtBuffer[MathMin(bar+kkk,rates_total-1)];
      ExtBuffer[bar]=(poss+(positive-negative)/_Point)/Normalize;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
