//+------------------------------------------------------------------+
//|                                                    Fx10Setup.mq5 |
//|                                    Copyright  2006, palanka.com |
//|                                         http://www.metaquotes.ru |                                      
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2006, palanka"
//----    
#property link      "http://www.metaquotes.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//---        
#property indicator_maximum +1.1
#property indicator_minimum +0.3
//+---------------------------------------------+
//|          |
//+---------------------------------------------+
//----   1   
#property indicator_type1   DRAW_HISTOGRAM
//----       LimeGreen 
#property indicator_color1  clrLimeGreen
//----   1 - 
#property indicator_style1  STYLE_SOLID
//----    1  5
#property indicator_width1  5
//----    
#property indicator_label1  "Upper Fx10Setup"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_HISTOGRAM
//----        Tomato
#property indicator_color2  clrTomato
//----   2 - 
#property indicator_style2  STYLE_SOLID
//----    2  5
#property indicator_width2  5
//----    
#property indicator_label2  "Lower Fx10Setup"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double ParmMult=2.0;        // Multiply the standard parameters by this scale factor
input int    Shift=0;             //      
//+----------------------------------------------+
//----   ,   
//----      
double ExtMapBufferUp[];
double ExtMapBufferDown[];
//----      
int FsMa_Handle,SlMa_Handle,STO_Handle,MACD_Handle,RSI_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----    iRSI
   RSI_Handle=iRSI(NULL,0,int(14*ParmMult),PRICE_CLOSE);
   if(RSI_Handle==INVALID_HANDLE)
     {
      Print("      iRSI");
      return(INIT_FAILED);
     }
//----    iMACD
   MACD_Handle=iMACD(NULL,0,int(12*ParmMult),int(26*ParmMult),int(9*ParmMult),PRICE_CLOSE);
   if(MACD_Handle==INVALID_HANDLE)
     {
      Print("      iMACD");
      return(INIT_FAILED);
     }
//----    fast iMA
   FsMa_Handle=iMA(NULL,0,int(5*ParmMult),0,MODE_LWMA,PRICE_CLOSE);
   if(FsMa_Handle==INVALID_HANDLE)
     {
      Print("      fast iMA");
      return(INIT_FAILED);
     }
//----    slow iMA
   SlMa_Handle=iMA(NULL,0,int(10*ParmMult),0,MODE_SMA,PRICE_CLOSE);
   if(SlMa_Handle==INVALID_HANDLE)
     {
      Print("      slow iMA");
      return(INIT_FAILED);
     }
//----    iStochastic
   STO_Handle=iStochastic(NULL,0,int(5*ParmMult),int(3*ParmMult),int(3*ParmMult),MODE_SMA,STO_CLOSECLOSE);
   if(STO_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic");
      return(INIT_FAILED);
     }
//----     
   min_rates_total=int(12*ParmMult+26*ParmMult+9*ParmMult);
//----    ExtMapBufferUp[]   
   SetIndexBuffer(0,ExtMapBufferUp,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----    ,      
   ArraySetAsSeries(ExtMapBufferUp,true);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    ExtMapBufferDown[]   
   SetIndexBuffer(1,ExtMapBufferDown,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    ,      
   ArraySetAsSeries(ExtMapBufferDown,true);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"Fx10Setup(",DoubleToString(ParmMult,4),", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total
      || BarsCalculated(RSI_Handle)<rates_total
      || BarsCalculated(MACD_Handle)<rates_total
      || BarsCalculated(STO_Handle)<rates_total
      || BarsCalculated(FsMa_Handle)<rates_total
      || BarsCalculated(SlMa_Handle)<rates_total)
      return(RESET);
//----    
   double RSI[],FsMa[],SlMa[],MMacd[],SMacd[],MSto[],SSto[];
   bool StochUp,StochDown,RsiUp,RsiDown,MacdUp,MacdDown;
   int limit,to_copy,bar;
//----    ,     
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(RSI,true);
   ArraySetAsSeries(MMacd,true);
   ArraySetAsSeries(SMacd,true);
   ArraySetAsSeries(MSto,true);
   ArraySetAsSeries(SSto,true);
   ArraySetAsSeries(FsMa,true);
   ArraySetAsSeries(SlMa,true);
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-min_rates_total-1;               //      
     }
   else
     {
      limit=rates_total-prev_calculated;                 //      
     }
//---
   to_copy=limit+1;
//----      
   if(CopyBuffer(RSI_Handle,0,0,to_copy,RSI)<=0) return(RESET);
   if(CopyBuffer(MACD_Handle,MAIN_LINE,0,to_copy,MMacd)<=0) return(RESET);
   if(CopyBuffer(MACD_Handle,SIGNAL_LINE,0,to_copy,SMacd)<=0) return(RESET);
   if(CopyBuffer(STO_Handle,MAIN_LINE,0,to_copy,MSto)<=0) return(RESET);
   if(CopyBuffer(STO_Handle,SIGNAL_LINE,0,to_copy,SSto)<=0) return(RESET);
   if(CopyBuffer(FsMa_Handle,0,0,to_copy,FsMa)<=0) return(RESET);
   if(CopyBuffer(SlMa_Handle,0,0,to_copy,SlMa)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtMapBufferUp[bar]=EMPTY_VALUE;
      ExtMapBufferDown[bar]=EMPTY_VALUE;
      //----
      if(FsMa[bar]>SlMa[bar])
        {
         RsiUp=RSI[bar]>=55.0;
         StochUp=(MSto[bar]>SSto[bar]);
         MacdUp=(MMacd[bar]>SMacd[bar]);
         if(StochUp && RsiUp && MacdUp) ExtMapBufferUp[bar]=1;
        }
      else if(FsMa[bar]<SlMa[bar])
        {
         RsiDown=RSI[bar]<=45.0;
         StochDown=(MSto[bar]<SSto[bar]);
         MacdDown=(MMacd[bar]<SMacd[bar]);
         if(StochDown && RsiDown && MacdDown) ExtMapBufferDown[bar]=1;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
