//+------------------------------------------------------------------+
//|                                                        GARCH.mq5 |
//|                            Copyright  2012, Andres Barale Sarti | 
//|                                              http://www.mql5.com | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2012, Andres Barale Sarti"
//---    
#property link "http://www.mql5.com"
#property description "       GARCH  "
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 1
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrRed
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "GARCH"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double e_alpha= 0.010;
input double e_beta = 0.080;
input int  Shift=0;                             //      
//+----------------------------------------------+
//---   ,  
//---       
double IndBuffer[];
double GarchNumVar;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(2);
   GarchNumVar=0.000001;
//---    PVIBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"GARCH");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,6);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[])    //     
  {
//---       
   if(rates_total<min_rates_total+begin) return(RESET);
//---   
   int limit,bar;
   double GarchNum,residual,residualSq;
   static double GarchNumVar_;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=int(rates_total-min_rates_total-begin); //    
      GarchNumVar_=0.0;
     }
   else limit=rates_total-prev_calculated; //      
//---       
   ArraySetAsSeries(price,true);
//---
   GarchNumVar=GarchNumVar_;
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      residual=price[bar]-price[bar+1];
      residualSq=MathPow(residual,2.0);
      GarchNumVar=e_alpha*residualSq+e_beta*GarchNumVar;
      GarchNum=MathSqrt(GarchNumVar);
      IndBuffer[bar]=GarchNum;
      //---
      if(bar) GarchNumVar_=GarchNumVar;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
