//+------------------------------------------------------------------+ 
//|                                                   HL_Average.mq5 | 
//|                                           Copyright  2007, KCBT | 
//|                              http://www.kcbt.ru/forum/index.php? | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2007, KCBT"
#property link "http://www.kcbt.ru/forum/index.php?"
//----   
#property version   "2.00"
#property description "      "
//----     
#property indicator_chart_window
//----    7
#property indicator_buffers 7 
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                         //        
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----     
#property indicator_color1  clrLimeGreen
//----    1  2
#property indicator_width1  2
//----   
#property indicator_label1  "HL Up"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----     
#property indicator_color2  clrDodgerBlue
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  "HL Pivot"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----     
#property indicator_color3  clrMagenta
//----    2  2
#property indicator_width3  2
//----   
#property indicator_label3  "HL Down"
//+----------------------------------------------+
//|     1                |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_FILLING
//----       PaleTurquoise
#property indicator_color4  clrPaleTurquoise
//----   
#property indicator_label4  "HL Up Cloud"
//+----------------------------------------------+
//|     2                |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_FILLING
//----       MistyRose
#property indicator_color5  clrMistyRose
//----   
#property indicator_label5  "HL Down Cloud"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_D1;   //     
input bool ShowComment=true;                 //  
input int  Shift=0;                          //      
//+----------------------------------------------+
//----   ,    
//----      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
double Ind4Buffer[];
double Ind5Buffer[];
double Ind6Buffer[];
double Ind7Buffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck("HL",TimeFrame,Period())) return(INIT_FAILED);
//----   
   min_rates_total=2;
//----   
   BufInit(0,Ind1Buffer);
   BufInit(1,Ind2Buffer);
   BufInit(2,Ind3Buffer);
   BufInit(3,Ind4Buffer);
   BufInit(4,Ind5Buffer);
   BufInit(5,Ind6Buffer);
   BufInit(6,Ind7Buffer);
//----
   IndInit(0,0.0,min_rates_total,Shift);
   IndInit(1,0.0,min_rates_total,Shift);
   IndInit(2,0.0,min_rates_total,Shift);
   IndInit(3,EMPTY_VALUE,min_rates_total,Shift);
   IndInit(4,EMPTY_VALUE,min_rates_total,Shift);
//----           
   string shortname;
   StringConcatenate(shortname,"HL(",EnumToString(TimeFrame),")");
//----
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   Comment("");
//----
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----   
   int limit,bar;
//----       
   double last_close,last_high,last_low,P=0.0,R=0.0,S=0.0;
   datetime iTime[1];
   static uint LastCountBar;
   static double prev_low,prev_high;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
      prev_low=999999999;
      prev_high=0.0;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Ind1Buffer[bar]=0.0;
      Ind2Buffer[bar]=0.0;
      Ind3Buffer[bar]=0.0;
      Ind4Buffer[bar]=0.0;
      Ind5Buffer[bar]=0.0;
      Ind6Buffer[bar]=0.0;
      Ind7Buffer[bar]=0.0;
      //----      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,iTime)<=0) return(RESET);
      //----
      if(time[bar]>=iTime[0] && time[bar+1]<iTime[0])
        {
         LastCountBar=bar;
         Ind1Buffer[bar+1]=0.0;
         Ind2Buffer[bar+1]=0.0;
         Ind3Buffer[bar+1]=0.0;
         Ind4Buffer[bar+1]=0.0;
         Ind5Buffer[bar+1]=0.0;
         Ind6Buffer[bar+1]=0.0;
         Ind7Buffer[bar+1]=0.0;
         //----
         last_close=close[bar+1];
         last_high=prev_high;
         last_low=prev_low;
         P=(last_high+last_low )/2;
         R=last_high;
         S=last_low;
         prev_high=high[bar];
         prev_low=low[bar];
        }
      //----
      prev_high=MathMax(prev_high,high[bar]);
      prev_low=MathMin(prev_low,low[bar]);
      //----      
      Ind4Buffer[bar]=Ind1Buffer[bar]=R;
      Ind6Buffer[bar]=Ind5Buffer[bar]=Ind2Buffer[bar]=P;
      Ind7Buffer[bar]=Ind3Buffer[bar]=S;
     }
//----
   if(ShowComment)
     {
      Comment("Current H=",DoubleToString(R,_Digits),
              ", L=",DoubleToString(S,_Digits),
              ", HL/2=",DoubleToString(P,_Digits),
              ", H-L=",DoubleToString((R-S)/_Point,0));
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void BufInit(int Number,double &Buffer[])
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(Buffer,true);
//----
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----    2    Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES inTFrame, //   
                     ENUM_TIMEFRAMES outTFrame)//  
  {
//----     
   if(inTFrame<=outTFrame)
     {
      Print("    "+IndName+"     ",GetStringTimeframe(inTFrame));
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//----
   return(StringSubstr(EnumToString(timeframe),7,-1));
//----
  }
//+------------------------------------------------------------------+
