//+------------------------------------------------------------------+
//|                                                   i-BB-Width.mq5 | 
//|                        Copyright  2007,   . aka KimIV. | 
//|                                             http://www.kimiv.ru/ | 
//+------------------------------------------------------------------+

#property copyright "Copyright  2007,   . aka KimIV."
#property link "http://www.kimiv.ru/"
#property description "  "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 Blue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  2
//----   
#property indicator_label1  "i-BB-Width"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint bands_period=20; //  
input double deviation=2.0; // 
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE; //    handle
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer[];
//----      
int BB_Handle;
//----      
uint min_rates_total;
//+------------------------------------------------------------------+   
//| i-BB-Width indicator initialization function                     | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=bands_period;
//----    iBearsPower
   BB_Handle=iBands(NULL,0,int(bands_period),0,deviation,applied_price);
   if(BB_Handle==INVALID_HANDLE) Print("      iBands");
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"i-BB-Width(",
                     bands_period,", ",deviation,", ",EnumToString(applied_price),", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| i-BB-Width iteration function                                    | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(BB_Handle)<rates_total || rates_total<int(min_rates_total)) return(RESET);
//----       
   double UpBB[],DnBB[];
//----        
   int limit,bar,to_copy;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=int(rates_total-min_rates_total-1); //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;
//----    ,     
   ArraySetAsSeries(UpBB,true);
   ArraySetAsSeries(DnBB,true);
//----        
   if(CopyBuffer(BB_Handle,UPPER_BAND,0,to_copy,UpBB)<=0) return(RESET);
   if(CopyBuffer(BB_Handle,LOWER_BAND,0,to_copy,DnBB)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--) IndBuffer[bar]=(UpBB[bar]-DnBB[bar])/_Point;
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
