//+------------------------------------------------------------------+
//|                                                           KC.mq5 | 
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description "ATR channel"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    3
#property indicator_buffers 3 
//----   5  
#property indicator_plots   3
//+--------------------------------------------+ 
//|                          |
//+--------------------------------------------+
#define RESET 0  //        
//+--------------------------------------------+
//|                |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       - 
#property indicator_color1 BlueViolet
//----   -  
#property indicator_style1  STYLE_DASHDOTDOT
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "MA"
//+--------------------------------------------+
//|                    |
//+--------------------------------------------+
//----      
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//----    
#property indicator_color2  Red
#property indicator_color3  Red
//----   -  
#property indicator_style2 STYLE_DASHDOTDOT
#property indicator_style3 STYLE_DASHDOTDOT
//----     1
#property indicator_width2  1
#property indicator_width3  1
//----    
#property indicator_label2  "+ATR"
#property indicator_label3  "-ATR"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_MA_METHOD MA_Method=MODE_SMA; //   MA
input uint MA_Period=20;                 //  MA
input uint ATR_Period=20;                //  ATR
input double Factor=1.5;                 //   
input ENUM_APPLIED_PRICE IPC=PRICE_CLOSE;//  
input int Shift=0;                       //      
//+-----------------------------------+
//----   ,    
//----      
double MA_Buffer[],UpATRBuffer[],DnATRBuffer[];
//----      
int MA_Handle,ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(MathMax(MA_Period,ATR_Period));
//----    MA
   MA_Handle=iMA(NULL,0,MA_Period,0,MA_Method,IPC);
   if(MA_Handle==INVALID_HANDLE) Print("      MA");
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE) Print("      ATR");
//----      
   SetIndexBuffer(0,MA_Buffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----    ,   
   ArraySetAsSeries(MA_Buffer,true);
//----      
   SetIndexBuffer(1,UpATRBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,DnATRBuffer,INDICATOR_DATA);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----  ,     
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    ,   
   ArraySetAsSeries(UpATRBuffer,true);
   ArraySetAsSeries(DnATRBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"ATR channel");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(MA_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----    
   int limit,to_copy;
   double ATR[],atr;
//----         
   ArraySetAsSeries(ATR,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      

   to_copy=limit+1;
//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
   if(CopyBuffer(MA_Handle,0,0,to_copy,MA_Buffer)<=0) return(RESET);
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      atr=Factor*ATR[bar];
      UpATRBuffer[bar]=MA_Buffer[bar]+atr;
      DnATRBuffer[bar]=MA_Buffer[bar]-atr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
