//+------------------------------------------------------------------+
//|                                                      MACD_DL.mq5 |
//|                                          Copyright 2009, Mr.Zhjp |
//|                                            mail://mrzhjp@163.com |
//+------------------------------------------------------------------+
#property copyright   "2009, Mr.Zhjp"
#property link        "mrzhjp@163.com"
#property description "Moving Average Convergence/Divergence"
#include <MovingAverages.mqh>
//--- indicator settings
#property indicator_separate_window
#property indicator_buffers 6
#property indicator_plots   4                         // New
#property indicator_type1   DRAW_LINE
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_HISTOGRAM
#property indicator_type4   DRAW_HISTOGRAM
#property indicator_color1  White
#property indicator_color2  Yellow
#property indicator_color3  Red
#property indicator_color4  Turquoise
#property indicator_width1  1
#property indicator_width2  1
#property indicator_width3  1
#property indicator_width4  1
#property indicator_label1  "DIFF"
#property indicator_label2  "DEA"
#property indicator_label3  "MACD"
#property indicator_label4  "MACD"
//--- input parameters
input int                InpFastEMA=12;               // Fast EMA period  // New
input int                InpSlowEMA=26;               // Slow EMA period
input int                InpSignalSMA=9;              // Signal SMA period
input ENUM_APPLIED_PRICE InpAppliedPrice=PRICE_CLOSE; // Applied price
//--- indicator buffers
double                   ExtDIFFBuffer[];
double                   ExtDEABuffer[];
double                   ExtMACDRBuffer[];
double                   ExtMACDGBuffer[];
double                   ExtFastMaBuffer[];
double                   ExtSlowMaBuffer[];
//--- MA handles
int                      ExtFastMaHandle;
int                      ExtSlowMaHandle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,ExtDIFFBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtDEABuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtMACDRBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtMACDGBuffer,INDICATOR_DATA);
   SetIndexBuffer(4,ExtFastMaBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,ExtSlowMaBuffer,INDICATOR_CALCULATIONS);
//--- sets first bar from what index will be drawn
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,InpSignalSMA-1);              // New
//--- name for Dindicator subwindow label
   IndicatorSetString(INDICATOR_SHORTNAME,"MACD_DL("+string(InpFastEMA)+","+string(InpSlowEMA)+","+string(InpSignalSMA)+")");
//--- get MA handles
   ExtFastMaHandle=iMA(NULL,0,InpFastEMA,0,MODE_EMA,InpAppliedPrice);
   ExtSlowMaHandle=iMA(NULL,0,InpSlowEMA,0,MODE_EMA,InpAppliedPrice);
//--- initialization done
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,const int prev_calculated,
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &TickVolume[],
                const long &Volume[],
                const int &Spread[])
  {
//--- check for data
   if(rates_total<InpSignalSMA)
      return(0);
//--- not all data may be calculated
   int calculated=BarsCalculated(ExtFastMaHandle);
   if(calculated<rates_total)
     {
      Print("Not all data of ExtFastMaHandle is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
   calculated=BarsCalculated(ExtSlowMaHandle);
   if(calculated<rates_total)
     {
      Print("Not all data of ExtSlowMaHandle is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
//--- we can copy not all data
   int to_copy;
   if(prev_calculated>rates_total || prev_calculated<0) to_copy=rates_total;
   else
     {
      to_copy=rates_total-prev_calculated;
      if(prev_calculated>0) to_copy++;
     }
//--- get Fast EMA buffer
   if(CopyBuffer(ExtFastMaHandle,0,0,to_copy,ExtFastMaBuffer)<=0)
     {
      Print("Getting fast EMA is failed! Error",GetLastError());
      return(0);
     }
//--- get SlowSMA buffer
   if(CopyBuffer(ExtSlowMaHandle,0,0,to_copy,ExtSlowMaBuffer)<=0)
     {
      Print("Getting slow SMA is failed! Error",GetLastError());
      return(0);
     }
//---
   int limit;
   if(prev_calculated==0)
      limit=0;
   else limit=prev_calculated-1;
//--- calculate DIFF
   for(int i=limit;i<rates_total;i++)
      ExtDIFFBuffer[i]=ExtFastMaBuffer[i]-ExtSlowMaBuffer[i];
//--- calculate DEA
   SimpleMAOnBuffer(rates_total,prev_calculated,0,InpSignalSMA,ExtDIFFBuffer,ExtDEABuffer);
//--- calculate MACD
   for(int i=limit;i<rates_total;i++)
   {
      if(ExtDIFFBuffer[i] > ExtDEABuffer[i]) 
      {
          ExtMACDRBuffer[i] = 2*(ExtDIFFBuffer[i]-ExtDEABuffer[i]); 
          ExtMACDGBuffer[i] = 0;
      }
      else
      {
          ExtMACDGBuffer[i] = 2*(ExtDIFFBuffer[i]-ExtDEABuffer[i]); 
          ExtMACDRBuffer[i] = 0;
      }
   }      
//--- OnCalculate done. Return new prev_calculated.
   return(rates_total);
  }
//+------------------------------------------------------------------+
