//+------------------------------------------------------------------+
//|                                           New_Fractals_Lines.mq4 |
//|                                       Copyright  2007, olyakish |
//|                                           plutonia-dmb#yandex.ru |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, olyakish"
//---    
#property link      "plutonia-dmb#yandex.ru"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|          |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---      Crimson 
#property indicator_color1  clrCrimson
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Down Fractal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---      LimeGreen 
#property indicator_color2  clrLimeGreen
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2 "Up Fractal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  //  
input int  UpLabel=164;                            //   
input int  DnLabel=164;                            //   
//+----------------------------------------------+
//---   ,   
//---      
double DnBuffer[];
double UpBuffer[];
//---
int min_rates_total;
int FRA_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   min_rates_total=3;
//---    iFractals
   FRA_Handle=iFractals(Symbol(),PERIOD_CURRENT);
   if(FRA_Handle==INVALID_HANDLE)
     {
      Print("      iFractals");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,DnBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,UpLabel);
//---       
   ArraySetAsSeries(DnBuffer,true);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   SetIndexBuffer(1,UpBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,DnLabel);
//---       
   ArraySetAsSeries(UpBuffer,true);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="New_Fractals_Lines";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(FRA_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit;
   double AllHLUp,AllMFIUp,AllHLDown,AllMFIDown,UpFractal[],DnFractal[];
   long AllVolDown,AllVolUp;
   bool Up,Down;
   static int OldFractal;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      OldFractal=0;
     }
   else
     {
      limit=rates_total-prev_calculated+min_rates_total; //      
     }
   to_copy=limit+1+min_rates_total;
//---       UpFractal  DnFractal
   if(CopyBuffer(FRA_Handle,0,0,to_copy,UpFractal)<=0) return(RESET);
   if(CopyBuffer(FRA_Handle,1,0,to_copy,DnFractal)<=0) return(RESET);
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(UpFractal,true);
   ArraySetAsSeries(DnFractal,true);
   if(VolumeType==VOLUME_TICK) ArraySetAsSeries(tick_volume,true);
   else ArraySetAsSeries(volume,true);
//---    
   for(int bar=2; bar<=limit && !IsStopped(); bar++)
     {
      UpBuffer[bar]=EMPTY_VALUE;
      DnBuffer[bar]=EMPTY_VALUE;
      //---
      if(UpFractal[bar] && UpFractal[bar]!=EMPTY_VALUE)
        {
         Up=true;
         Down=false;
        }
      if(DnFractal[bar] && DnFractal[bar]!=EMPTY_VALUE)
        {
         Up=false;
         Down=true;
        }
      //---    - 
      if(UpFractal[bar] && UpFractal[bar]!=EMPTY_VALUE && DnFractal[bar] && DnFractal[bar]!=EMPTY_VALUE)
        {
         Up=false;
         Down=false;
        }
      //---
      if(!Up && Down)
        {
         AllHLDown=high[bar+2]-low[bar+2]+high[bar+1]-low[bar+1]+high[bar]-low[bar]+high[bar-1]-low[bar-1]+high[bar-2]-low[bar-2];
         AllVolDown=VolSum(VolumeType,tick_volume,volume,bar);
         AllMFIDown=AllHLDown/AllVolDown;
         if(OldFractal==1 && AllMFIDown<AllMFIUp && AllVolDown>AllVolUp) DnBuffer[bar]=DnFractal[bar];
         OldFractal=0;
        }
      //---
      if(Up && !Down)
        {
         AllHLUp=high[bar+2]-low[bar+2]+high[bar+1]-low[bar+1]+high[bar]-low[bar]+high[bar-1]-low[bar-1]+high[bar-2]-low[bar-2];
         AllVolUp=VolSum(VolumeType,tick_volume,volume,bar);
         AllMFIUp=AllHLUp/AllVolUp;
         if(OldFractal==0 && AllMFIUp<AllMFIDown && AllVolUp>AllVolDown) UpBuffer[bar]=UpFractal[bar];
         OldFractal=1;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| VolSum()                                                         |
//+------------------------------------------------------------------+    
long VolSum(ENUM_APPLIED_VOLUME VolType,
            const long &Tick_Volume[],
            const long &Volume[],
            int index)
  {
//---
   long Vol;
   if(VolType==VOLUME_REAL) Vol=Volume[index+2]+Volume[index+1]+Volume[index]+Volume[index-1]+Volume[index-2];
   else Vol=Tick_Volume[index+2]+Tick_Volume[index+1]+Tick_Volume[index]+Tick_Volume[index-1]+Tick_Volume[index-2];
//---
   return(Vol);
  }
//+------------------------------------------------------------------+
